/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIRegistry;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphExecuter;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;

public class GraphPanel
extends JPanel
implements ActionListener,
PopupMenuListener,
MouseListener,
MouseMotionListener {
    private final GraphExecuter graphEx;
    private JMenu addMenu;
    private Point lastMousePos = null;
    private final AddMenuListener addListener = new AddMenuListener(this);
    private final ConnectMenuListener connectListener = new ConnectMenuListener(this);
    private final RemoveSourceMenuListener removeSourceListener = new RemoveSourceMenuListener(this);
    private static final ImageIcon opIcon = new ImageIcon(GraphPanel.class.getClassLoader().getResource("org/esa/snap/graphbuilder/icons/operator.png"));
    private static final ImageIcon folderIcon = new ImageIcon(GraphPanel.class.getClassLoader().getResource("org/esa/snap/graphbuilder/icons/folder.png"));
    private static final Font font = new Font("Ariel", 1, 10);
    private static final Color opColor = new Color(0, 177, 255, 128);
    private static final Color selColor = new Color(200, 255, 200, 150);
    private static final char[] folderDelim = new char[]{'/'};
    private GraphNode selectedNode = null;
    private boolean showHeadHotSpot = false;
    private boolean showTailHotSpot = false;
    private boolean connectingSourceFromHead = false;
    private boolean connectingSourceFromTail = false;
    private Point connectingSourcePos = null;
    private GraphNode connectSourceTargetNode = null;
    private boolean showRightClickHelp = false;

    public GraphPanel(GraphExecuter graphExec) {
        this.graphEx = graphExec;
        this.CreateAddOpMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void CreateAddOpMenu() {
        this.addMenu = new JMenu("Add");
        Set<String> gpfOperatorSet = this.graphEx.GetOperatorList();
        Object[] gpfOperatorList = new String[gpfOperatorSet.size()];
        gpfOperatorSet.toArray(gpfOperatorList);
        Arrays.sort(gpfOperatorList);
        for (Object anAlias : gpfOperatorList) {
            if (this.graphEx.isOperatorInternal((String)anAlias) || !OperatorUIRegistry.showInGraphBuilder((String)anAlias)) continue;
            String category = this.graphEx.getOperatorCategory((String)anAlias);
            JMenu menu = this.addMenu;
            if (!category.isEmpty()) {
                String[] categoryPath;
                for (String folder : categoryPath = StringUtils.split((String)category, (char[])folderDelim, (boolean)true)) {
                    menu = GraphPanel.getMenuFolder(folder, menu);
                }
            }
            JMenuItem item = new JMenuItem((String)anAlias, opIcon);
            item.setHorizontalTextPosition(4);
            item.addActionListener(this.addListener);
            menu.add(item);
        }
    }

    private static JMenu getMenuFolder(String folderName, JMenu currentMenu) {
        int insertPnt = 0;
        for (int i = 0; i < currentMenu.getItemCount(); ++i) {
            JMenuItem item = currentMenu.getItem(i);
            if (!(item instanceof JMenu)) continue;
            int comp = item.getText().compareToIgnoreCase(folderName);
            if (comp == 0) {
                return (JMenu)item;
            }
            if (comp >= 0) continue;
            ++insertPnt;
        }
        JMenu newMenu = new JMenu(folderName);
        newMenu.setIcon(folderIcon);
        currentMenu.insert(newMenu, insertPnt);
        return newMenu;
    }

    void AddOperatorAction(String name) {
        GraphNode newGraphNode = this.graphEx.addOperator(name);
        newGraphNode.setPos(this.lastMousePos);
        this.repaint();
    }

    void RemoveSourceAction(String id) {
        if (this.selectedNode != null) {
            GraphNode source = this.graphEx.getGraphNodeList().findGraphNode(id);
            this.selectedNode.disconnectOperatorSources(source.getID());
            this.repaint();
        }
    }

    void AutoConnectGraph() {
        if (!this.graphEx.getGraphNodeList().isGraphComplete()) {
            this.graphEx.autoConnectGraph();
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String name = event.getActionCommand();
        if (name.equals("Delete")) {
            this.graphEx.removeOperator(this.selectedNode);
            this.repaint();
        }
    }

    private void checkPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(this.addMenu);
            if (this.selectedNode != null) {
                JMenuItem item = new JMenuItem("Delete");
                popup.add(item);
                item.setHorizontalTextPosition(4);
                item.addActionListener(this);
                NodeSource[] sources = this.selectedNode.getNode().getSources();
                if (sources.length > 0) {
                    JMenu removeSourcedMenu = new JMenu("Remove Source");
                    for (NodeSource ns : sources) {
                        JMenuItem nsItem = new JMenuItem(ns.getSourceNodeId());
                        removeSourcedMenu.add(nsItem);
                        nsItem.setHorizontalTextPosition(4);
                        nsItem.addActionListener(this.removeSourceListener);
                    }
                    popup.add(removeSourcedMenu);
                }
            }
            if (!this.graphEx.getGraphNodeList().isGraphComplete()) {
                JMenuItem connectItem = new JMenuItem("Connect Graph", null);
                connectItem.setHorizontalTextPosition(4);
                connectItem.addActionListener(this.connectListener);
                popup.add(connectItem);
            }
            popup.setLabel("Justification");
            popup.setBorder(new BevelBorder(0));
            popup.addPopupMenuListener(this);
            popup.show(this, e.getX(), e.getY());
            this.showRightClickHelp = false;
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.DrawGraph(g2, this.graphEx.GetGraphNodes());
    }

    private void DrawGraph(Graphics2D g, List<GraphNode> nodeList) {
        Point p2;
        Point p1;
        g.setFont(font);
        if (this.showRightClickHelp) {
            GraphPanel.drawHelp(g);
        }
        for (GraphNode n : nodeList) {
            if (n == this.selectedNode) {
                n.drawNode(g, selColor);
                continue;
            }
            n.drawNode(g, opColor);
        }
        for (GraphNode n : nodeList) {
            NodeSource[] nSources;
            g.setColor(Color.red);
            for (NodeSource nSource : nSources = n.getNode().getSources()) {
                GraphNode srcNode = this.graphEx.getGraphNodeList().findGraphNode(nSource.getSourceNodeId());
                if (srcNode == null) continue;
                n.drawConnectionLine(g, srcNode);
            }
        }
        if (this.showHeadHotSpot && this.selectedNode != null) {
            this.selectedNode.drawHeadHotspot(g, Color.red);
        }
        if (this.showTailHotSpot && this.selectedNode != null) {
            this.selectedNode.drawTailHotspot(g, Color.red);
        }
        if (this.connectingSourceFromHead && this.connectSourceTargetNode != null) {
            p1 = this.connectSourceTargetNode.getPos();
            p2 = this.connectingSourcePos;
            if (p1 != null && p2 != null) {
                g.setColor(Color.red);
                g.drawLine(p1.x, p1.y + this.connectSourceTargetNode.getHalfNodeHeight(), p2.x, p2.y);
            }
        } else if (this.connectingSourceFromTail && this.connectSourceTargetNode != null) {
            p1 = this.connectSourceTargetNode.getPos();
            p2 = this.connectingSourcePos;
            if (p1 != null && p2 != null) {
                g.setColor(Color.red);
                g.drawLine(p1.x + this.connectSourceTargetNode.getWidth(), p1.y + this.connectSourceTargetNode.getHalfNodeHeight(), p2.x, p2.y);
            }
        }
    }

    public void showRightClickHelp(boolean flag) {
        this.showRightClickHelp = flag;
    }

    private static void drawHelp(Graphics g) {
        int x = (int)(g.getClipBounds().getWidth() / 2.0);
        int y = (int)(g.getClipBounds().getHeight() / 2.0);
        FontMetrics metrics = g.getFontMetrics();
        String name = "Right click here to add an operator";
        Rectangle2D rect = metrics.getStringBounds("Right click here to add an operator", g);
        int stringWidth = (int)rect.getWidth();
        g.setColor(Color.black);
        g.drawString("Right click here to add an operator", x - stringWidth / 2, y);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopup(e);
        if (this.showHeadHotSpot) {
            this.connectingSourceFromHead = true;
        } else if (this.showTailHotSpot) {
            this.connectingSourceFromTail = true;
        }
        this.lastMousePos = e.getPoint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkPopup(e);
        this.showRightClickHelp = false;
        if (this.selectedNode != null) {
            this.graphEx.setSelectedNode(this.selectedNode);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        GraphNode n;
        this.checkPopup(e);
        if (this.connectingSourceFromHead) {
            GraphNode n2 = this.findNode(e.getPoint());
            if (n2 != null && this.selectedNode != n2) {
                this.connectSourceTargetNode.connectOperatorSource(n2.getID());
            }
        } else if (this.connectingSourceFromTail && (n = this.findNode(e.getPoint())) != null && this.selectedNode != n) {
            n.connectOperatorSource(this.connectSourceTargetNode.getID());
        }
        this.connectingSourceFromHead = false;
        this.connectingSourceFromTail = false;
        this.connectSourceTargetNode = null;
        if (this.graphEx.getGraphNodeList().isGraphComplete()) {
            this.graphEx.notifyConnection();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedNode != null && !this.connectingSourceFromHead && !this.connectingSourceFromTail) {
            Point p = new Point(e.getX() - (this.lastMousePos.x - this.selectedNode.getPos().x), e.getY() - (this.lastMousePos.y - this.selectedNode.getPos().y));
            this.selectedNode.setPos(p);
            this.lastMousePos = e.getPoint();
            this.repaint();
        }
        if (this.connectingSourceFromHead || this.connectingSourceFromTail) {
            this.connectingSourcePos = e.getPoint();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        GraphNode n = this.findNode(e.getPoint());
        if (this.selectedNode != n) {
            this.showHeadHotSpot = false;
            this.showTailHotSpot = false;
            this.selectedNode = n;
            this.repaint();
        }
        if (this.selectedNode != null) {
            int hotspotSize = GraphNode.getHotSpotSize();
            Point headPoint = new Point(n.getPos().x, n.getPos().y + this.selectedNode.getHotSpotOffset());
            Point tailPoint = new Point(n.getPos().x + n.getWidth() - hotspotSize, n.getPos().y + this.selectedNode.getHotSpotOffset());
            if (GraphPanel.isWithinRect(headPoint, hotspotSize, hotspotSize, e.getPoint())) {
                this.showHeadHotSpot = true;
                this.connectSourceTargetNode = this.selectedNode;
                this.repaint();
            } else if (GraphPanel.isWithinRect(tailPoint, hotspotSize, hotspotSize, e.getPoint())) {
                this.showTailHotSpot = true;
                this.connectSourceTargetNode = this.selectedNode;
                this.repaint();
            } else if (this.showHeadHotSpot || this.showTailHotSpot) {
                this.showHeadHotSpot = false;
                this.showTailHotSpot = false;
                this.repaint();
            }
        }
    }

    private GraphNode findNode(Point p) {
        for (GraphNode n : this.graphEx.GetGraphNodes()) {
            if (!GraphPanel.isWithinRect(n.getPos(), n.getWidth(), n.getHeight(), p)) continue;
            return n;
        }
        return null;
    }

    private static boolean isWithinRect(Point o, int width, int height, Point p) {
        return p.x > o.x && p.y > o.y && p.x < o.x + width && p.y < o.y + height;
    }

    static class RemoveSourceMenuListener
    implements ActionListener {
        final GraphPanel graphPanel;

        RemoveSourceMenuListener(GraphPanel panel) {
            this.graphPanel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.graphPanel.RemoveSourceAction(event.getActionCommand());
        }
    }

    static class ConnectMenuListener
    implements ActionListener {
        final GraphPanel graphPanel;

        ConnectMenuListener(GraphPanel panel) {
            this.graphPanel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.graphPanel.AutoConnectGraph();
        }
    }

    static class AddMenuListener
    implements ActionListener {
        final GraphPanel graphPanel;

        AddMenuListener(GraphPanel panel) {
            this.graphPanel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.graphPanel.AddOperatorAction(event.getActionCommand());
        }
    }
}

