/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.XppDomReader;
import com.thoughtworks.xstream.io.xml.XppDomWriter;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;

public class ApplicationData {
    private final String appId;
    private final XppDom data;

    public ApplicationData(String string, XppDom xpp3Dom) {
        this.appId = string;
        this.data = xpp3Dom;
    }

    public String getId() {
        return this.appId;
    }

    public XppDom getData() {
        return this.data;
    }

    public static class AppConverter
    implements Converter {
        private static final String ID_ATTRIBUTE_NAME = "id";

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            XppDom[] children;
            ApplicationData applicationData = (ApplicationData)source;
            writer.addAttribute(ID_ATTRIBUTE_NAME, applicationData.appId);
            for (XppDom child : children = applicationData.data.getChildren()) {
                HierarchicalStreamCopier copier = new HierarchicalStreamCopier();
                XppDomReader reader = new XppDomReader(child);
                copier.copy((HierarchicalStreamReader)reader, writer);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            HierarchicalStreamCopier copier = new HierarchicalStreamCopier();
            XppDomWriter xppDomWriter = new XppDomWriter();
            String appId = reader.getAttribute(ID_ATTRIBUTE_NAME);
            copier.copy(reader, (HierarchicalStreamWriter)xppDomWriter);
            XppDom xpp3Dom = xppDomWriter.getConfiguration();
            return new ApplicationData(appId, xpp3Dom);
        }

        public boolean canConvert(Class type) {
            return ApplicationData.class.equals((Object)type);
        }
    }
}

