/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.core.util.StringUtils;

public class SourceList {
    private List<NodeSource> sourceList = new ArrayList<NodeSource>();

    public NodeSource[] getSources() {
        return this.sourceList.toArray(new NodeSource[this.sourceList.size()]);
    }

    public NodeSource getSource(int index) {
        return this.sourceList.get(index);
    }

    public void addSource(NodeSource source) {
        String sourceId = source.getSourceNodeId();
        for (NodeSource nodeSource : this.sourceList) {
            if (!nodeSource.getSourceNodeId().equals(sourceId)) continue;
            throw new IllegalArgumentException("duplicated source node id");
        }
        this.sourceList.add(source);
    }

    public void removeSource(NodeSource source) {
        this.sourceList.remove(source);
    }

    public static class Converter
    implements com.thoughtworks.xstream.converters.Converter {
        public boolean canConvert(Class aClass) {
            return SourceList.class.equals((Object)aClass);
        }

        public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            NodeSource[] sources;
            SourceList sourceList = (SourceList)object;
            for (NodeSource source : sources = sourceList.getSources()) {
                hierarchicalStreamWriter.startNode(source.getName());
                hierarchicalStreamWriter.addAttribute("refid", source.getSourceNodeId());
                hierarchicalStreamWriter.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
            SourceList sourceList = new SourceList();
            while (hierarchicalStreamReader.hasMoreChildren()) {
                hierarchicalStreamReader.moveDown();
                String name = hierarchicalStreamReader.getNodeName();
                if ("sourceProducts".equals(name)) {
                    String sourceNodeIdsString = hierarchicalStreamReader.getValue().trim();
                    if (StringUtils.isNotNullAndNotEmpty((String)sourceNodeIdsString)) {
                        String[] sourceNodeIds = StringUtils.csvToArray((String)sourceNodeIdsString);
                        for (int i = 0; i < sourceNodeIds.length; ++i) {
                            String sourceNodeId = sourceNodeIds[i];
                            sourceList.addSource(new NodeSource(String.format("%s%d", name, i), sourceNodeId));
                        }
                    }
                } else {
                    String refid = hierarchicalStreamReader.getAttribute("refid");
                    if (refid == null) {
                        refid = hierarchicalStreamReader.getValue().trim();
                    }
                    sourceList.addSource(new NodeSource(name, refid));
                }
                hierarchicalStreamReader.moveUp();
            }
            return sourceList;
        }
    }
}

