/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.gpf.graph.Header;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.internal.ApplicationData;

public class Graph {
    public static final String CURRENT_VERSION = "1.0";
    private String id;
    private String version;
    private Header header;
    private List<Node> nodeList;
    private List<ApplicationData> applicationData;

    public Graph(String id) {
        this.id = id;
        this.version = CURRENT_VERSION;
        this.init();
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Header getHeader() {
        return this.header;
    }

    public int getNodeCount() {
        return this.nodeList.size();
    }

    public void addNode(Node node) {
        if (this.nodeList.contains(this.getNode(node.getId()))) {
            throw new IllegalArgumentException("node ID duplicated");
        }
        this.nodeList.add(node);
    }

    public boolean removeNode(String id) {
        return this.nodeList.remove(this.getNode(id));
    }

    public Node getNode(int index) {
        return this.nodeList.get(index);
    }

    public Node getNode(String id) {
        for (Node node : this.nodeList) {
            if (!node.getId().equalsIgnoreCase(id)) continue;
            return node;
        }
        return null;
    }

    public Node[] getNodes() {
        return this.nodeList.toArray(new Node[this.nodeList.size()]);
    }

    public XppDom getApplicationData(String appId) {
        for (ApplicationData appData : this.applicationData) {
            if (!appData.getId().equals(appId)) continue;
            return appData.getData();
        }
        return null;
    }

    public void setAppData(String id, XppDom data) {
        for (int i = 0; i < this.applicationData.size(); ++i) {
            if (!this.applicationData.get(i).getId().equals(id)) continue;
            this.applicationData.remove(i);
            break;
        }
        ApplicationData appData = new ApplicationData(id, data);
        this.applicationData.add(appData);
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    private void init() {
        if (this.nodeList == null) {
            this.nodeList = new ArrayList<Node>();
        }
        if (this.applicationData == null) {
            this.applicationData = new ArrayList<ApplicationData>();
        }
    }
}

