/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.descriptor.SourceProductsDescriptor;

public class AnnotationSourceProductsDescriptor
implements SourceProductsDescriptor {
    private final SourceProducts annotation;
    private final String name;

    public AnnotationSourceProductsDescriptor(String name, SourceProducts annotation) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)annotation, (String)"annotation");
        this.name = name;
        this.annotation = annotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SourceProducts getAnnotation() {
        return this.annotation;
    }

    @Override
    public int getCount() {
        return this.annotation.count();
    }

    @Override
    public String getProductType() {
        return AnnotationSourceProductsDescriptor.getNonEmptyStringOrNull(this.annotation.type());
    }

    @Override
    public String[] getBands() {
        return this.annotation.bands();
    }

    @Override
    public String getAlias() {
        return AnnotationSourceProductsDescriptor.getNonEmptyStringOrNull(this.annotation.alias());
    }

    @Override
    public String getDescription() {
        return AnnotationSourceProductsDescriptor.getNonEmptyStringOrNull(this.annotation.description());
    }

    @Override
    public String getLabel() {
        return AnnotationSourceProductsDescriptor.getNonEmptyStringOrNull(this.annotation.label());
    }

    @Override
    public Class<? extends Product[]> getDataType() {
        return Product[].class;
    }

    private static String getNonEmptyStringOrNull(String label) {
        return label == null || label.isEmpty() ? null : label;
    }
}

