/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Read", category="Input-Output", version="1.2", authors="Marco Zuehlke, Norman Fomferra", copyright="(c) 2010 by Brockmann Consult", description="Reads a data product from a given file location.")
public class ReadOp
extends Operator {
    @Parameter(description="The file from which the data product is read.", notNull=true, notEmpty=true)
    private File file;
    @Parameter(description="An (optional) format name.", notNull=false, notEmpty=true)
    private String formatName;
    @TargetProduct
    private Product targetProduct;

    @Override
    public void initialize() throws OperatorException {
        if (this.file == null) {
            throw new OperatorException("The 'file' parameter is not set");
        }
        if (!this.file.exists()) {
            throw new OperatorException(String.format("Specified 'file' [%s] does not exist.", this.file));
        }
        try {
            Product openedProduct = this.getOpenedProduct();
            if (openedProduct != null) {
                this.targetProduct = new Product(openedProduct.getName(), openedProduct.getProductType(), openedProduct.getSceneRasterWidth(), openedProduct.getSceneRasterHeight());
                for (Band srcband : openedProduct.getBands()) {
                    if (this.targetProduct.getBand(srcband.getName()) != null) continue;
                    if (srcband instanceof VirtualBand) {
                        ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)srcband), (String)srcband.getName());
                        continue;
                    }
                    ProductUtils.copyBand((String)srcband.getName(), (Product)openedProduct, (Product)this.targetProduct, (boolean)true);
                }
                ProductUtils.copyProductNodes((Product)openedProduct, (Product)this.targetProduct);
            } else {
                ProductReader productReader;
                if (this.formatName != null && !this.formatName.trim().isEmpty()) {
                    productReader = ProductIO.getProductReader((String)this.formatName);
                    if (productReader == null) {
                        throw new OperatorException("No product reader found for format '" + this.formatName + "'");
                    }
                } else {
                    productReader = ProductIO.getProductReaderForInput((Object)this.file);
                    if (productReader == null) {
                        throw new OperatorException("No product reader found for file " + this.file);
                    }
                }
                this.targetProduct = productReader.readProductNodes((Object)this.file, null);
                this.targetProduct.setFileLocation(this.file);
            }
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    private Product getOpenedProduct() {
        Product[] openedProducts;
        for (Product openedProduct : openedProducts = this.getProductManager().getProducts()) {
            if (!this.file.equals(openedProduct.getFileLocation())) continue;
            return openedProduct;
        }
        return null;
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData dataBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.targetProduct.getProductReader().readBandRasterData(band, rectangle.x, rectangle.y, rectangle.width, rectangle.height, dataBuffer, pm);
            targetTile.setRawSamples(dataBuffer);
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ReadOp.class);
        }
    }
}

