/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.monitor;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.internal.OperatorImage;
import org.esa.snap.core.gpf.monitor.TileComputationEvent;
import org.esa.snap.core.gpf.monitor.TileComputationObserver;

public class TileUsageReportGenerator
extends TileComputationObserver {
    public static final int CHART_WIDTH = 1500;
    private final List<TileComputationEvent> recordedEventList = Collections.synchronizedList(new LinkedList());
    private File[] files;
    private boolean active;

    @Override
    public void start() {
        File cwd = new File(".");
        this.files = cwd.listFiles(new VmFilenameFilter());
        if (this.files != null && this.files.length > 0) {
            this.getLogger().info("Starting observation of tile computation events.");
            this.active = true;
        } else {
            this.getLogger().warning(String.format("No Velocity template files (*.vm) found in %s", cwd.getAbsolutePath()));
        }
    }

    @Override
    public void tileComputed(TileComputationEvent event) {
        if (this.active) {
            this.recordedEventList.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.active) {
            return;
        }
        this.getLogger().info("Stopped observation of tile computation events. Generating reports...");
        TileComputationEvent[] events = this.recordedEventList.toArray(new TileComputationEvent[0]);
        Arrays.sort(events, new GroupingComparator(new StartTimeComparator(), new TileIndicesComparator()));
        long startNanosMin = Long.MAX_VALUE;
        long endNanosMax = Long.MIN_VALUE;
        for (TileComputationEvent event : events) {
            startNanosMin = Math.min(startNanosMin, event.getStartNanos());
            endNanosMax = Math.max(endNanosMax, event.getEndNanos());
        }
        Task[] tasks = this.getTasks(events, startNanosMin, endNanosMax);
        this.setSameTasks(tasks);
        VelocityEngine ve = new VelocityEngine();
        try {
            ve.init();
        }
        catch (Exception e) {
            this.getLogger().warning(String.format("Failed to initialise Velocity engine: %s", e.getMessage()));
            return;
        }
        VelocityContext context = new VelocityContext();
        context.put("docTitle", (Object)TileUsageReportGenerator.class.getName());
        context.put("chartWidth", (Object)1500);
        context.put("totalTime", (Object)TileUsageReportGenerator.nanosToRoundedSecs(endNanosMax - startNanosMin));
        context.put("events", (Object)events);
        context.put("tasks", (Object)tasks);
        for (File file : this.files) {
            String templateName = file.getName();
            String outputName = templateName.substring(0, templateName.lastIndexOf(46));
            try {
                Template temp = ve.getTemplate(templateName);
                try (FileWriter writer = new FileWriter(outputName);){
                    temp.merge((Context)context, (Writer)writer);
                }
                this.getLogger().info(String.format("%s written.", outputName));
            }
            catch (Exception e) {
                this.getLogger().warning(String.format("Failed to process Velocity template %s: %s", templateName, e.getMessage()));
            }
        }
    }

    private void setSameTasks(Task[] tasks) {
        Map<String, Set<Task>> sameTasksMap = this.getSameTasksMap(tasks);
        Set<Map.Entry<String, Set<Task>>> entries = sameTasksMap.entrySet();
        for (Map.Entry<String, Set<Task>> entry : entries) {
            Task[] sameTasks = entry.getValue().toArray(new Task[entry.getValue().size()]);
            if (sameTasks.length <= 1) continue;
            Arrays.sort(sameTasks, new Comparator<Task>(){

                @Override
                public int compare(Task o1, Task o2) {
                    double delta = o1.getStart() - o2.getStart();
                    return delta < 0.0 ? -1 : (delta > 0.0 ? 1 : 0);
                }
            });
            for (int i = 1; i < sameTasks.length; ++i) {
                sameTasks[i].setSameTask(sameTasks[0]);
            }
        }
    }

    private Map<String, Set<Task>> getSameTasksMap(Task[] tasks) {
        HashMap<String, Set<Task>> sameTasksMap = new HashMap<String, Set<Task>>();
        for (Task task : tasks) {
            HashSet<Task> sameTasks = (HashSet<Task>)sameTasksMap.get(task.getTileId());
            if (sameTasks == null) {
                sameTasks = new HashSet<Task>();
                sameTasksMap.put(task.getTileId(), sameTasks);
            }
            sameTasks.add(task);
        }
        return sameTasksMap;
    }

    private Task[] getTasks(TileComputationEvent[] events, long startNanosMin, long endNanosMax) {
        Task[] tasks = new Task[events.length];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = new Task(events[i], startNanosMin, endNanosMax);
        }
        return tasks;
    }

    private static double nanosToRoundedSecs(long nanos) {
        double secs = (double)nanos * 1.0E-9;
        return (double)Math.round(1000.0 * secs) / 1000.0;
    }

    public static class Task {
        private final TileComputationEvent event;
        private final Band band;
        private final Operator operator;
        private String imageId;
        private String tileId;
        private double start;
        private double duration;
        private final int barX;
        private final int barWidth;
        private Task sameTask;

        public Task(TileComputationEvent event, long startNanosMin, long endNanosMax) {
            this.event = event;
            this.start = TileUsageReportGenerator.nanosToRoundedSecs(this.event.getStartNanos() - startNanosMin);
            this.duration = TileUsageReportGenerator.nanosToRoundedSecs(this.event.getEndNanos() - this.event.getStartNanos());
            OperatorImage image = event.getImage();
            this.imageId = String.format("%s@%s", ((Object)((Object)image)).getClass().getSimpleName(), Integer.toHexString(System.identityHashCode((Object)image)));
            this.tileId = String.format("%s.%d.%d", this.imageId, event.getTileX(), event.getTileY());
            this.band = image.getTargetBand();
            this.operator = image.getOperatorContext().getOperator();
            double scale = 1500.0 / ((double)(endNanosMax - startNanosMin) * 1.0E-9);
            this.barX = (int)Math.round(this.start * scale);
            this.barWidth = (int)Math.floor(1.0 + this.duration * scale);
        }

        public TileComputationEvent getEvent() {
            return this.event;
        }

        public Band getBand() {
            return this.band;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public String getImageId() {
            return this.imageId;
        }

        public String getTileId() {
            return this.tileId;
        }

        public double getStart() {
            return this.start;
        }

        public double getDuration() {
            return this.duration;
        }

        public int getBarX() {
            return this.barX;
        }

        public int getBarWidth() {
            return this.barWidth;
        }

        public Task getSameTask() {
            return this.sameTask;
        }

        public void setSameTask(Task sameTask) {
            this.sameTask = sameTask;
        }
    }

    private static class VmFilenameFilter
    implements FilenameFilter {
        private VmFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("TileComputationObserver.") && name.endsWith(".vm");
        }
    }

    public static class StartTimeComparator
    implements Comparator<TileComputationEvent> {
        @Override
        public int compare(TileComputationEvent o1, TileComputationEvent o2) {
            long delta = o1.getStartNanos() - o2.getStartNanos();
            return delta < 0L ? -1 : (delta > 0L ? 1 : 0);
        }
    }

    public static class ImagesComparator
    implements Comparator<TileComputationEvent> {
        @Override
        public int compare(TileComputationEvent o1, TileComputationEvent o2) {
            if (o1.getImage() == o2.getImage()) {
                return 0;
            }
            int delta = o1.getClass().getName().compareTo(o2.getClass().getName());
            if (delta == 0) {
                return System.identityHashCode((Object)o1.getImage()) - System.identityHashCode((Object)o2.getImage());
            }
            return delta;
        }
    }

    public static class TileIndicesComparator
    implements Comparator<TileComputationEvent> {
        @Override
        public int compare(TileComputationEvent o1, TileComputationEvent o2) {
            int deltaX = o1.getTileX() - o2.getTileX();
            int deltaY = o1.getTileY() - o2.getTileY();
            if (deltaX == 0 && deltaY == 0) {
                return 0;
            }
            if (deltaY == 0) {
                return deltaX;
            }
            return deltaY;
        }
    }

    public static class ThreadNamesComparator
    implements Comparator<TileComputationEvent> {
        @Override
        public int compare(TileComputationEvent o1, TileComputationEvent o2) {
            return o1.getThreadName().compareTo(o2.getThreadName());
        }
    }

    public static class GroupingComparator
    implements Comparator<TileComputationEvent> {
        private final Comparator<TileComputationEvent>[] comparators;

        public GroupingComparator(Comparator<TileComputationEvent> ... comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(TileComputationEvent o1, TileComputationEvent o2) {
            for (Comparator<TileComputationEvent> comparator : this.comparators) {
                int result = comparator.compare(o1, o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

