/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.SceneFactory;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.resample.Resample;
import org.esa.snap.core.transform.MathTransform2D;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Resample_Old", version="1.0", authors="Tonio Fincke", copyright="(c) 2016 by Brockmann Consult", description="Resampling of a multi-size source product to a single-size target product.", internal=true)
public class ResamplingOp_Old
extends Operator {
    private static final String NAME_EXTENSION = "resampled";
    @SourceProduct(description="The source product which is to be resampled.", label="Name")
    Product sourceProduct;
    @TargetProduct(description="The resampled target product.")
    Product targetProduct;
    @Parameter(alias="Reference Band", description="The name of the reference band. All other bands will be re-sampled to match its size and resolution.", rasterDataNodeType=Band.class, notEmpty=true)
    String referenceBandName;
    @Parameter(alias="interpolation", label="Interpolation Method", description="The method used for interpolation (upsampling to a finer resolution).", valueSet={"Nearest", "Bilinear", "Bicubic"}, defaultValue="Nearest")
    private String interpolationMethod;
    @Parameter(alias="aggregation", label="Aggregation Method", description="The method used for aggregation (downsampling to a coarser resolution).", valueSet={"First", "And", "Or", "Mean", "Median"}, defaultValue="First")
    private String aggregationMethod;
    @Parameter(alias="flagAggregation", label="Flag Aggregation Method", description="The method used for aggregation (downsampling to a coarser resolution) of flags.", valueSet={"First", "And", "Or", "Median-And", "Median-Or"}, defaultValue="First")
    private String flagAggregationMethod;

    @Override
    public void initialize() throws OperatorException {
        if (!this.sourceProduct.isMultiSize()) {
            this.targetProduct = this.sourceProduct;
            return;
        }
        if (!ResamplingOp_Old.allNodesHaveIdentitySceneTransform(this.sourceProduct)) {
            throw new OperatorException("Not all nodes have identity model-to-scene transform.");
        }
        if (!ResamplingOp_Old.allScalingsAreIntDivisible(this.sourceProduct)) {
            throw new OperatorException("Not all band scalings are int divisible.");
        }
        Band referenceBand = this.sourceProduct.getBand(this.referenceBandName);
        Assert.notNull((Object)referenceBand);
        if (!ResamplingOp_Old.allBandsMustBeEitherInterpolatedAggregatedOrLeftAsIs(this.sourceProduct, (RasterDataNode)referenceBand)) {
            throw new OperatorException("Bands must be either aggregated, interpolated or left as is.");
        }
        this.validateInterpolationParameter();
        int referenceWidth = referenceBand.getRasterWidth();
        int referenceHeight = referenceBand.getRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName() + "_" + NAME_EXTENSION, this.sourceProduct.getProductType(), referenceWidth, referenceHeight);
        this.resampleBands((RasterDataNode)referenceBand);
        this.resampleTiePointGrids((RasterDataNode)referenceBand);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyIndexCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
        ResamplingOp_Old.copyMasks(this.sourceProduct, this.targetProduct);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ResamplingOp_Old.transferGeoCoding(referenceBand, this.targetProduct);
        this.targetProduct.setAutoGrouping(this.sourceProduct.getAutoGrouping());
    }

    private static void transferGeoCoding(Band referenceBand, Product targetProduct) {
        Scene srcScene = SceneFactory.createScene((ProductNode)referenceBand);
        Scene destScene = SceneFactory.createScene((ProductNode)targetProduct);
        if (srcScene != null && destScene != null) {
            srcScene.transferGeoCodingTo(destScene, null);
        }
    }

    private static void copyMasks(Product sourceProduct, Product targetProduct) {
        ProductNodeGroup sourceMaskGroup = sourceProduct.getMaskGroup();
        for (int i = 0; i < sourceMaskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)sourceMaskGroup.get(i);
            Mask.ImageType imageType = mask.getImageType();
            if (imageType.getName().equals("Maths")) {
                String expression = Mask.BandMathsType.getExpression((Mask)mask);
                Mask targetMask = Mask.BandMathsType.create((String)mask.getName(), (String)mask.getDescription(), (int)targetProduct.getSceneRasterWidth(), (int)targetProduct.getSceneRasterHeight(), (String)expression, (Color)mask.getImageColor(), (double)mask.getImageTransparency());
                targetProduct.addMask(targetMask);
                continue;
            }
            if (!imageType.canTransferMask(mask, targetProduct)) continue;
            imageType.transferMask(mask, targetProduct);
        }
    }

    public static boolean canBeApplied(Product product) {
        return ResamplingOp_Old.allNodesHaveIdentitySceneTransform(product) && ResamplingOp_Old.allScalingsAreIntDivisible(product);
    }

    static boolean allNodesHaveIdentitySceneTransform(Product product) {
        ProductNodeGroup bandGroup = product.getBandGroup();
        for (int i = 0; i < bandGroup.getNodeCount(); ++i) {
            if (((Band)bandGroup.get(i)).getModelToSceneTransform() == MathTransform2D.IDENTITY) continue;
            return false;
        }
        ProductNodeGroup tiePointGridGroup = product.getTiePointGridGroup();
        for (int i = 0; i < tiePointGridGroup.getNodeCount(); ++i) {
            if (((TiePointGrid)tiePointGridGroup.get(i)).getModelToSceneTransform() == MathTransform2D.IDENTITY) continue;
            return false;
        }
        return true;
    }

    static boolean allScalingsAreIntDivisible(Product product) {
        int i;
        AffineTransform referenceModelToImageTransform;
        ProductNodeGroup bandGroup = product.getBandGroup();
        ProductNodeGroup tiePointGridGroup = product.getTiePointGridGroup();
        if (bandGroup.getNodeCount() > 0) {
            try {
                referenceModelToImageTransform = new AffineTransform(((Band)bandGroup.get(0)).getImageToModelTransform().createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new OperatorException(e.getMessage());
            }
        } else if (tiePointGridGroup.getNodeCount() > 0) {
            try {
                referenceModelToImageTransform = new AffineTransform(((TiePointGrid)tiePointGridGroup.get(0)).getImageToModelTransform().createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new OperatorException(e.getMessage());
            }
        } else {
            return true;
        }
        double modelToImageScaleX = referenceModelToImageTransform.getScaleX();
        double modelToImageScaleY = referenceModelToImageTransform.getScaleY();
        for (i = 0; i < bandGroup.getNodeCount(); ++i) {
            if (ResamplingOp_Old.isIntDivisible((RasterDataNode)bandGroup.get(i), modelToImageScaleX, modelToImageScaleY)) continue;
            return false;
        }
        for (i = 0; i < tiePointGridGroup.getNodeCount(); ++i) {
            if (ResamplingOp_Old.isIntDivisible((RasterDataNode)tiePointGridGroup.get(i), modelToImageScaleX, modelToImageScaleY)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIntDivisible(RasterDataNode node, double modelToImageScaleX, double modelToImageScaleY) {
        AffineTransform imageToModelTransform = node.getImageToModelTransform();
        double scaleX = imageToModelTransform.getScaleX() * modelToImageScaleX;
        double scaleY = imageToModelTransform.getScaleY() * modelToImageScaleY;
        return ResamplingOp_Old.isIntDivisible(scaleX) && ResamplingOp_Old.isIntDivisible(scaleY);
    }

    private static boolean isIntDivisible(double value) {
        if (value < 1.0) {
            value = 1.0 / value;
        }
        return value - Math.floor(value) < 1.0E-10;
    }

    static boolean allBandsMustBeEitherInterpolatedAggregatedOrLeftAsIs(Product product, RasterDataNode referenceNode) {
        int referenceWidth = referenceNode.getRasterWidth();
        int referenceHeight = referenceNode.getRasterHeight();
        ProductNodeGroup bandGroup = product.getBandGroup();
        for (int i = 0; i < bandGroup.getNodeCount(); ++i) {
            int rasterWidth = ((Band)bandGroup.get(i)).getRasterWidth();
            int rasterHeight = ((Band)bandGroup.get(i)).getRasterHeight();
            if (rasterWidth == referenceWidth && rasterHeight == referenceHeight || rasterWidth <= referenceWidth && rasterHeight <= referenceHeight || rasterWidth >= referenceWidth && rasterHeight >= referenceHeight) continue;
            return false;
        }
        return true;
    }

    private void resampleTiePointGrids(RasterDataNode referenceNode) {
        ProductNodeGroup tiePointGridGroup = this.sourceProduct.getTiePointGridGroup();
        AffineTransform referenceTransform = referenceNode.getImageToModelTransform();
        for (int i = 0; i < tiePointGridGroup.getNodeCount(); ++i) {
            AffineTransform transform;
            TiePointGrid grid = (TiePointGrid)tiePointGridGroup.get(i);
            try {
                transform = new AffineTransform(referenceTransform.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new OperatorException("Cannot resample: " + e.getMessage());
            }
            AffineTransform gridTransform = grid.getImageToModelTransform();
            transform.concatenate(gridTransform);
            if (Math.abs(transform.getScaleX() - 1.0) > 1.0E-8 || Math.abs(transform.getScaleY() - 1.0) > 1.0E-8 || referenceTransform.getTranslateX() != 0.0 || referenceTransform.getTranslateY() != 0.0) {
                double subSamplingX = grid.getSubSamplingX() * transform.getScaleX();
                double subSamplingY = grid.getSubSamplingY() * transform.getScaleY();
                double offsetX = grid.getOffsetX() * transform.getScaleX() - referenceTransform.getTranslateX() / gridTransform.getScaleX();
                double offsetY = grid.getOffsetY() * transform.getScaleY() - referenceTransform.getTranslateY() / gridTransform.getScaleY();
                TiePointGrid resampledGrid = new TiePointGrid(grid.getName(), grid.getGridWidth(), grid.getGridHeight(), offsetX, offsetY, subSamplingX, subSamplingY, grid.getTiePoints());
                this.targetProduct.addTiePointGrid(resampledGrid);
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)grid, (RasterDataNode)resampledGrid);
                continue;
            }
            ProductUtils.copyTiePointGrid((String)grid.getName(), (Product)this.sourceProduct, (Product)this.targetProduct);
        }
    }

    private void resampleBands(RasterDataNode referenceNode) {
        ProductNodeGroup sourceBands = this.sourceProduct.getBandGroup();
        int referenceWidth = referenceNode.getRasterWidth();
        int referenceHeight = referenceNode.getRasterHeight();
        Dimension referenceSize = referenceNode.getRasterSize();
        Object multiLevelModel = referenceNode.getGeoCoding() instanceof CrsGeoCoding ? referenceNode.getMultiLevelModel() : new DefaultMultiLevelModel(new AffineTransform(), referenceWidth, referenceHeight);
        for (int i = 0; i < sourceBands.getNodeCount(); ++i) {
            Band targetBand;
            Band sourceBand = (Band)sourceBands.get(i);
            if (!sourceBand.getRasterSize().equals(referenceSize)) {
                RenderedImage image;
                targetBand = new Band(sourceBand.getName(), sourceBand.getDataType(), referenceWidth, referenceHeight);
                if (sourceBand.getRasterWidth() < referenceWidth && sourceBand.getRasterHeight() < referenceHeight) {
                    MultiLevelImage interpolatedImage = this.createInterpolatedImage(sourceBand, referenceNode);
                    image = this.adjustImageToModelTransform(interpolatedImage, (MultiLevelModel)multiLevelModel);
                    targetBand.setSourceImage(image);
                } else {
                    MultiLevelImage aggregatedImage = this.createAggregatedImage(sourceBand, referenceNode);
                    image = this.adjustImageToModelTransform(aggregatedImage, (MultiLevelModel)multiLevelModel);
                    targetBand.setSourceImage(image);
                }
                this.targetProduct.addBand(targetBand);
            } else {
                targetBand = ProductUtils.copyBand((String)sourceBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
                RenderedImage image = this.adjustImageToModelTransform(sourceBand.getSourceImage(), (MultiLevelModel)multiLevelModel);
                targetBand.setSourceImage(image);
            }
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
        }
    }

    private RenderedImage adjustImageToModelTransform(final MultiLevelImage image, MultiLevelModel model) {
        MultiLevelModel actualModel = model;
        if (model.getLevelCount() > image.getModel().getLevelCount()) {
            actualModel = new DefaultMultiLevelModel(image.getModel().getLevelCount(), model.getImageToModelTransform(0), image.getWidth(), image.getHeight());
        }
        AbstractMultiLevelSource source = new AbstractMultiLevelSource(actualModel){

            protected RenderedImage createImage(int level) {
                return image.getImage(level);
            }
        };
        return new DefaultMultiLevelImage((MultiLevelSource)source);
    }

    private MultiLevelImage createInterpolatedImage(Band sourceBand, RasterDataNode referenceNode) {
        Interpolation interpolation = sourceBand.isFlagBand() || sourceBand.isIndexBand() ? Interpolation.getInstance((int)0) : this.getInterpolation();
        return Resample.createInterpolatedMultiLevelImage(sourceBand, referenceNode, interpolation);
    }

    private MultiLevelImage createAggregatedImage(Band sourceBand, RasterDataNode referenceNode) {
        Resample.Type aggregationType = this.getAggregationType(this.aggregationMethod);
        Resample.Type flagAggregationType = this.getAggregationType(this.flagAggregationMethod);
        return Resample.createAggregatedMultiLevelImage(sourceBand, referenceNode, aggregationType, flagAggregationType);
    }

    private Resample.Type getAggregationType(String method) {
        if ("And".equalsIgnoreCase(method)) {
            return Resample.Type.MIN;
        }
        if ("Or".equalsIgnoreCase(method)) {
            return Resample.Type.MAX;
        }
        if ("Median".equalsIgnoreCase(method)) {
            return Resample.Type.MEDIAN;
        }
        if ("Mean".equalsIgnoreCase(method)) {
            return Resample.Type.MEAN;
        }
        if ("Median-And".equalsIgnoreCase(method)) {
            return Resample.Type.MIN_MEDIAN;
        }
        if ("Median-Or".equalsIgnoreCase(method)) {
            return Resample.Type.MAX_MEDIAN;
        }
        return Resample.Type.FIRST;
    }

    private Interpolation getInterpolation() {
        int interpolation = this.getInterpolationType();
        return Interpolation.getInstance((int)interpolation);
    }

    private int getInterpolationType() {
        int interpolationType = "Nearest".equalsIgnoreCase(this.interpolationMethod) ? 0 : ("Bilinear".equalsIgnoreCase(this.interpolationMethod) ? 1 : ("Bicubic".equalsIgnoreCase(this.interpolationMethod) ? 2 : -1));
        return interpolationType;
    }

    void validateInterpolationParameter() {
        if (this.getInterpolationType() == -1) {
            throw new OperatorException("Invalid resampling method: " + this.interpolationMethod);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ResamplingOp_Old.class);
        }
    }
}

