/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.awt.Rectangle;
import javax.media.jai.RasterAccessor;
import org.esa.snap.core.gpf.common.resample.DataAccessorFactory;
import org.esa.snap.core.gpf.common.resample.DoubleDataAccessor;
import org.esa.snap.core.gpf.common.resample.Interpolator;

public abstract class DoubleDataInterpolator
implements Interpolator {
    private DoubleDataAccessor accessor;

    @Override
    public void init(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
        this.accessor = DataAccessorFactory.createDoubleDataAccessor(srcAccessor, dstAccessor, noDataValue);
    }

    protected double getSrcData(int index) {
        return this.accessor.getSrcData(index);
    }

    protected void setDstData(int index, double value) {
        this.accessor.setDstData(index, value);
    }

    protected double getNoDataValue() {
        return this.accessor.getNoDataValue();
    }

    int getSrcScalineStride() {
        return this.accessor.getSrcScalineStride();
    }

    int getDstScalineStride() {
        return this.accessor.getDstScalineStride();
    }

    int getSrcOffset() {
        return this.accessor.getSrcOffset();
    }

    int getDstOffset() {
        return this.accessor.getDstOffset();
    }

    static class CubicConvolution
    extends DoubleDataInterpolator {
        CubicConvolution() {
        }

        @Override
        public void interpolate(Rectangle destRect, Rectangle srcRect, double scaleX, double scaleY, double offsetX, double offsetY) {
            int srcH = (int)srcRect.getHeight();
            int srcW = (int)srcRect.getWidth();
            int dstIndexY = this.getDstOffset();
            double subPixelOffsetY = offsetY - (double)((int)offsetY);
            double subPixelOffsetX = offsetX - (double)((int)offsetX);
            int dstY = 0;
            while ((double)dstY < destRect.getHeight()) {
                double srcYF = subPixelOffsetY + scaleY * ((double)dstY + 0.5) - 0.5;
                int srcY = (int)srcYF;
                int srcIndexY = this.getSrcOffset() + srcY * this.getSrcScalineStride();
                double wy = srcYF - (double)srcY;
                int dstX = 0;
                while ((double)dstX < destRect.getWidth()) {
                    double srcXF = subPixelOffsetX + scaleX * ((double)dstX + 0.5) - 0.5;
                    int srcX = (int)srcXF;
                    double wx = srcXF - (double)srcX;
                    double[][] validRectangle = this.getValidRectangle(srcX, srcY, srcIndexY, srcW, srcH);
                    double[] rowMeans = new double[4];
                    for (int i = 0; i < 4; ++i) {
                        rowMeans[i] = validRectangle[i][0] * (4.0 - 8.0 * (1.0 + wx) + 5.0 * Math.pow(1.0 + wx, 2.0) - Math.pow(1.0 + wx, 3.0)) + validRectangle[i][1] * (1.0 - 2.0 * Math.pow(wx, 2.0) + Math.pow(wx, 3.0)) + validRectangle[i][2] * (1.0 - 2.0 * Math.pow(1.0 - wx, 2.0) + Math.pow(1.0 - wx, 3.0)) + validRectangle[i][3] * (4.0 - 8.0 * (2.0 - wx) + 5.0 * Math.pow(2.0 - wx, 2.0) - Math.pow(2.0 - wx, 3.0));
                    }
                    double v = rowMeans[0] * (4.0 - 8.0 * (1.0 + wy) + 5.0 * Math.pow(1.0 + wy, 2.0) - Math.pow(1.0 + wy, 3.0)) + rowMeans[1] * (1.0 - 2.0 * Math.pow(wy, 2.0) + Math.pow(wy, 3.0)) + rowMeans[2] * (1.0 - 2.0 * Math.pow(1.0 - wy, 2.0) + Math.pow(1.0 - wy, 3.0)) + rowMeans[3] * (4.0 - 8.0 * (2.0 - wy) + 5.0 * Math.pow(2.0 - wy, 2.0) - Math.pow(2.0 - wy, 3.0));
                    if (Double.isNaN(v) || Math.abs(v - this.getNoDataValue()) < 1.0E-8) {
                        this.setDstData(dstIndexY + dstX, this.getNoDataValue());
                    } else {
                        this.setDstData(dstIndexY + dstX, v);
                    }
                    ++dstX;
                }
                dstIndexY += this.getDstScalineStride();
                ++dstY;
            }
        }

        double[][] getValidRectangle(int srcX, int srcY, int srcIndexY, int srcW, int srcH) {
            double[][] validRectangle = new double[4][4];
            validRectangle[1][1] = this.getSrcData(srcIndexY + srcX);
            boolean notAtLeftBorder = srcX - 1 >= 0;
            boolean notAtUpperBorder = srcY - 1 >= 0;
            boolean notAtRightBorder = srcX + 1 < srcW;
            boolean notAtRightBorder2 = srcX + 2 < srcW;
            boolean notAtLowerBorder = srcY + 1 < srcH;
            boolean notAtLowerBorder2 = srcY + 2 < srcH;
            validRectangle[0][1] = notAtLeftBorder ? this.getSrcData(srcIndexY, srcX, 0, 1) : validRectangle[1][1];
            validRectangle[1][0] = notAtUpperBorder ? this.getSrcData(srcIndexY, srcX, 1, 0) : validRectangle[1][1];
            validRectangle[2][1] = notAtRightBorder ? this.getSrcData(srcIndexY, srcX, 2, 1) : validRectangle[1][1];
            validRectangle[1][2] = notAtLowerBorder ? this.getSrcData(srcIndexY, srcX, 1, 2) : validRectangle[1][1];
            validRectangle[3][1] = notAtRightBorder2 ? this.getSrcData(srcIndexY, srcX, 3, 1) : validRectangle[2][1];
            double d = validRectangle[1][3] = notAtLowerBorder2 ? this.getSrcData(srcIndexY, srcX, 1, 3) : validRectangle[1][2];
            validRectangle[0][0] = notAtLeftBorder ? (notAtUpperBorder ? this.getSrcData(srcIndexY, srcX, 0, 0) : validRectangle[0][1]) : (notAtUpperBorder ? validRectangle[1][0] : validRectangle[1][1]);
            validRectangle[2][0] = notAtRightBorder ? (notAtUpperBorder ? this.getSrcData(srcIndexY, srcX, 2, 0) : validRectangle[2][1]) : (notAtUpperBorder ? validRectangle[1][0] : validRectangle[1][1]);
            validRectangle[2][2] = notAtRightBorder ? (notAtLowerBorder ? this.getSrcData(srcIndexY, srcX, 2, 2) : validRectangle[2][1]) : (notAtLowerBorder ? validRectangle[1][2] : validRectangle[1][1]);
            validRectangle[0][2] = notAtLeftBorder ? (notAtLowerBorder ? this.getSrcData(srcIndexY, srcX, 0, 2) : validRectangle[0][1]) : (notAtLowerBorder ? validRectangle[1][2] : validRectangle[1][1]);
            validRectangle[3][0] = notAtRightBorder2 ? (notAtUpperBorder ? this.getSrcData(srcIndexY, srcX, 3, 0) : validRectangle[3][1]) : validRectangle[2][0];
            validRectangle[3][2] = notAtRightBorder2 ? (notAtLowerBorder ? this.getSrcData(srcIndexY, srcX, 3, 2) : validRectangle[3][1]) : validRectangle[2][2];
            validRectangle[2][3] = notAtRightBorder ? (notAtLowerBorder2 ? this.getSrcData(srcIndexY, srcX, 2, 3) : validRectangle[2][2]) : validRectangle[1][3];
            validRectangle[0][3] = notAtLeftBorder ? (notAtLowerBorder2 ? this.getSrcData(srcIndexY, srcX, 0, 3) : validRectangle[0][2]) : validRectangle[1][3];
            validRectangle[3][3] = notAtRightBorder2 ? (notAtLowerBorder2 ? this.getSrcData(srcIndexY, srcX, 3, 3) : validRectangle[3][2]) : (notAtLowerBorder2 ? validRectangle[2][3] : validRectangle[2][2]);
            return validRectangle;
        }

        private double getSrcData(int srcIndexY, int srcX, int x, int y) {
            int yOffset = (y - 1) * this.getSrcScalineStride();
            int xOffset = srcX + (x - 1);
            return this.getSrcData(srcIndexY + yOffset + xOffset);
        }
    }

    static class Bilinear
    extends DoubleDataInterpolator {
        Bilinear() {
        }

        @Override
        public void interpolate(Rectangle destRect, Rectangle srcRect, double scaleX, double scaleY, double offsetX, double offsetY) {
            int srcH = (int)srcRect.getHeight();
            int srcW = (int)srcRect.getWidth();
            int dstIndexY = this.getDstOffset();
            double subPixelOffsetY = offsetY - (double)((int)offsetY);
            double subPixelOffsetX = offsetX - (double)((int)offsetX);
            int dstY = 0;
            while ((double)dstY < destRect.getHeight()) {
                double srcYF = subPixelOffsetY + scaleY * ((double)dstY + 0.5) - 0.5;
                int srcY = (int)srcYF;
                int srcIndexY = this.getSrcOffset() + srcY * this.getSrcScalineStride();
                double wy = srcYF - (double)srcY;
                int dstX = 0;
                while ((double)dstX < destRect.getWidth()) {
                    double srcXF = subPixelOffsetX + scaleX * ((double)dstX + 0.5) - 0.5;
                    int srcX = (int)srcXF;
                    double wx = srcXF - (double)srcX;
                    boolean withinSrcH = srcY + 1 < srcH;
                    boolean withinSrcW = srcX + 1 < srcW;
                    double v00 = this.getSrcData(srcIndexY + srcX);
                    int dstIndex = dstIndexY + dstX;
                    if (!withinSrcW && !withinSrcH) {
                        this.setDstData(dstIndex, v00);
                    } else {
                        double v01 = withinSrcW ? this.getSrcData(srcIndexY + srcX + 1) : this.getNoDataValue();
                        double v10 = withinSrcH ? this.getSrcData(srcIndexY + this.getSrcScalineStride() + srcX) : this.getNoDataValue();
                        double v11 = withinSrcW && withinSrcH ? this.getSrcData(srcIndexY + this.getSrcScalineStride() + srcX + 1) : this.getNoDataValue();
                        boolean v00Valid = this.isValid(v00);
                        boolean v01Valid = this.isValid(v01);
                        boolean v10Valid = this.isValid(v10);
                        boolean v11Valid = this.isValid(v11);
                        int validityCounter = 0;
                        validityCounter = v00Valid ? validityCounter + 1 : validityCounter;
                        validityCounter = v01Valid ? validityCounter + 1 : validityCounter;
                        validityCounter = v10Valid ? validityCounter + 1 : validityCounter;
                        int n = validityCounter = v11Valid ? validityCounter + 1 : validityCounter;
                        if (validityCounter == 0) {
                            this.setDstData(dstIndex, this.getNoDataValue());
                        } else if (validityCounter == 4) {
                            double v0 = v00 + wx * (v01 - v00);
                            double v1 = v10 + wx * (v11 - v10);
                            double v = v0 + wy * (v1 - v0);
                            this.setDstData(dstIndex, v);
                        } else if (validityCounter == 1) {
                            if (v00Valid) {
                                this.setDstData(dstIndex, v00);
                            } else if (v01Valid) {
                                this.setDstData(dstIndex, v01);
                            } else if (v10Valid) {
                                this.setDstData(dstIndex, v10);
                            } else {
                                this.setDstData(dstIndex, v11);
                            }
                        } else if (validityCounter == 2) {
                            double v;
                            double ws;
                            if (v00Valid && v01Valid) {
                                this.setDstData(dstIndex, v00 * (1.0 - wx) + v01 * wx);
                            } else if (v10Valid && v11Valid) {
                                this.setDstData(dstIndex, v10 * (1.0 - wx) + v11 * wx);
                            } else if (v00Valid && v10Valid) {
                                this.setDstData(dstIndex, v00 * (1.0 - wy) + v10 * wy);
                            } else if (v01Valid && v11Valid) {
                                this.setDstData(dstIndex, v01 * (1.0 - wy) + v11 * wy);
                            } else if (v00Valid && v11Valid) {
                                ws = 1.0 / (wx * wy + (1.0 - wx) * (1.0 - wy));
                                v = v00 * (1.0 - wx) * (1.0 - wy) + v11 * wx * wy;
                                this.setDstData(dstIndex, v *= ws);
                            } else {
                                ws = 1.0 / ((1.0 - wx) * wy + wx * (1.0 - wy));
                                v = v01 * wx * (1.0 - wy) + v10 * (1.0 - wx) * wy;
                                this.setDstData(dstIndex, v *= ws);
                            }
                        } else {
                            double v;
                            double w00 = (1.0 - wx) * (1.0 - wy);
                            double w01 = wx * (1.0 - wy);
                            double w10 = (1.0 - wx) * wy;
                            double w11 = wx * wy;
                            if (!v00Valid) {
                                v = v01 * (w01 += 0.5 * w00) + v10 * (w10 += 0.5 * w00) + v11 * w11;
                                this.setDstData(dstIndex, v);
                            } else if (!v01Valid) {
                                v = v00 * (w00 += 0.5 * w01) + v10 * w10 + v11 * (w11 += 0.5 * w01);
                                this.setDstData(dstIndex, v);
                            } else if (!v10Valid) {
                                v = v00 * (w00 += 0.5 * w10) + v01 * w01 + v11 * (w11 += 0.5 * w10);
                                this.setDstData(dstIndex, v);
                            } else {
                                v = v00 * w00 + v01 * (w01 += 0.5 * w11) + v10 * (w10 += 0.5 * w11);
                                this.setDstData(dstIndex, v);
                            }
                        }
                    }
                    ++dstX;
                }
                dstIndexY += this.getDstScalineStride();
                ++dstY;
            }
        }

        private boolean isValid(double v) {
            return !Double.isNaN(v) && Math.abs(v - this.getNoDataValue()) > 1.0E-8;
        }
    }

    static class NearestNeighbour
    extends DoubleDataInterpolator {
        NearestNeighbour() {
        }

        @Override
        public void interpolate(Rectangle destRect, Rectangle srcRect, double scaleX, double scaleY, double offsetX, double offsetY) {
            int dstIndexY = this.getDstOffset();
            double subPixelOffsetY = offsetY - (double)((int)offsetY);
            double subPixelOffsetX = offsetX - (double)((int)offsetX);
            int dstY = 0;
            while ((double)dstY < destRect.getHeight()) {
                int srcY = (int)(subPixelOffsetY + scaleY * (double)dstY);
                int srcIndexY = this.getSrcOffset() + srcY * this.getSrcScalineStride();
                boolean yValid = (double)srcY < srcRect.getHeight();
                int dstX = 0;
                while ((double)dstX < destRect.getWidth()) {
                    int srcX = (int)(subPixelOffsetX + scaleX * (double)dstX);
                    if (yValid && (double)srcX < srcRect.getWidth()) {
                        this.setDstData(dstIndexY + dstX, this.getSrcData(srcIndexY + srcX));
                    } else {
                        this.setDstData(dstIndexY + dstX, this.getNoDataValue());
                    }
                    ++dstX;
                }
                dstIndexY += this.getDstScalineStride();
                ++dstY;
            }
        }
    }
}

