/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.reproject;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.SourcelessOpImage;
import javax.media.jai.Warp;
import org.esa.snap.core.gpf.internal.OperatorContext;

class WarpSourceCoordinatesOpImage
extends SourcelessOpImage {
    private final Warp warp;
    private final RasterFormatTag rasterFormatTag;

    private static ImageLayout createTwoBandedImageLayout(int width, int height, Dimension tileSize) {
        if (width < 0) {
            throw new IllegalArgumentException("width");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height");
        }
        if (tileSize == null) {
            throw new IllegalArgumentException("tileSize");
        }
        SampleModel sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)4, (int)tileSize.width, (int)tileSize.height, (int)2);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        if (colorModel == null) {
            int dataType = sampleModel.getDataType();
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{DataBuffer.getDataTypeSize(dataType)};
            colorModel = new ComponentColorModel(cs, nBits, false, true, 1, dataType);
        }
        return new ImageLayout(0, 0, width, height, 0, 0, tileSize.width, tileSize.height, sampleModel, colorModel);
    }

    WarpSourceCoordinatesOpImage(Warp warp, int width, int height, Dimension tileSize, Map configuration) {
        this(warp, WarpSourceCoordinatesOpImage.createTwoBandedImageLayout(width, height, tileSize), configuration);
    }

    private WarpSourceCoordinatesOpImage(Warp warp, ImageLayout layout, Map configuration) {
        super(layout, configuration, layout.getSampleModel(null), layout.getMinX(null), layout.getMinY(null), layout.getWidth(null), layout.getHeight(null));
        this.warp = warp;
        int compatibleTag = RasterAccessor.findCompatibleTag(null, (SampleModel)layout.getSampleModel(null));
        this.rasterFormatTag = new RasterFormatTag(layout.getSampleModel(null), compatibleTag);
        OperatorContext.setTileCache((OpImage)this);
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, this.rasterFormatTag, this.getColorModel());
        this.computeRectFloat(dst);
        if (dst.isDataCopy()) {
            dst.clampDataArrays();
            dst.copyDataToRaster();
        }
    }

    private void computeRectFloat(RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        float[][] data = dst.getFloatDataArrays();
        float[] warpData = new float[2 * dstWidth * dstHeight];
        int lineOffset = 0;
        this.warp.warpRect(dst.getX(), dst.getY(), dstWidth, dstHeight, warpData);
        int count = 0;
        for (int h = 0; h < dstHeight; ++h) {
            int pixelOffset = lineOffset;
            lineOffset += lineStride;
            for (int w = 0; w < dstWidth; ++w) {
                float x = warpData[count++];
                float y = warpData[count++];
                if (Float.isNaN(x) || Float.isNaN(y)) {
                    x = (float)(this.getBounds().getMinX() - 1.0);
                    y = (float)(this.getBounds().getMinY() - 1.0);
                }
                data[0][pixelOffset + bandOffsets[0]] = x;
                data[1][pixelOffset + bandOffsets[1]] = y;
                pixelOffset += pixelStride;
            }
        }
    }
}

