/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.standard.reproject;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.operator.MosaicDescriptor;
import org.esa.beam.framework.datamodel.ImageGeometry;
import org.esa.beam.gpf.operators.standard.reproject.WarpFromSourceCoordinates;
import org.esa.beam.gpf.operators.standard.reproject.WarpSourceCoordinatesOpImage;
import org.geotools.factory.Hints;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.referencing.operation.transform.WarpTransform2D;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

final class Reproject {
    private static final int DIMENSION_X_INDEX = 0;
    private static final int DIMENSION_Y_INDEX = 1;
    private static final double EPS = 1.0E-6;
    private OpImage[] leveledWarpImages;

    Reproject(int numLevels) {
        this.leveledWarpImages = new OpImage[numLevels];
    }

    private synchronized Warp getCachingWarp(Warp warp, int width, int height, Dimension tileSize, int level) {
        if (this.leveledWarpImages[level] == null) {
            this.leveledWarpImages[level] = new WarpSourceCoordinatesOpImage(warp, width, height, tileSize, null);
        }
        return new WarpFromSourceCoordinates(this.leveledWarpImages[level]);
    }

    public RenderedImage reproject(RenderedImage sourceImage, ImageGeometry sourceGeometry, ImageGeometry targetGeometry, double backgroundValue, Interpolation interpolation, Hints hints, int targetLevel, Dimension tileSize) throws FactoryException, TransformException {
        String operation;
        double[] background;
        MathTransform allSteps;
        CoordinateReferenceSystem targetMapCrs;
        CoordinateOperationFactory factory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
        MathTransformFactory mtFactory = factory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)factory).getMathTransformFactory() : ReferencingFactoryFinder.getMathTransformFactory((Hints)hints);
        AffineTransform2D step1 = new AffineTransform2D(targetGeometry.getImage2MapTransform());
        MathTransform2D step3 = new AffineTransform2D(sourceGeometry.getImage2MapTransform()).inverse();
        CoordinateReferenceSystem sourceMapCrs = sourceGeometry.getMapCrs();
        if (CRS.equalsIgnoreMetadata((Object)sourceMapCrs, (Object)(targetMapCrs = targetGeometry.getMapCrs()))) {
            allSteps = mtFactory.createConcatenatedTransform((MathTransform)step1, (MathTransform)step3);
        } else {
            CoordinateOperation step2Operation = factory.createOperation(targetMapCrs, sourceMapCrs);
            MathTransform step2 = step2Operation.getMathTransform();
            if (step1.equals(step3.inverse())) {
                allSteps = step2;
            } else {
                MathTransform step1To2 = mtFactory.createConcatenatedTransform((MathTransform)step1, step2);
                allSteps = mtFactory.createConcatenatedTransform(step1To2, (MathTransform)step3);
            }
        }
        MathTransform2D allSteps2D = Reproject.toMathTransform2D(allSteps, mtFactory);
        RenderingHints targetHints = Reproject.getRenderingHints(sourceImage, interpolation);
        if (hints != null) {
            targetHints.add((RenderingHints)hints);
        }
        Object borderExtender = XArray.allEquals((double[])(background = new double[]{backgroundValue}), (double)0.0) ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(background);
        targetHints.put(JAI.KEY_BORDER_EXTENDER, borderExtender);
        ParameterBlock paramBlk = new ParameterBlock().addSource(sourceImage);
        if (allSteps.isIdentity() || allSteps instanceof AffineTransform && XAffineTransform.isIdentity((AffineTransform)((AffineTransform)allSteps), (double)1.0E-6)) {
            Rectangle sourceBB = sourceGeometry.getImageRect();
            Rectangle targetBB = targetGeometry.getImageRect();
            paramBlk.removeSources();
            paramBlk.addSource(sourceImage);
            if (targetBB.equals(sourceBB)) {
                return sourceImage;
            }
            if (sourceBB.contains(targetBB)) {
                operation = "Crop";
                paramBlk.add(Float.valueOf(targetBB.x)).add(Float.valueOf(targetBB.y)).add(Float.valueOf(targetBB.width)).add(Float.valueOf(targetBB.height));
            } else {
                operation = "Mosaic";
                paramBlk.add(MosaicDescriptor.MOSAIC_TYPE_OVERLAY).add(null).add(null).add(null).add(background);
            }
        } else {
            operation = "Warp";
            Object warp = allSteps2D instanceof AffineTransform ? new WarpAffine((AffineTransform)allSteps2D) : WarpTransform2D.getWarp(null, (MathTransform2D)allSteps2D);
            Rectangle imageRect = targetGeometry.getImageRect();
            warp = this.getCachingWarp((Warp)warp, imageRect.width, imageRect.height, tileSize, targetLevel);
            paramBlk.add(warp).add(interpolation).add(background);
        }
        return JAI.getDefaultInstance().createNS(operation, paramBlk, targetHints);
    }

    private static MathTransform2D toMathTransform2D(MathTransform transform, MathTransformFactory mtFactory) throws FactoryException {
        DimensionFilter filter = new DimensionFilter(mtFactory);
        filter.addSourceDimension(0);
        filter.addSourceDimension(1);
        MathTransform candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        filter.addTargetDimension(0);
        filter.addTargetDimension(1);
        candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        throw new FactoryException(Errors.format((int)139));
    }

    private static RenderingHints getRenderingHints(RenderedImage image, Interpolation interpolation) {
        RenderingHints hints = ImageUtilities.getRenderingHints((RenderedImage)image);
        if (hints == null) {
            hints = new RenderingHints(null);
        }
        hints.put(JAI.KEY_INTERPOLATION, interpolation);
        return hints;
    }
}

