/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.standard;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.jexp.EvalEnv;
import com.bc.jexp.Namespace;
import com.bc.jexp.ParseException;
import com.bc.jexp.Parser;
import com.bc.jexp.Symbol;
import com.bc.jexp.Term;
import com.bc.jexp.WritableNamespace;
import com.bc.jexp.impl.ParserImpl;
import com.bc.jexp.impl.SymbolFactory;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.framework.dataop.barithm.RasterDataEvalEnv;
import org.esa.beam.framework.dataop.barithm.RasterDataSymbol;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.StringUtils;

@OperatorMetadata(alias="BandMaths", category="Utilities", version="1.1", copyright="(c) 2013 by Brockmann Consult", authors="Marco Zuehlke, Norman Fomferra, Marco Peters", description="Create a product with one or more bands using mathematical expressions.")
public class BandMathsOp
extends Operator {
    @TargetProduct
    private Product targetProduct;
    @SourceProducts(description="Any number of source products.")
    private Product[] sourceProducts;
    @Parameter(alias="targetBands", itemAlias="targetBand", description="List of descriptors defining the target bands.")
    private BandDescriptor[] targetBandDescriptors;
    @Parameter(alias="variables", itemAlias="variable", description="List of variables which can be used within the expressions.")
    private Variable[] variables;
    private Map<Band, BandDescriptor> descriptorMap;

    public BandDescriptor[] getTargetBandDescriptors() {
        return this.targetBandDescriptors;
    }

    public void setTargetBandDescriptors(BandDescriptor ... targetBandDescriptors) {
        this.targetBandDescriptors = targetBandDescriptors;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public void setVariables(Variable ... variables) {
        this.variables = variables;
    }

    @Override
    public void initialize() throws OperatorException {
        if (this.targetBandDescriptors == null || this.targetBandDescriptors.length == 0) {
            throw new OperatorException("No target bands specified.");
        }
        if (this.sourceProducts == null || this.sourceProducts.length == 0) {
            throw new OperatorException("No source products given.");
        }
        int width = this.sourceProducts[0].getSceneRasterWidth();
        int height = this.sourceProducts[0].getSceneRasterHeight();
        for (Product product : this.sourceProducts) {
            if (product.getSceneRasterWidth() == width && product.getSceneRasterHeight() == height) continue;
            throw new OperatorException("Products must have the same raster dimension.");
        }
        this.targetProduct = new Product(this.sourceProducts[0].getName() + "BandMath", "BandMath", width, height);
        this.descriptorMap = new HashMap<Band, BandDescriptor>(this.targetBandDescriptors.length);
        Namespace namespace = this.createNamespace();
        ParserImpl verificationParser = new ParserImpl(namespace, true);
        for (BandDescriptor bandDescriptor : this.targetBandDescriptors) {
            this.createBand(bandDescriptor, (Parser)verificationParser);
        }
        ProductUtils.copyMetadata((Product)this.sourceProducts[0], (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProducts[0], (Product)this.targetProduct);
        for (BandDescriptor bandDescriptor : this.sourceProducts) {
            if (bandDescriptor.getStartTime() == null || bandDescriptor.getEndTime() == null) continue;
            this.targetProduct.setStartTime(bandDescriptor.getStartTime());
            this.targetProduct.setEndTime(bandDescriptor.getEndTime());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        RasterDataSymbol[] refRasterDataSymbols;
        Rectangle rect = targetTile.getRectangle();
        Term term = this.createTerm(this.descriptorMap.get((Object)band).expression);
        for (RasterDataSymbol symbol : refRasterDataSymbols = BandArithmetic.getRefRasterDataSymbols((Term)term)) {
            ProductData dataBuffer;
            Tile tile = this.getSourceTile(symbol.getRaster(), rect);
            if (tile.getRasterDataNode().isScalingApplied()) {
                dataBuffer = ProductData.createInstance((int)30, (int)(tile.getWidth() * tile.getHeight()));
                int dataBufferIndex = 0;
                for (int y = rect.y; y < rect.y + rect.height; ++y) {
                    for (int x = rect.x; x < rect.x + rect.width; ++x) {
                        dataBuffer.setElemFloatAt(dataBufferIndex, tile.getSampleFloat(x, y));
                        ++dataBufferIndex;
                    }
                }
                symbol.setData((Object)dataBuffer);
                continue;
            }
            dataBuffer = tile.getRawSamples();
            symbol.setData((Object)dataBuffer);
        }
        RasterDataEvalEnv env = new RasterDataEvalEnv(rect.x, rect.y, rect.width, rect.height);
        pm.beginTask("Evaluating expression", rect.height);
        try {
            float fv = Float.NaN;
            if (band.isNoDataValueUsed()) {
                fv = (float)band.getNoDataValue();
            }
            int pixelIndex = 0;
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                if (pm.isCanceled()) {
                    break;
                }
                for (int x = rect.x; x < rect.x + rect.width; ++x) {
                    env.setElemIndex(pixelIndex);
                    double v = term.evalD((EvalEnv)env);
                    if (Double.isNaN(v) || Double.isInfinite(v)) {
                        targetTile.setSample(x, y, fv);
                    } else {
                        targetTile.setSample(x, y, v);
                    }
                    ++pixelIndex;
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private void createBand(BandDescriptor bandDescriptor, Parser verificationParser) {
        if (StringUtils.isNullOrEmpty((String)bandDescriptor.name)) {
            throw new OperatorException("Missing band name.");
        }
        if (StringUtils.isNullOrEmpty((String)bandDescriptor.type)) {
            throw new OperatorException(String.format("Missing data type for band %s.", bandDescriptor.name));
        }
        Band band = this.targetProduct.addBand(bandDescriptor.name, ProductData.getType((String)bandDescriptor.type.toLowerCase()));
        if (StringUtils.isNotNullAndNotEmpty((String)bandDescriptor.description)) {
            band.setDescription(bandDescriptor.description);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)bandDescriptor.validExpression)) {
            band.setValidPixelExpression(bandDescriptor.validExpression);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)bandDescriptor.unit)) {
            band.setUnit(bandDescriptor.unit);
        }
        if (bandDescriptor.noDataValue != null) {
            band.setNoDataValue(bandDescriptor.noDataValue.doubleValue());
            band.setNoDataValueUsed(true);
        }
        if (bandDescriptor.spectralBandIndex != null) {
            band.setSpectralBandIndex(bandDescriptor.spectralBandIndex.intValue());
        }
        if (bandDescriptor.spectralWavelength != null) {
            band.setSpectralWavelength(bandDescriptor.spectralWavelength.floatValue());
        }
        if (bandDescriptor.spectralBandwidth != null) {
            band.setSpectralBandwidth(bandDescriptor.spectralBandwidth.floatValue());
        }
        if (bandDescriptor.scalingOffset != null) {
            band.setScalingOffset(bandDescriptor.scalingOffset.doubleValue());
        }
        if (bandDescriptor.scalingFactor != null) {
            band.setScalingFactor(bandDescriptor.scalingFactor.doubleValue());
        }
        this.descriptorMap.put(band, bandDescriptor);
        try {
            verificationParser.parse(bandDescriptor.expression);
        }
        catch (ParseException e) {
            throw new OperatorException("Could not parse expression: " + bandDescriptor.expression, e);
        }
    }

    private Namespace createNamespace() {
        WritableNamespace namespace = BandArithmetic.createDefaultNamespace((Product[])this.sourceProducts, (int)0, (BandArithmetic.ProductPrefixProvider)new SourceProductPrefixProvider());
        if (this.variables != null) {
            for (Variable variable : this.variables) {
                Symbol symbol;
                if (ProductData.isFloatingPointType((int)ProductData.getType((String)variable.type))) {
                    symbol = SymbolFactory.createConstant((String)variable.name, (double)Double.parseDouble(variable.value));
                    namespace.registerSymbol(symbol);
                    continue;
                }
                if (ProductData.isIntType((int)ProductData.getType((String)variable.type))) {
                    symbol = SymbolFactory.createConstant((String)variable.name, (double)Long.parseLong(variable.value));
                    namespace.registerSymbol(symbol);
                    continue;
                }
                if (!"boolean".equals(variable.type)) continue;
                symbol = SymbolFactory.createConstant((String)variable.name, (boolean)Boolean.parseBoolean(variable.value));
                namespace.registerSymbol(symbol);
            }
        }
        return namespace;
    }

    private Term createTerm(String expression) {
        Term term;
        Namespace namespace = this.createNamespace();
        try {
            ParserImpl parser = new ParserImpl(namespace, false);
            term = parser.parse(expression);
        }
        catch (ParseException e) {
            throw new OperatorException("Could not parse expression: " + expression, e);
        }
        return term;
    }

    @Deprecated
    public static BandMathsOp createBooleanExpressionBand(String expression, Product sourceProduct) {
        BandDescriptor bandDescriptor = new BandDescriptor();
        bandDescriptor.name = "band1";
        bandDescriptor.expression = expression;
        bandDescriptor.type = "int8";
        BandMathsOp bandMathsOp = new BandMathsOp();
        bandMathsOp.setParameterDefaultValues();
        bandMathsOp.setSourceProduct(sourceProduct);
        bandMathsOp.setTargetBandDescriptors(bandDescriptor);
        return bandMathsOp;
    }

    private class SourceProductPrefixProvider
    implements BandArithmetic.ProductPrefixProvider {
        private SourceProductPrefixProvider() {
        }

        public String getPrefix(Product product) {
            return "$" + BandMathsOp.this.getSourceProductId(product) + ".";
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(BandMathsOp.class);
        }
    }

    public static class Variable {
        public String name;
        public String type;
        public String value;
    }

    public static class BandDescriptor {
        public String name;
        public String type;
        public String expression;
        public String description;
        public String unit;
        public String validExpression;
        public Double noDataValue;
        public Integer spectralBandIndex;
        public Float spectralWavelength;
        public Float spectralBandwidth;
        public Double scalingOffset;
        public Double scalingFactor;
    }
}

