/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.gpf.operators.meris.MerisBasisOp;
import org.esa.beam.util.ProductUtils;

@OperatorMetadata(alias="Meris.N1Patcher", category="Utilities", description="Copies an existing N1 file and replaces the data for the radiance bands", version="1.1", authors="Marco Zuehlke, Olaf Danne, Marco Peters", autoWriteDisabled=true)
public class N1PatcherOp
extends MerisBasisOp {
    private static final int MPH_PRODUCTNAME_OFFSET = 9;
    private static final int MPH_PRODUCTNAME_LENGTH = 62;
    private static final int MPH_TOT_SIZE_OFFSET = 1076;
    private static final int MPH_TOT_SIZE_LENGTH = 20;
    private static final int MPH_SPH_SIZE_OFFSET = 1114;
    private static final int MPH_SPH_SIZE_LENGTH = 10;
    private static final int MPH_NUM_DSD_OFFSET = 1141;
    private static final int MPH_NUM_DSD_LENGTH = 10;
    private static final int MPH_DSD_SIZE_OFFSET = 1162;
    private static final int MPH_DSD_SIZE_LENGTH = 10;
    private static final int MPH_SIZE = 1247;
    private static final int DSD_DS_NAME_OFFSET = 9;
    private static final int DSD_DS_NAME_LENGTH = 28;
    private static final int DSD_DS_TYPE_OFFSET = 47;
    private static final int DSD_DS_OFFSET_LENGTH = 21;
    private static final int DSD_DS_OFFSET_OFFSET = 133;
    private static final int DSD_DS_SIZE_LENGTH = 21;
    private static final int DSD_DS_SIZE_OFFSET = 170;
    private static final int DSD_NUM_DSR_LENGTH = 11;
    private static final int DSD_NUM_DSR_OFFSET = 207;
    private static final int DSD_DSR_SIZE_LENGTH = 11;
    private static final int DSD_DSR_SIZE_OFFSET = 228;
    private static final int DSR_HEADER_SIZE = 13;
    private int dsd_size;
    private int num_dsd;
    private int sph_size;
    private DatasetDescriptor[] dsDescriptors;
    private ImageInputStream inputStream;
    private ImageOutputStream outputStream;
    private final Object syncObject = new Object();
    @SourceProduct(alias="n1", description="The N1 file which is used as a template.")
    private Product n1Product;
    @SourceProduct(alias="input", description="The source product provides the data to be written into the patched file.")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The file to which the patched L1b product is written.", notNull=true, notEmpty=true)
    private File patchedFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.n1Product, "n1Product", "MER_L1");
        for (String bandName : this.n1Product.getBandNames()) {
            if ("l1_flags".equals(bandName) || this.targetProduct.containsBand(bandName)) continue;
            ProductUtils.copyBand((String)bandName, (Product)this.n1Product, (Product)this.targetProduct, (boolean)false);
        }
        File patchedFileDir = this.patchedFile.getAbsoluteFile().getParentFile();
        if (patchedFileDir != null && !patchedFileDir.exists() && !patchedFileDir.mkdirs()) {
            throw new OperatorException("Could not create path to file: " + this.patchedFile);
        }
        ProductUtils.copyFlagBands((Product)this.n1Product, (Product)this.targetProduct, (boolean)false);
        try {
            File originalFileLocation = this.n1Product.getFileLocation();
            if (originalFileLocation == null) {
                throw new OperatorException("The 'n1Product' is not stored on disk.");
            }
            if (!originalFileLocation.getName().endsWith(".N1")) {
                throw new OperatorException("The file of 'n1Product' must have '.N1' as extension.");
            }
            Object object = this.syncObject;
            synchronized (object) {
                this.inputStream = new FileImageInputStream(originalFileLocation);
                this.outputStream = new FileImageOutputStream(this.patchedFile);
                byte[] mph = this.parseMPH();
                byte[] sph = this.parseSPH();
                this.copyHeader(mph, sph);
            }
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    private byte[] parseMPH() throws IOException {
        byte[] mph = new byte[1247];
        this.inputStream.seek(0L);
        this.inputStream.read(mph);
        this.num_dsd = Integer.parseInt(new String(mph, 1141, 10));
        this.sph_size = Integer.parseInt(new String(mph, 1114, 10));
        this.dsd_size = Integer.parseInt(new String(mph, 1162, 10));
        return mph;
    }

    private byte[] parseSPH() throws IOException {
        byte[] sph = new byte[this.sph_size];
        this.inputStream.seek(1247L);
        this.inputStream.read(sph);
        this.dsDescriptors = new DatasetDescriptor[this.num_dsd];
        int dsdPtr = this.sph_size - this.num_dsd * this.dsd_size;
        for (int i = 0; i < this.num_dsd; ++i) {
            DatasetDescriptor dsd = new DatasetDescriptor();
            dsd.isSpare = sph[dsdPtr] != 68;
            if (!dsd.isSpare) {
                dsd.dsdPtr = 1247 + dsdPtr;
                dsd.dsType = this.readCharBuf(sph, dsdPtr + 47);
                dsd.dsOffset = this.readIntBuf(sph, dsdPtr + 133 + 1, 20);
                dsd.dsSize = this.readIntBuf(sph, dsdPtr + 170 + 1, 20);
                dsd.numDsr = this.readIntBuf(sph, dsdPtr + 207 + 1, 10);
                dsd.dsrSize = this.readIntBuf(sph, dsdPtr + 228 + 1, 10);
                dsd.dsName = this.readStringBuf(sph, dsdPtr + 9, 28);
            }
            this.dsDescriptors[i] = dsd;
            dsdPtr += this.dsd_size;
        }
        return sph;
    }

    private void copyHeader(byte[] mph, byte[] sph) throws IOException {
        this.outputStream.seek(0L);
        this.outputStream.write(mph);
        this.outputStream.write(sph);
        for (DatasetDescriptor descriptor : this.dsDescriptors) {
            byte[] buf = new byte[descriptor.dsSize];
            if (descriptor.dsName != null && descriptor.dsName.startsWith("Radiance")) continue;
            this.inputStream.seek(descriptor.dsOffset);
            this.inputStream.read(buf);
            this.outputStream.seek(descriptor.dsOffset);
            this.outputStream.write(buf);
        }
    }

    private int readIntBuf(byte[] buf, int offset, int length) {
        return Integer.parseInt(new String(buf, offset, length));
    }

    private char readCharBuf(byte[] buf, int offset) {
        return (char)buf[offset];
    }

    private String readStringBuf(byte[] buf, int offset, int length) {
        return new String(buf, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle rectangle = targetTile.getRectangle();
        pm.beginTask("Patching product...", rectangle.height);
        try {
            Tile srcTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(band.getName()), rectangle);
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    targetTile.setSample(x, y, srcTile.getSampleDouble(x, y));
                }
            }
            Object object = this.syncObject;
            synchronized (object) {
                DatasetDescriptor descriptor;
                if (band.getName().startsWith("radiance")) {
                    DatasetDescriptor descriptor2 = this.getDatasetDescriptorForBand(band);
                    if (descriptor2 != null) {
                        short[] data = (short[])srcTile.getRawSamples().getElems();
                        byte[] buf = new byte[rectangle.height * descriptor2.dsrSize];
                        long dsrOffset = descriptor2.dsOffset + (long)(rectangle.y * descriptor2.dsrSize);
                        this.inputStream.seek(dsrOffset);
                        this.inputStream.read(buf);
                        this.outputStream.seek(dsrOffset);
                        for (int y = 0; y < rectangle.height; ++y) {
                            this.outputStream.write(buf, y * descriptor2.dsrSize, 13);
                            this.outputStream.skipBytes((this.targetProduct.getSceneRasterWidth() - rectangle.width - rectangle.x) * 2);
                            for (int x = rectangle.width - 1; x >= 0; --x) {
                                this.outputStream.writeShort(data[x + y * rectangle.width]);
                            }
                            this.outputStream.skipBytes(rectangle.x * 2);
                            this.checkForCancellation();
                            pm.worked(1);
                        }
                    }
                } else if ("l1_flags".equals(band.getName()) && (descriptor = this.getDatasetDescriptorForFlagBand()) != null) {
                    byte[] data = (byte[])srcTile.getRawSamples().getElems();
                    long dsrOffset = descriptor.dsOffset + (long)(rectangle.y * descriptor.dsrSize);
                    this.outputStream.seek(dsrOffset);
                    for (int y = 0; y < rectangle.height; ++y) {
                        this.outputStream.skipBytes(13);
                        this.outputStream.skipBytes(this.targetProduct.getSceneRasterWidth() - rectangle.width - rectangle.x);
                        for (int x = rectangle.width - 1; x >= 0; --x) {
                            this.outputStream.writeByte(data[x + y * rectangle.width]);
                        }
                        this.outputStream.skipBytes(rectangle.x);
                        this.outputStream.skipBytes(this.targetProduct.getSceneRasterWidth() * 2);
                        this.checkForCancellation();
                        pm.worked(1);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
        finally {
            pm.done();
        }
    }

    private DatasetDescriptor getDatasetDescriptorForFlagBand() {
        for (DatasetDescriptor dsDescriptor : this.dsDescriptors) {
            String dsName = dsDescriptor.dsName;
            if (dsName == null || !dsName.startsWith("Flag")) continue;
            return dsDescriptor;
        }
        return null;
    }

    private DatasetDescriptor getDatasetDescriptorForBand(Band band) {
        for (DatasetDescriptor dsDescriptor : this.dsDescriptors) {
            String dsName = dsDescriptor.dsName;
            if (dsName == null || !dsName.startsWith("Radiance")) continue;
            int beginIndex = dsName.indexOf(40);
            int endIndex = dsName.indexOf(41, beginIndex);
            String bandNumber = dsName.substring(beginIndex + 1, endIndex);
            String bandName = "radiance_" + bandNumber;
            if (!bandName.equals(band.getName())) continue;
            return dsDescriptor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            Object object = this.syncObject;
            synchronized (object) {
                this.targetProduct.closeIO();
                this.inputStream.close();
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(N1PatcherOp.class);
        }
    }

    private static final class DatasetDescriptor {
        private boolean isSpare = false;
        private char dsType;
        private int dsSize;
        private long dsOffset;
        private long dsdPtr;
        private int numDsr;
        private int dsrSize;
        private String dsName;

        private DatasetDescriptor() {
        }
    }
}

