/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.pointop;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.pointop.PointOperator;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.WritableSample;

public abstract class PixelOperator
extends PointOperator {
    protected abstract void computePixel(int var1, int var2, Sample[] var3, WritableSample[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void computeTileStack(Map<Band, Tile> targetTileStack, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        Point location = new Point();
        Sample[] sourceSamples = this.createSourceSamples(targetRectangle, location);
        WritableSample[] targetSamples = this.createTargetSamples(targetTileStack, location);
        int x1 = targetRectangle.x;
        int y1 = targetRectangle.y;
        int x2 = x1 + targetRectangle.width - 1;
        int y2 = y1 + targetRectangle.height - 1;
        try {
            pm.beginTask(this.getId(), targetRectangle.height);
            location.y = y1;
            while (location.y <= y2) {
                location.x = x1;
                while (location.x <= x2) {
                    this.computePixel(location.x, location.y, sourceSamples, targetSamples);
                    ++location.x;
                }
                pm.worked(1);
                ++location.y;
            }
        }
        finally {
            pm.done();
        }
    }
}

