/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.internal;

import com.bc.ceres.core.Assert;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.internal.DefaultTileIterator;
import org.esa.beam.util.BitSetter;
import org.esa.beam.util.ImageUtils;

public class TileImpl
implements Tile {
    private final RasterDataNode rasterDataNode;
    private final Raster raster;
    private final WritableRaster writableRaster;
    private final int minX;
    private final int minY;
    private final int maxX;
    private final int maxY;
    private final int width;
    private final int height;
    private final boolean target;
    private final boolean scaled;
    private final boolean signedByte;
    private final int scanlineOffset;
    private final int scanlineStride;
    private final byte[] dataBufferByte;
    private final short[] dataBufferShort;
    private final int[] dataBufferInt;
    private final float[] dataBufferFloat;
    private final double[] dataBufferDouble;
    private ProductData dataBuffer;
    private ProductData rawSamples;
    private boolean mustWriteSampleData;

    public TileImpl(RasterDataNode rasterDataNode, Raster raster) {
        this(rasterDataNode, raster, new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight()), false);
    }

    public TileImpl(RasterDataNode rasterDataNode, WritableRaster raster, Rectangle rectangle) {
        this(rasterDataNode, raster, rectangle, true);
    }

    public TileImpl(RasterDataNode rasterDataNode, Raster raster, Rectangle rectangle, boolean target) {
        WritableRaster writableRaster;
        Assert.notNull((Object)rasterDataNode, (String)"rasterDataNode");
        Assert.argument((raster.getNumBands() == 1 ? 1 : 0) != 0, (String)"raster");
        WritableRaster writableRaster2 = writableRaster = raster instanceof WritableRaster ? (WritableRaster)raster : null;
        if (target) {
            Assert.argument((writableRaster != null ? 1 : 0) != 0, (String)"raster");
        }
        Assert.argument((boolean)(raster.getSampleModel() instanceof ComponentSampleModel), (String)"raster");
        ComponentSampleModel sm = (ComponentSampleModel)raster.getSampleModel();
        Assert.argument((sm.getNumBands() == 1 ? 1 : 0) != 0, (String)"raster");
        DataBuffer db = raster.getDataBuffer();
        Assert.argument((db.getNumBanks() == 1 ? 1 : 0) != 0, (String)"raster");
        Assert.notNull((Object)rectangle, (String)"rectangle");
        this.rasterDataNode = rasterDataNode;
        this.raster = raster;
        this.writableRaster = writableRaster;
        this.minX = rectangle.x;
        this.minY = rectangle.y;
        this.maxX = rectangle.x + rectangle.width - 1;
        this.maxY = rectangle.y + rectangle.height - 1;
        this.width = rectangle.width;
        this.height = rectangle.height;
        this.target = target;
        this.scaled = rasterDataNode.isScalingApplied();
        this.signedByte = rasterDataNode.getDataType() == 10;
        int smX0 = rectangle.x - raster.getSampleModelTranslateX();
        int smY0 = rectangle.y - raster.getSampleModelTranslateY();
        int dbI0 = db.getOffset();
        this.scanlineStride = sm.getScanlineStride();
        this.scanlineOffset = smY0 * this.scanlineStride + smX0 + dbI0;
        Object primitiveArray = ImageUtils.getPrimitiveArray((DataBuffer)db);
        this.dataBufferByte = primitiveArray instanceof byte[] ? (byte[])primitiveArray : null;
        this.dataBufferShort = primitiveArray instanceof short[] ? (short[])primitiveArray : null;
        this.dataBufferInt = primitiveArray instanceof int[] ? (int[])primitiveArray : null;
        this.dataBufferFloat = primitiveArray instanceof float[] ? (float[])primitiveArray : null;
        this.dataBufferDouble = primitiveArray instanceof double[] ? (double[])primitiveArray : null;
    }

    @Override
    public float toGeoPhysical(float sample) {
        return (float)this.rasterDataNode.scale((double)sample);
    }

    @Override
    public double toGeoPhysical(double sample) {
        return this.rasterDataNode.scale(sample);
    }

    @Override
    public float toRaw(float sample) {
        return (float)this.rasterDataNode.scaleInverse((double)sample);
    }

    @Override
    public double toRaw(double sample) {
        return this.rasterDataNode.scaleInverse(sample);
    }

    @Override
    public final boolean isTarget() {
        return this.target;
    }

    @Override
    public boolean isSampleValid(int x, int y) {
        return this.rasterDataNode.isPixelValid(x, y);
    }

    @Override
    public final Rectangle getRectangle() {
        return new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    @Override
    public final int getMinX() {
        return this.minX;
    }

    @Override
    public final int getMaxX() {
        return this.maxX;
    }

    @Override
    public final int getMinY() {
        return this.minY;
    }

    @Override
    public final int getMaxY() {
        return this.maxY;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final RasterDataNode getRasterDataNode() {
        return this.rasterDataNode;
    }

    @Override
    public int getDataBufferIndex(int x, int y) {
        return this.scanlineOffset + (x - this.minX) + (y - this.minY) * this.scanlineStride;
    }

    @Override
    public synchronized ProductData getDataBuffer() {
        if (this.dataBuffer == null) {
            this.dataBuffer = ProductData.createInstance((int)this.rasterDataNode.getDataType(), (Object)ImageUtils.getPrimitiveArray((DataBuffer)this.raster.getDataBuffer()));
        }
        return this.dataBuffer;
    }

    @Override
    public final byte[] getDataBufferByte() {
        return this.dataBufferByte;
    }

    @Override
    public final short[] getDataBufferShort() {
        return this.dataBufferShort;
    }

    @Override
    public final int[] getDataBufferInt() {
        return this.dataBufferInt;
    }

    @Override
    public final float[] getDataBufferFloat() {
        return this.dataBufferFloat;
    }

    @Override
    public final double[] getDataBufferDouble() {
        return this.dataBufferDouble;
    }

    @Override
    public final int getScanlineOffset() {
        return this.scanlineOffset;
    }

    @Override
    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    @Override
    public synchronized ProductData getRawSamples() {
        ProductData dataBuffer;
        if (this.rawSamples == null && this.width * this.height == (dataBuffer = this.getDataBuffer()).getNumElems()) {
            this.rawSamples = dataBuffer;
        }
        if (this.rawSamples == null) {
            this.rawSamples = this.rasterDataNode.createCompatibleRasterData(this.width, this.height);
            if (this.target) {
                this.mustWriteSampleData = true;
            } else {
                this.raster.getDataElements(this.minX, this.minY, this.width, this.height, this.rawSamples.getElems());
            }
        }
        return this.rawSamples;
    }

    @Override
    public synchronized void setRawSamples(ProductData rawSamples) {
        Assert.notNull((Object)rawSamples, (String)"rawSamples");
        if (this.target && (rawSamples != this.rawSamples || this.mustWriteSampleData)) {
            this.writableRaster.setDataElements(this.minX, this.minY, this.width, this.height, rawSamples.getElems());
        }
    }

    @Override
    public byte[] getSamplesByte() {
        if (this.getRasterDataNode().isValidMaskUsed()) {
            int size = this.width * this.height;
            byte[] samples = new byte[size];
            int i = 0;
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    samples[i++] = this.isSampleValid(x, y) ? (byte)this.getSampleInt(x, y) : (byte)0;
                }
            }
            return samples;
        }
        ProductData data = this.getRawSamples();
        if (!(this.scaled || data.getType() != 10 && data.getType() != 20)) {
            return (byte[])data.getElems();
        }
        int size = data.getNumElems();
        byte[] samples = new byte[size];
        if (this.scaled) {
            for (int i = 0; i < size; ++i) {
                samples[i] = (byte)this.toGeoPhysical(data.getElemIntAt(i));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                samples[i] = (byte)data.getElemIntAt(i);
            }
        }
        return samples;
    }

    @Override
    public short[] getSamplesShort() {
        if (this.getRasterDataNode().isValidMaskUsed()) {
            int size = this.width * this.height;
            short[] samples = new short[size];
            int i = 0;
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    samples[i++] = this.isSampleValid(x, y) ? (short)this.getSampleInt(x, y) : (short)0;
                }
            }
            return samples;
        }
        ProductData data = this.getRawSamples();
        if (!(this.scaled || data.getType() != 11 && data.getType() != 21)) {
            return (short[])data.getElems();
        }
        int size = data.getNumElems();
        short[] samples = new short[size];
        if (this.scaled) {
            for (int i = 0; i < size; ++i) {
                samples[i] = (short)this.toGeoPhysical(data.getElemIntAt(i));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                samples[i] = (short)data.getElemIntAt(i);
            }
        }
        return samples;
    }

    @Override
    public int[] getSamplesInt() {
        if (this.getRasterDataNode().isValidMaskUsed()) {
            int size = this.width * this.height;
            int[] samples = new int[size];
            int i = 0;
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    samples[i++] = this.isSampleValid(x, y) ? this.getSampleInt(x, y) : 0;
                }
            }
            return samples;
        }
        ProductData data = this.getRawSamples();
        if (!(this.scaled || data.getType() != 12 && data.getType() != 22)) {
            return (int[])data.getElems();
        }
        int size = data.getNumElems();
        int[] samples = new int[size];
        if (this.scaled) {
            for (int i = 0; i < size; ++i) {
                samples[i] = (int)this.toGeoPhysical(data.getElemIntAt(i));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                samples[i] = data.getElemIntAt(i);
            }
        }
        return samples;
    }

    @Override
    public float[] getSamplesFloat() {
        if (this.getRasterDataNode().isValidMaskUsed()) {
            int size = this.width * this.height;
            float[] samples = new float[size];
            int i = 0;
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    samples[i++] = this.isSampleValid(x, y) ? this.getSampleFloat(x, y) : Float.NaN;
                }
            }
            return samples;
        }
        ProductData data = this.getRawSamples();
        if (!this.scaled && data.getType() == 30) {
            return (float[])data.getElems();
        }
        int size = data.getNumElems();
        float[] samples = new float[size];
        if (this.scaled) {
            for (int i = 0; i < size; ++i) {
                samples[i] = this.toGeoPhysical(data.getElemFloatAt(i));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                samples[i] = data.getElemFloatAt(i);
            }
        }
        return samples;
    }

    @Override
    public double[] getSamplesDouble() {
        if (this.getRasterDataNode().isValidMaskUsed()) {
            int size = this.width * this.height;
            double[] samples = new double[size];
            int i = 0;
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    samples[i++] = this.isSampleValid(x, y) ? this.getSampleDouble(x, y) : Double.NaN;
                }
            }
            return samples;
        }
        ProductData data = this.getRawSamples();
        if (!this.scaled && data.getType() == 31) {
            return (double[])data.getElems();
        }
        int size = data.getNumElems();
        double[] samples = new double[size];
        if (this.scaled) {
            for (int i = 0; i < size; ++i) {
                samples[i] = this.toGeoPhysical(data.getElemDoubleAt(i));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                samples[i] = data.getElemDoubleAt(i);
            }
        }
        return samples;
    }

    @Override
    public void setSamples(byte[] samples) {
        int i = 0;
        for (int y = this.minY; y <= this.maxY; ++y) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                this.setSample(x, y, samples[i++]);
            }
        }
    }

    @Override
    public void setSamples(short[] samples) {
        int i = 0;
        for (int y = this.minY; y <= this.maxY; ++y) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                this.setSample(x, y, samples[i++]);
            }
        }
    }

    @Override
    public void setSamples(int[] samples) {
        int i = 0;
        for (int y = this.minY; y <= this.maxY; ++y) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                this.setSample(x, y, samples[i++]);
            }
        }
    }

    @Override
    public void setSamples(float[] samples) {
        int i = 0;
        for (int y = this.minY; y <= this.maxY; ++y) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                this.setSample(x, y, samples[i++]);
            }
        }
    }

    @Override
    public void setSamples(double[] samples) {
        int i = 0;
        for (int y = this.minY; y <= this.maxY; ++y) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                this.setSample(x, y, samples[i++]);
            }
        }
    }

    @Override
    public boolean getSampleBoolean(int x, int y) {
        return this.getSampleInt(x, y) != 0;
    }

    @Override
    public void setSample(int x, int y, boolean sample) {
        this.setSample(x, y, sample ? 1 : 0);
    }

    @Override
    public int getSampleInt(int x, int y) {
        int sample = this.raster.getSample(x, y, 0);
        if (this.signedByte) {
            sample = (byte)sample;
        }
        if (this.scaled) {
            sample = (int)Math.floor((double)this.toGeoPhysical(sample) + 0.5);
        }
        return sample;
    }

    @Override
    public void setSample(int x, int y, int sample) {
        if (this.scaled) {
            sample = (int)Math.floor(this.toRaw((double)sample) + 0.5);
        }
        this.writableRaster.setSample(x, y, 0, sample);
    }

    @Override
    public float getSampleFloat(int x, int y) {
        float sample = this.raster.getSampleFloat(x, y, 0);
        if (this.signedByte) {
            sample = (byte)sample;
        }
        if (this.scaled) {
            sample = this.toGeoPhysical(sample);
        }
        return sample;
    }

    @Override
    public void setSample(int x, int y, float sample) {
        if (this.scaled) {
            sample = this.toRaw(sample);
        }
        this.writableRaster.setSample(x, y, 0, sample);
    }

    @Override
    public double getSampleDouble(int x, int y) {
        double sample = this.raster.getSampleDouble(x, y, 0);
        if (this.signedByte) {
            sample = (byte)sample;
        }
        if (this.scaled) {
            sample = this.toGeoPhysical(sample);
        }
        return sample;
    }

    @Override
    public void setSample(int x, int y, double sample) {
        if (this.scaled) {
            sample = this.toRaw(sample);
        }
        this.writableRaster.setSample(x, y, 0, sample);
    }

    @Override
    public boolean getSampleBit(int x, int y, int bitIndex) {
        long sample = this.raster.getSample(x, y, 0);
        return BitSetter.isFlagSet((long)sample, (int)bitIndex);
    }

    @Override
    public void setSample(int x, int y, int bitIndex, boolean sample) {
        long longSample = this.raster.getSample(x, y, 0);
        long newSample = BitSetter.setFlag((long)longSample, (int)bitIndex, (boolean)sample);
        this.writableRaster.setSample(x, y, 0, newSample);
    }

    @Override
    public Iterator<Tile.Pos> iterator() {
        return new DefaultTileIterator(this.getRectangle());
    }
}

