/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.internal;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;

public class RasterDataNodeValues {
    public static final String ATTRIBUTE_NAME = "rasterDataNodeType";

    public static String[] getNames(Product product, Class<? extends RasterDataNode> rasterDataNodeType) {
        return RasterDataNodeValues.getNames(product, rasterDataNodeType, false);
    }

    public static String[] getNames(Product product, Class<? extends RasterDataNode> rasterDataNodeType, boolean includeEmptyValue) {
        String[] allValues;
        if (includeEmptyValue) {
            String[] valueNames = RasterDataNodeValues.getValueNames(product, rasterDataNodeType);
            allValues = new String[valueNames.length + 1];
            allValues[0] = "";
            System.arraycopy(valueNames, 0, allValues, 1, valueNames.length);
        } else {
            allValues = RasterDataNodeValues.getValueNames(product, rasterDataNodeType);
        }
        return allValues;
    }

    private static String[] getValueNames(Product product, Class<? extends RasterDataNode> rasterDataNodeType) {
        if (rasterDataNodeType == Band.class) {
            return product.getBandNames();
        }
        if (rasterDataNodeType == Mask.class) {
            return product.getMaskGroup().getNodeNames();
        }
        if (rasterDataNodeType == TiePointGrid.class) {
            return product.getTiePointGridNames();
        }
        throw new IllegalArgumentException("Unsupported 'rasterDataNodeType': " + rasterDataNodeType);
    }
}

