/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.internal;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.esa.beam.framework.gpf.Tile;

public class DefaultTileIterator
implements Iterator<Tile.Pos> {
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;
    private int x;
    private int y;
    private boolean done;

    public DefaultTileIterator(Rectangle rectangle) {
        this.x1 = rectangle.x;
        this.y1 = rectangle.y;
        this.x2 = this.x1 + rectangle.width - 1;
        this.y2 = this.y1 + rectangle.height - 1;
        this.x = this.x1;
        this.y = this.y1;
        this.done = this.x > this.x2 && this.y > this.y2;
    }

    @Override
    public final boolean hasNext() {
        return !this.done;
    }

    @Override
    public final Tile.Pos next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        Tile.Pos p = new Tile.Pos(this.x, this.y);
        ++this.x;
        if (this.x > this.x2) {
            this.x = this.x1;
            ++this.y;
            if (this.y > this.y2) {
                this.y = this.y1;
                this.done = true;
            }
        }
        return p;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

