/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.graph;

import com.bc.ceres.core.Assert;
import java.lang.reflect.Field;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.GPF;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.OperatorSpiRegistry;
import org.esa.beam.framework.gpf.graph.GraphContext;
import org.esa.beam.framework.gpf.graph.GraphException;
import org.esa.beam.framework.gpf.graph.Node;
import org.esa.beam.framework.gpf.internal.OperatorConfiguration;
import org.esa.beam.framework.gpf.internal.OperatorContext;

public class NodeContext {
    private final GraphContext graphContext;
    private final Node node;
    private Operator operator;
    private OperatorContext operatorContext;
    private int referenceCount;
    private Product targetProduct;

    NodeContext(GraphContext graphContext, Node node) throws GraphException {
        this.graphContext = graphContext;
        this.node = node;
        this.initOperator();
        this.initOperatorContext();
    }

    public GraphContext getGraphContext() {
        return this.graphContext;
    }

    public Node getNode() {
        return this.node;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean isOutput() {
        return this.referenceCount == 0;
    }

    void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public void initTargetProduct() throws GraphException {
        try {
            this.targetProduct = this.operator.getTargetProduct();
        }
        catch (OperatorException e) {
            throw new GraphException(e.getMessage(), e);
        }
    }

    public Product getTargetProduct() {
        Assert.notNull((Object)this.targetProduct, (String)"targetProduct");
        return this.targetProduct;
    }

    PlanarImage getTargetImage(Band band) {
        return this.operatorContext.getTargetImage(band);
    }

    public boolean canComputeTileStack() {
        return this.operatorContext.isComputeTileStackMethodUsable();
    }

    public boolean isInitialized() {
        return this.operatorContext.isInitialized();
    }

    public void addSourceProduct(String id, Product sourceProduct) {
        this.operator.setSourceProduct(id, sourceProduct);
    }

    public void setOperatorConfiguration(OperatorConfiguration opConfiguration) {
        this.operatorContext.setConfiguration(opConfiguration);
    }

    public Product getSourceProduct(String id) {
        return this.operator.getSourceProduct(id);
    }

    public Product[] getSourceProducts() {
        return this.operator.getSourceProducts();
    }

    private void initOperator() throws GraphException {
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi operatorSpi = spiRegistry.getOperatorSpi(this.node.getOperatorName());
        if (operatorSpi == null) {
            throw new GraphException("SPI not found for operator '" + this.node.getOperatorName() + "'");
        }
        try {
            this.operator = operatorSpi.createOperator();
            this.operator.setLogger(this.graphContext.getLogger());
        }
        catch (OperatorException e) {
            throw new GraphException("Failed to create instance of operator '" + this.node.getOperatorName() + "'", e);
        }
    }

    private void initOperatorContext() {
        try {
            Field field = Operator.class.getDeclaredField("context");
            field.setAccessible(true);
            this.operatorContext = (OperatorContext)field.get(this.operator);
            this.operatorContext.setId(this.node.getId());
            field.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void dispose() {
        if (this.operatorContext != null && !this.operatorContext.isDisposed()) {
            this.operatorContext.dispose();
            this.operatorContext = null;
            this.operator = null;
        }
        if (this.targetProduct != null) {
            this.targetProduct.dispose();
            this.targetProduct = null;
        }
    }
}

