/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.experimental;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import javax.media.jai.JAI;
import javax.media.jai.TileRequest;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;

public class OperatorExecutor2 {
    private final Product product;
    private final Dimension frameSize;

    public OperatorExecutor2(Product product) {
        this.product = product;
        this.frameSize = product.getPreferredTileSize();
    }

    public Dimension getFrameSize() {
        return new Dimension(this.frameSize);
    }

    public void setFrameSize(int w, int h) {
        this.frameSize.setSize(w, h);
    }

    public Object execute(Handler handler) throws Exception {
        int parallelism = Runtime.getRuntime().availableProcessors();
        System.out.println("parallelism = " + parallelism);
        JAI.getDefaultInstance().getTileScheduler().setParallelism(parallelism);
        Dimension frameSize = this.getFrameSize();
        int numXFrames = 1 + (this.product.getSceneRasterWidth() - 1) / frameSize.width;
        int numYFrames = 1 + (this.product.getSceneRasterHeight() - 1) / frameSize.height;
        Rectangle sceneRegion = new Rectangle(this.product.getSceneRasterWidth(), this.product.getSceneRasterHeight());
        for (int frameY = 0; frameY < numYFrames; ++frameY) {
            for (int frameX = 0; frameX < numXFrames; ++frameX) {
                Rectangle frameRegion = new Rectangle(frameX * frameSize.width, frameY * frameSize.height, frameSize.width, frameSize.height).intersection(sceneRegion);
                int numBands = this.product.getNumBands();
                Band[] bandArray = new Band[numBands];
                ProductData[] dataArray = new ProductData[numBands];
                for (int b = 0; b < numBands; ++b) {
                    Band band = this.product.getBandAt(b);
                    MultiLevelImage planarImage = band.getSourceImage();
                    Point[] indices = planarImage.getTileIndices(null);
                    System.out.println("indices = " + indices.length);
                    TileRequest tileRequest = planarImage.queueTiles(indices);
                    Raster raster = planarImage.getData();
                    System.out.println("raster = " + raster);
                    ProductData data = band.createCompatibleRasterData(frameRegion.width, frameRegion.height);
                    band.readRasterData(frameRegion.x, frameRegion.y, frameRegion.width, frameRegion.height, data);
                    bandArray[b] = band;
                    dataArray[b] = data;
                }
                MyFrame frame = new MyFrame(frameRegion, bandArray, dataArray);
                handler.frameComputed(frame);
            }
        }
        return new Object();
    }

    private static class MyFrame
    implements Frame {
        private final Rectangle region;
        private final Band[] bandArray;
        private final ProductData[] dataArray;

        public MyFrame(Rectangle region, Band[] bandArray, ProductData[] dataArray) {
            this.region = region;
            this.bandArray = bandArray;
            this.dataArray = dataArray;
        }

        @Override
        public Rectangle getRegion() {
            return this.region;
        }

        @Override
        public int getNumBands() {
            return this.bandArray.length;
        }

        @Override
        public Band getBand(int index) {
            return this.bandArray[index];
        }

        @Override
        public ProductData getData(int index) {
            return this.dataArray[index];
        }
    }

    public static interface Frame {
        public Rectangle getRegion();

        public int getNumBands();

        public Band getBand(int var1);

        public ProductData getData(int var1);
    }

    public static interface Handler {
        public void frameComputed(Frame var1);
    }
}

