/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.doclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.gpf.doclet.OperatorDesc;
import org.esa.beam.framework.gpf.doclet.OperatorHandler;

public class OperatorHandlerConsole
implements OperatorHandler {
    @Override
    public void start(RootDoc root) {
    }

    @Override
    public void stop(RootDoc root) {
    }

    @Override
    public void processOperator(OperatorDesc operatorDesc) throws Exception {
        FieldDoc[] fieldDocs;
        ClassDoc typeDoc = operatorDesc.getClassDoc();
        StringBuilder sb = new StringBuilder(300);
        sb.append(String.format("Operator: %s\n", typeDoc.typeName()));
        sb.append(String.format("\tClass: %s\n", typeDoc.qualifiedTypeName()));
        sb.append(String.format("\tText: %s\n", typeDoc.commentText()));
        this.writeClassAnnotiations(typeDoc, sb);
        for (FieldDoc fieldDoc : fieldDocs = typeDoc.fields(false)) {
            this.writeFieldAnnotiations(fieldDoc, sb);
        }
        System.out.println(sb.toString());
    }

    public void writeClassAnnotiations(ClassDoc classDoc, StringBuilder sb) {
        AnnotationDesc[] annotations;
        for (AnnotationDesc annotation : annotations = classDoc.annotations()) {
            sb.append("\t").append(annotation.annotationType().name()).append(" : \n");
            this.writeAnnotationTable(annotation, sb);
        }
    }

    public void writeFieldAnnotiations(FieldDoc fieldDoc, StringBuilder sb) {
        AnnotationDesc[] annotations;
        for (AnnotationDesc annotation : annotations = fieldDoc.annotations()) {
            String fieldName = fieldDoc.name();
            sb.append("\t").append(annotation.annotationType().name()).append(String.format(" [%s]", fieldName));
            sb.append(" : \n");
            this.writeAnnotationTable(annotation, sb);
        }
    }

    public void writeAnnotationTable(AnnotationDesc annotation, StringBuilder sb) {
        AnnotationTypeElementDoc[] annotationElements = annotation.annotationType().elements();
        if (annotationElements.length > 0) {
            Map<String, String> elementValueMap = this.createElementValueMap(annotation);
            sb.append(String.format("\t\t%1$20s %2$20s %3$20s\n", "NAME", "VALUE", "DEFAULT"));
            for (AnnotationTypeElementDoc annotationElement : annotationElements) {
                sb.append(String.format("\t\t%1$20s %2$20s %3$20s\n", annotationElement.name(), elementValueMap.get(annotationElement.name()), annotationElement.defaultValue()));
            }
        }
    }

    public Map<String, String> createElementValueMap(AnnotationDesc annotation) {
        AnnotationDesc.ElementValuePair[] elementValuePairs = annotation.elementValues();
        HashMap<String, String> elementValueMap = new HashMap<String, String>();
        for (AnnotationDesc.ElementValuePair elementValuePair : elementValuePairs) {
            elementValueMap.put(elementValuePair.element().name(), elementValuePair.value().toString());
        }
        return elementValueMap;
    }
}

