/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.descriptor;

import com.bc.ceres.core.Assert;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.descriptor.SourceProductDescriptor;

public class AnnotationSourceProductDescriptor
implements SourceProductDescriptor {
    private final SourceProduct annotation;
    private final String name;

    public AnnotationSourceProductDescriptor(String name, SourceProduct annotation) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)annotation, (String)"annotation");
        this.name = name;
        this.annotation = annotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SourceProduct getAnnotation() {
        return this.annotation;
    }

    @Override
    public boolean isOptional() {
        return this.annotation.optional();
    }

    @Override
    public String getProductType() {
        return AnnotationSourceProductDescriptor.getNonEmptyStringOrNull(this.annotation.type());
    }

    @Override
    public String[] getBands() {
        return this.annotation.bands();
    }

    @Override
    public String getAlias() {
        return AnnotationSourceProductDescriptor.getNonEmptyStringOrNull(this.annotation.alias());
    }

    @Override
    public String getDescription() {
        return AnnotationSourceProductDescriptor.getNonEmptyStringOrNull(this.annotation.description());
    }

    @Override
    public String getLabel() {
        return AnnotationSourceProductDescriptor.getNonEmptyStringOrNull(this.annotation.label());
    }

    @Override
    public Class<? extends Product> getDataType() {
        return Product.class;
    }

    private static String getNonEmptyStringOrNull(String label) {
        return label == null || label.isEmpty() ? null : label;
    }
}

