/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorCancelException;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.internal.OperatorExecutor;
import org.esa.snap.core.gpf.internal.OperatorProductReader;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModelessDialog;

public abstract class SingleTargetProductDialog
extends ModelessDialog {
    protected TargetProductSelector targetProductSelector;
    protected AppContext appContext;
    private long createTargetProductTime;

    protected SingleTargetProductDialog(AppContext appContext, String title, String helpID) {
        this(appContext, title, 152, helpID);
    }

    protected SingleTargetProductDialog(AppContext appContext, String title, int buttonMask, String helpID) {
        this(appContext, title, buttonMask, helpID, new TargetProductSelectorModel());
    }

    protected SingleTargetProductDialog(AppContext appContext, String title, int buttonMask, String helpID, TargetProductSelectorModel model) {
        this(appContext, title, buttonMask, helpID, model, false);
    }

    protected SingleTargetProductDialog(AppContext appContext, String title, int buttonMask, String helpID, TargetProductSelectorModel model, boolean alwaysWriteOutput) {
        super(appContext.getApplicationWindow(), title, buttonMask, helpID);
        this.appContext = appContext;
        this.targetProductSelector = new TargetProductSelector(model, alwaysWriteOutput);
        String homeDirPath = SystemUtils.getUserHomeDir().getPath();
        String saveDir = appContext.getPreferences().getPropertyString("last_product_save_dir", homeDirPath);
        this.targetProductSelector.getModel().setProductDir(new File(saveDir));
        if (!alwaysWriteOutput) {
            this.targetProductSelector.getOpenInAppCheckBox().setText("Open in " + appContext.getApplicationName());
        }
        this.targetProductSelector.getModel().getValueContainer().addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("saveToFileSelected") || evt.getPropertyName().equals("openInAppSelected")) {
                this.updateRunButton();
            }
        });
        AbstractButton button = this.getButton(8);
        button.setText("Run");
        button.setMnemonic('R');
        this.updateRunButton();
    }

    private void updateRunButton() {
        AbstractButton button = this.getButton(8);
        boolean save = this.targetProductSelector.getModel().isSaveToFileSelected();
        boolean open = this.targetProductSelector.getModel().isOpenInAppSelected();
        String toolTipText = "";
        boolean enabled = true;
        if (save && open) {
            toolTipText = "Save target product and open it in " + this.getAppContext().getApplicationName();
        } else if (save) {
            toolTipText = "Save target product";
        } else if (open) {
            toolTipText = "Open target product in " + this.getAppContext().getApplicationName();
        } else {
            enabled = false;
        }
        button.setToolTipText(toolTipText);
        button.setEnabled(enabled);
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public TargetProductSelector getTargetProductSelector() {
        return this.targetProductSelector;
    }

    protected void onApply() {
        if (!this.canApply()) {
            return;
        }
        String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
        this.appContext.getPreferences().setPropertyString("last_product_save_dir", productDir);
        Product targetProduct = null;
        try {
            long t0 = System.currentTimeMillis();
            targetProduct = this.createTargetProduct();
            this.createTargetProductTime = System.currentTimeMillis() - t0;
            if (targetProduct == null) {
                throw new NullPointerException("Target product is null.");
            }
        }
        catch (Throwable t) {
            this.handleInitialisationError(t);
        }
        if (targetProduct == null) {
            return;
        }
        targetProduct.setName(this.targetProductSelector.getModel().getProductName());
        if (this.targetProductSelector.getModel().isSaveToFileSelected()) {
            targetProduct.setFileLocation(this.targetProductSelector.getModel().getProductFile());
            ProductWriterSwingWorker worker = new ProductWriterSwingWorker(targetProduct);
            worker.executeWithBlocking();
        } else if (this.targetProductSelector.getModel().isOpenInAppSelected()) {
            this.appContext.getProductManager().addProduct(targetProduct);
            this.showOpenInAppInfo();
        }
    }

    protected void handleInitialisationError(Throwable t) {
        if (t instanceof OperatorCancelException) {
            String msg = MessageFormat.format("An internal error occurred during the target product initialisation.\n{0}", this.formatThrowable(t));
            this.showErrorDialog(msg);
            return;
        }
        String msg = this.isInternalException(t) ? MessageFormat.format("An internal error occurred during the target product initialisation.\n{0}", this.formatThrowable(t)) : MessageFormat.format("A problem occurred during the target product initialisation.\n{0}", this.formatThrowable(t));
        this.appContext.handleError(msg, t);
    }

    protected void handleProcessingError(Throwable t) {
        if (t instanceof OperatorCancelException) {
            return;
        }
        String msg = this.isInternalException(t) ? MessageFormat.format("An internal error occurred during the target product processing.\n{0}", this.formatThrowable(t)) : MessageFormat.format("A problem occurred during the target product processing.\n{0}", this.formatThrowable(t));
        this.appContext.handleError(msg, t);
    }

    private boolean isInternalException(Throwable t) {
        return t instanceof RuntimeException && !(t instanceof OperatorException) || t instanceof Error;
    }

    private String formatThrowable(Throwable t) {
        return MessageFormat.format("Type: {0}\nMessage: {1}\n", t.getClass().getSimpleName(), t.getMessage());
    }

    protected boolean canApply() {
        File productFile;
        int answer;
        String message;
        Product existingProduct;
        String productName = this.targetProductSelector.getModel().getProductName();
        if (productName == null || productName.isEmpty()) {
            this.showErrorDialog("Please specify a target product name.");
            this.targetProductSelector.getProductNameTextField().requestFocus();
            return false;
        }
        if (this.targetProductSelector.getModel().isOpenInAppSelected() && (existingProduct = this.appContext.getProductManager().getProduct(productName)) != null) {
            message = MessageFormat.format("<html>A product with the name ''{0}'' is already opened in {1}.<br><br>Do you want to continue?", productName, this.appContext.getApplicationName());
            answer = JOptionPane.showConfirmDialog(this.getJDialog(), message, this.getTitle(), 0);
            if (answer != 0) {
                return false;
            }
        }
        if (this.targetProductSelector.getModel().isSaveToFileSelected() && (productFile = this.targetProductSelector.getModel().getProductFile()).exists()) {
            message = MessageFormat.format("<html>The specified output file<br>\"{0}\"<br> already exists.<br><br>Do you want to overwrite the existing file?", productFile.getPath());
            answer = JOptionPane.showConfirmDialog(this.getJDialog(), message, this.getTitle(), 0);
            if (answer != 0) {
                return false;
            }
        }
        return true;
    }

    private void showSaveInfo(long saveTime) {
        File productFile = this.getTargetProductSelector().getModel().getProductFile();
        String message = MessageFormat.format("<html>The target product has been successfully written to<br>{0}<br>Total time spend for processing: {1}", this.formatFile(productFile), this.formatDuration(saveTime));
        this.showSuppressibleInformationDialog(message, "saveInfo");
    }

    protected void showOpenInAppInfo() {
        String message = MessageFormat.format("<html>The target product has successfully been created and opened in {0}.<br><br>Actual processing of source to target data will be performed only on demand,<br>for example, if the target product is saved or an image view is opened.", this.appContext.getApplicationName());
        this.showSuppressibleInformationDialog(message, "openInAppInfo");
    }

    private void showSaveAndOpenInAppInfo(long saveTime) {
        File productFile = this.getTargetProductSelector().getModel().getProductFile();
        String message = MessageFormat.format("<html>The target product has been successfully written to<br><p>{0}</p><br>and has been opened in {1}.<br><br>Total time spend for processing: {2}<br>", this.formatFile(productFile), this.appContext.getApplicationName(), this.formatDuration(saveTime));
        this.showSuppressibleInformationDialog(message, "saveAndOpenInAppInfo");
    }

    String formatFile(File file) {
        return FileUtils.getDisplayText((File)file, (int)54);
    }

    String formatDuration(long millis) {
        long seconds = millis / 1000L;
        millis -= seconds * 1000L;
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        return String.format("%02d:%02d:%02d.%03d", hours, minutes -= hours * 60L, seconds, millis);
    }

    public void showSuppressibleInformationDialog(String infoMessage, String propertyName) {
        Dialogs.showInformation((String)this.getTitle(), (String)infoMessage, (String)this.getQualifiedPropertyName(propertyName));
    }

    protected abstract Product createTargetProduct() throws Exception;

    private class ProductWriterSwingWorker
    extends ProgressMonitorSwingWorker<Product, Object> {
        private final Product targetProduct;
        private long saveTime;

        private ProductWriterSwingWorker(Product targetProduct) {
            super((Component)SingleTargetProductDialog.this.getJDialog(), "Writing Target Product");
            this.targetProduct = targetProduct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Product doInBackground(ProgressMonitor pm) throws Exception {
            TargetProductSelectorModel model = SingleTargetProductDialog.this.getTargetProductSelector().getModel();
            pm.beginTask("Writing...", model.isOpenInAppSelected() ? 100 : 95);
            this.saveTime = 0L;
            Product product = null;
            try {
                OperatorProductReader opReader;
                Operator operator;
                long t0 = System.currentTimeMillis();
                Operator execOp = null;
                if (this.targetProduct.getProductReader() instanceof OperatorProductReader && (operator = (opReader = (OperatorProductReader)this.targetProduct.getProductReader()).getOperatorContext().getOperator()).getSpi().getOperatorDescriptor().isAutoWriteDisabled()) {
                    execOp = operator;
                }
                if (execOp == null) {
                    WriteOp writeOp = new WriteOp(this.targetProduct, model.getProductFile(), model.getFormatName());
                    writeOp.setDeleteOutputOnFailure(true);
                    writeOp.setWriteEntireTileRows(true);
                    writeOp.setClearCacheAfterRowWrite(false);
                    execOp = writeOp;
                }
                OperatorExecutor executor = OperatorExecutor.create(execOp);
                executor.execute(SubProgressMonitor.create((ProgressMonitor)pm, (int)95));
                this.saveTime = System.currentTimeMillis() - t0;
                if (model.isOpenInAppSelected()) {
                    File targetFile = model.getProductFile();
                    if (!targetFile.exists()) {
                        targetFile = this.targetProduct.getFileLocation();
                    }
                    if (targetFile.exists() && (product = ProductIO.readProduct((File)targetFile)) == null) {
                        product = this.targetProduct;
                    }
                    pm.worked(5);
                }
            }
            finally {
                Preferences preferences;
                pm.done();
                if (product != this.targetProduct) {
                    this.targetProduct.dispose();
                }
                if ((preferences = SnapApp.getDefault().getPreferences()).getBoolean("snap.gpf.beepAfterProcessing", false)) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            return product;
        }

        protected void done() {
            TargetProductSelectorModel model = SingleTargetProductDialog.this.getTargetProductSelector().getModel();
            long totalSaveTime = this.saveTime + SingleTargetProductDialog.this.createTargetProductTime;
            try {
                Product targetProduct = (Product)this.get();
                if (model.isOpenInAppSelected()) {
                    SingleTargetProductDialog.this.appContext.getProductManager().addProduct(targetProduct);
                    SingleTargetProductDialog.this.showSaveAndOpenInAppInfo(totalSaveTime);
                } else {
                    SingleTargetProductDialog.this.showSaveInfo(totalSaveTime);
                }
            }
            catch (InterruptedException targetProduct) {
            }
            catch (ExecutionException e) {
                SingleTargetProductDialog.this.handleProcessingError(e.getCause());
            }
            catch (Throwable t) {
                SingleTargetProductDialog.this.handleProcessingError(t);
            }
        }
    }
}

