/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.crs.CrsForm;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CollocationCrsForm
extends CrsForm {
    private SourceProductSelector collocateProductSelector;

    public CollocationCrsForm(AppContext appContext) {
        super(appContext);
    }

    protected String getLabelText() {
        return "Use CRS of";
    }

    public CoordinateReferenceSystem getCRS(GeoPos referencePos) {
        Product collocationProduct = this.collocateProductSelector.getSelectedProduct();
        if (collocationProduct != null) {
            return collocationProduct.getSceneGeoCoding().getMapCRS();
        }
        return null;
    }

    protected JRadioButton createRadioButton() {
        final JRadioButton button = super.createRadioButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean collocate = button.isSelected();
                CollocationCrsForm.this.getCrsUI().firePropertyChange("collocate", !collocate, collocate);
            }
        });
        return button;
    }

    public void prepareShow() {
        this.collocateProductSelector.initProducts();
    }

    public void prepareHide() {
        this.collocateProductSelector.releaseProducts();
    }

    protected JComponent createCrsComponent() {
        this.collocateProductSelector = new SourceProductSelector(this.getAppContext(), "Product:");
        this.collocateProductSelector.setProductFilter(new CollocateProductFilter());
        this.collocateProductSelector.addSelectionChangeListener((SelectionChangeListener)new AbstractSelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                CollocationCrsForm.this.fireCrsChanged();
            }
        });
        final JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add(this.collocateProductSelector.getProductNameComboBox(), "Center");
        panel.add((Component)this.collocateProductSelector.getProductFileChooserButton(), "East");
        panel.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CollocationCrsForm.this.collocateProductSelector.getProductNameComboBox().setEnabled(panel.isEnabled());
                CollocationCrsForm.this.collocateProductSelector.getProductFileChooserButton().setEnabled(panel.isEnabled());
                boolean collocate = CollocationCrsForm.this.getRadioButton().isSelected();
                CollocationCrsForm.this.getCrsUI().firePropertyChange("collocate", !collocate, collocate);
            }
        });
        return panel;
    }

    public Product getCollocationProduct() {
        return this.collocateProductSelector.getSelectedProduct();
    }

    private class CollocateProductFilter
    implements ProductFilter {
        private CollocateProductFilter() {
        }

        public boolean accept(Product collocationProduct) {
            Product referenceProduct = CollocationCrsForm.this.getReferenceProduct();
            if (referenceProduct == collocationProduct || collocationProduct.getSceneGeoCoding() == null) {
                return false;
            }
            if (referenceProduct == null) {
                return true;
            }
            GeoCoding geoCoding = collocationProduct.getSceneGeoCoding();
            if (geoCoding.canGetGeoPos() && geoCoding.canGetPixelPos() && geoCoding instanceof CrsGeoCoding) {
                GeneralPath[] sourcePath = ProductUtils.createGeoBoundaryPaths((Product)referenceProduct);
                GeneralPath[] collocationPath = ProductUtils.createGeoBoundaryPaths((Product)collocationProduct);
                for (GeneralPath path : sourcePath) {
                    Rectangle bounds = path.getBounds();
                    for (GeneralPath colPath : collocationPath) {
                        if (!colPath.getBounds().intersects(bounds)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

