/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import java.io.File;
import javax.swing.JComboBox;
import org.esa.snap.HeadlessTestRunner;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.DefaultAppContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HeadlessTestRunner.class)
public class SourceProductSelectorTest {
    private Product[] defaultProducts;
    private DefaultAppContext appContext;

    @Before
    public void setUp() throws Exception {
        this.appContext = new DefaultAppContext("Fart, fart!");
        this.defaultProducts = new Product[4];
        for (int i = 0; i < this.defaultProducts.length; ++i) {
            this.defaultProducts[i] = new Product("P" + i, "T" + i, 10, 10);
            this.appContext.getProductManager().addProduct(this.defaultProducts[i]);
        }
        this.appContext.setSelectedProduct(this.defaultProducts[0]);
    }

    @Test
    public void testCreatedUIComponentsNotNull() {
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source:");
        selector.initProducts();
        Assert.assertNotNull((Object)selector.getProductNameLabel());
        Assert.assertNotNull((Object)selector.getProductNameComboBox());
        Assert.assertNotNull((Object)selector.getProductFileChooserButton());
    }

    @Test
    public void testCreatedUIComponentsAreSame() {
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source:");
        selector.initProducts();
        Assert.assertSame((Object)selector.getProductNameLabel(), (Object)selector.getProductNameLabel());
        Assert.assertSame((Object)selector.getProductNameComboBox(), (Object)selector.getProductNameComboBox());
        Assert.assertSame((Object)selector.getProductFileChooserButton(), (Object)selector.getProductFileChooserButton());
    }

    @Test
    public void testThatComboboxContains_4_EntriesIfEmptySelectionIsDisabled() {
        boolean enableEmptySelection = false;
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source", enableEmptySelection);
        selector.initProducts();
        JComboBox comboBox = selector.getProductNameComboBox();
        Assert.assertEquals((long)4L, (long)comboBox.getItemCount());
        Assert.assertEquals(comboBox.getItemAt(0), (Object)this.defaultProducts[0]);
        Assert.assertEquals(comboBox.getItemAt(1), (Object)this.defaultProducts[1]);
        Assert.assertEquals(comboBox.getItemAt(2), (Object)this.defaultProducts[2]);
        Assert.assertEquals(comboBox.getItemAt(3), (Object)this.defaultProducts[3]);
        Assert.assertEquals((long)4L, (long)selector.getProductCount());
    }

    @Test
    public void testThatComboboxContains_5_EntriesIfEmptySelectionIsEnabled() {
        boolean enableEmptySelection = true;
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source", enableEmptySelection);
        selector.initProducts();
        JComboBox comboBox = selector.getProductNameComboBox();
        Assert.assertEquals((long)5L, (long)comboBox.getItemCount());
        Assert.assertEquals(comboBox.getItemAt(0), null);
        Assert.assertEquals(comboBox.getItemAt(1), (Object)this.defaultProducts[0]);
        Assert.assertEquals(comboBox.getItemAt(2), (Object)this.defaultProducts[1]);
        Assert.assertEquals(comboBox.getItemAt(3), (Object)this.defaultProducts[2]);
        Assert.assertEquals(comboBox.getItemAt(4), (Object)this.defaultProducts[3]);
        Assert.assertEquals((long)4L, (long)selector.getProductCount());
    }

    @Test
    public void testSetSelectedProduct() throws Exception {
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source");
        selector.initProducts();
        Product selectedProduct = selector.getSelectedProduct();
        Assert.assertSame((Object)this.appContext.getSelectedProduct(), (Object)selectedProduct);
        selector.setSelectedProduct(this.defaultProducts[1]);
        selectedProduct = selector.getSelectedProduct();
        Assert.assertSame((Object)this.defaultProducts[1], (Object)selectedProduct);
        Product oldProduct = new Product("new", "T1", 0, 0);
        oldProduct.setFileLocation(new File(""));
        selector.setSelectedProduct(oldProduct);
        selectedProduct = selector.getSelectedProduct();
        Assert.assertSame((Object)oldProduct, (Object)selectedProduct);
        Product newProduct = new Product("new", "T2", 0, 0);
        selector.setSelectedProduct(newProduct);
        selectedProduct = selector.getSelectedProduct();
        Assert.assertSame((Object)newProduct, (Object)selectedProduct);
        Assert.assertNull((Object)oldProduct.getFileLocation());
    }

    @Test
    public void testSelectedProductIsRemoved() {
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source");
        selector.initProducts();
        this.appContext.getProductManager().removeProduct(this.defaultProducts[0]);
        Assert.assertEquals((long)(this.defaultProducts.length - 1), (long)selector.getProductCount());
    }

    @Test
    public void testNotSelectedProductIsRemoved() {
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source");
        selector.initProducts();
        this.appContext.getProductManager().removeProduct(this.defaultProducts[2]);
        Assert.assertEquals((long)(this.defaultProducts.length - 1), (long)selector.getProductCount());
    }

    @Test
    public void testNewProductIsDisposed() throws Exception {
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source");
        selector.initProducts();
        Product newProduct = new Product("new", "T1", 0, 0);
        newProduct.setFileLocation(new File(""));
        selector.setSelectedProduct(newProduct);
        Assert.assertSame((Object)newProduct, (Object)selector.getSelectedProduct());
        selector.setSelectedProduct(this.defaultProducts[0]);
        Assert.assertSame((Object)this.defaultProducts[0], (Object)selector.getSelectedProduct());
        Assert.assertNotNull((Object)newProduct.getFileLocation());
        selector.releaseProducts();
        Assert.assertNull((Object)newProduct.getFileLocation());
    }

    @Test
    public void testNewProductIsNotDisposed() throws Exception {
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source");
        selector.initProducts();
        selector.setSelectedProduct(this.defaultProducts[0]);
        Assert.assertSame((Object)this.defaultProducts[0], (Object)selector.getSelectedProduct());
        Product newProduct = new Product("new", "T1", 0, 0);
        newProduct.setFileLocation(new File(""));
        selector.setSelectedProduct(newProduct);
        Assert.assertSame((Object)newProduct, (Object)selector.getSelectedProduct());
        Assert.assertNotNull((Object)newProduct.getFileLocation());
        selector.releaseProducts();
        Assert.assertNotNull((Object)newProduct.getFileLocation());
    }

    @Test
    public void testSetSelectedIndex() throws Exception {
        SourceProductSelector selector = new SourceProductSelector((AppContext)this.appContext, "Source");
        selector.initProducts();
        Assert.assertSame((Object)this.defaultProducts[0], (Object)selector.getSelectedProduct());
        selector.setSelectedIndex(1);
        Assert.assertSame((Object)this.defaultProducts[1], (Object)selector.getSelectedProduct());
        selector.setSelectedIndex(2);
        Assert.assertSame((Object)this.defaultProducts[2], (Object)selector.getSelectedProduct());
    }
}

