/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import org.esa.snap.HeadlessTestRunner;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupportTest;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.DefaultAppContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HeadlessTestRunner.class)
public class OperatorMenuTest {
    private static OperatorParameterSupportTest.TestOpSpi testOpSpi;

    @BeforeClass
    public static void beforeClass() {
        testOpSpi = new OperatorParameterSupportTest.TestOpSpi();
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)testOpSpi);
    }

    @AfterClass
    public static void afterClass() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)testOpSpi);
    }

    @Test
    public void testOperatorAboutText() throws Exception {
        DefaultAppContext appContext = new DefaultAppContext("test");
        OperatorMenu support = new OperatorMenu(null, testOpSpi.getOperatorDescriptor(), null, (AppContext)appContext, "");
        Assert.assertEquals((Object)"Tester", (Object)support.getOperatorName());
        String operatorDescription = support.getOperatorAboutText();
        Assert.assertTrue((operatorDescription.length() > 80 ? 1 : 0) != 0);
    }

    @Test
    public void testEscapingXmlParameters() throws Exception {
        DefaultDomElement domElement = new DefaultDomElement("parameter");
        String unescapedString = "12 < 13 && 56 > 42 & \"true\" + 'a name'";
        String escapedString = "12 &lt; 13 &amp;&amp; 56 &gt; 42 &amp; &quot;true&quot; + &apos;a name&apos;";
        domElement.addChild((DomElement)new DefaultDomElement("expression", unescapedString));
        DefaultDomElement withAttribute = new DefaultDomElement("withAttribute");
        withAttribute.setAttribute("attrib", unescapedString);
        domElement.addChild((DomElement)withAttribute);
        OperatorMenu.escapeXmlElements((DomElement)domElement);
        Assert.assertEquals((Object)escapedString, (Object)domElement.getChild("expression").getValue());
        Assert.assertEquals((Object)escapedString, (Object)domElement.getChild("withAttribute").getAttribute("attrib"));
        String xmlString = domElement.toXml();
        XppDom readDomElement = OperatorMenu.createDom((String)xmlString);
        Assert.assertEquals((Object)unescapedString, (Object)readDomElement.getChild("expression").getValue());
        Assert.assertEquals((Object)unescapedString, (Object)readDomElement.getChild("withAttribute").getAttribute("attrib"));
    }
}

