/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DomElement;
import java.io.IOException;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OperatorParameterSupportTest {
    private static TestOpSpi testOpSpi;

    @BeforeClass
    public static void beforeClass() {
        testOpSpi = new TestOpSpi();
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)testOpSpi);
    }

    @AfterClass
    public static void afterClass() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)testOpSpi);
    }

    @Test
    public void testStoreAndLoadParameter() throws IOException, ValidationException, ConversionException {
        OperatorParameterSupport support = new OperatorParameterSupport(new TestOpSpi().getOperatorDescriptor());
        PropertySet container = support.getPropertySet();
        container.setValue("paramDouble", (Object)0.42);
        container.setValue("paramString", (Object)"A String!");
        container.setValue("paramComplex", (Object)new Complex(25));
        DomElement domElement = support.toDomElement();
        Assert.assertEquals((Object)"parameters", (Object)domElement.getName());
        Assert.assertEquals((long)3L, (long)domElement.getChildCount());
        Assert.assertNotNull((Object)domElement.getChild("paramDouble"));
        Assert.assertEquals((Object)"0.42", (Object)((DomElement)domElement.getChild("paramDouble")).getValue());
        Assert.assertNotNull((Object)domElement.getChild("paramString"));
        Assert.assertEquals((Object)"A String!", (Object)((DomElement)domElement.getChild("paramString")).getValue());
        Assert.assertNotNull((Object)domElement.getChild("paramComplex"));
        Assert.assertNotNull((Object)((DomElement)domElement.getChild("paramComplex")).getChild("complexInt"));
        Assert.assertEquals((Object)"25", (Object)((DomElement)((DomElement)domElement.getChild("paramComplex")).getChild("complexInt")).getValue());
        container.setValue("paramDouble", (Object)23.67);
        container.setValue("paramString", (Object)"Another String");
        container.setValue("paramComplex", (Object)new Complex(17));
        support.fromDomElement(domElement);
        Assert.assertEquals((double)0.42, (double)((Double)support.getPropertySet().getValue("paramDouble")), (double)1.0E-6);
        Assert.assertEquals((Object)"A String!", (Object)support.getPropertySet().getValue("paramString"));
        Assert.assertEquals((Object)new Complex(25), (Object)support.getPropertySet().getValue("paramComplex"));
    }

    @Test
    public void testStoreAndLoadParameterWhenNotAllParamsAreGiven() throws IOException, ValidationException, ConversionException {
        OperatorParameterSupport support = new OperatorParameterSupport(new TestOpSpi().getOperatorDescriptor());
        PropertySet container = support.getPropertySet();
        container.setValue("paramDouble", (Object)0.42);
        DomElement domElement = support.toDomElement();
        container.setValue("paramDouble", (Object)23.67);
        container.setValue("paramString", (Object)"Another String");
        container.setValue("paramComplex", (Object)new Complex(17));
        support.fromDomElement(domElement);
        Assert.assertEquals((double)0.42, (double)((Double)support.getPropertySet().getValue("paramDouble")), (double)1.0E-6);
        Assert.assertEquals(null, (Object[])((Object[])support.getPropertySet().getValue("paramString")));
        Assert.assertEquals(null, (Object[])((Object[])support.getPropertySet().getValue("paramComplex")));
    }

    public static class Complex {
        @Parameter
        private int complexInt;

        public Complex() {
            this(-1);
        }

        private Complex(int complexInt) {
            this.complexInt = complexInt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Complex complex = (Complex)o;
            return this.complexInt == complex.complexInt;
        }

        public int hashCode() {
            return this.complexInt;
        }
    }

    public static class TestOpSpi
    extends OperatorSpi {
        protected TestOpSpi() {
            super(TestOp.class);
        }
    }

    @OperatorMetadata(alias="Tester", authors="Nobody", version="42", description="This is very stupid operator.")
    public class TestOp
    extends Operator {
        @Parameter
        private double paramDouble;
        @Parameter
        private String paramString;
        @Parameter
        private Complex paramComplex;

        public void initialize() throws OperatorException {
        }
    }
}

