/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.geotiff.GeoTiffProductReader;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.junit.Assert;
import org.junit.Test;

public class BigTiffReaderTest {
    @Test
    public void testReadImageFile() throws IOException {
        URL resource = this.getClass().getResource("tiger-minisblack-strip-16.tif");
        String filePath = resource.getFile();
        GeoTiffProductReader reader = new GeoTiffProductReader((ProductReaderPlugIn)new GeoTiffProductReaderPlugIn());
        Product product = reader.readGeoTIFFProduct((ImageInputStream)new FileCacheImageInputStream(resource.openStream(), null), new File(filePath));
        Assert.assertNotNull((Object)product);
        Band band = product.getBandAt(0);
        Assert.assertNotNull((Object)band);
        int[] pixels = new int[band.getRasterWidth() * band.getRasterHeight()];
        band.readPixels(0, 0, band.getRasterWidth(), band.getRasterHeight(), pixels, ProgressMonitor.NULL);
        Assert.assertEquals((long)52428L, (long)pixels[20]);
        Assert.assertEquals((long)18295L, (long)pixels[40]);
        Assert.assertEquals((long)52418L, (long)pixels[60]);
    }
}

