/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.geotiff.internal.TiffValue;
import org.esa.beam.framework.datamodel.ProductData;

public class TiffValueTest
extends TestCase {
    private TiffValue _tiffValue;
    private ImageOutputStream _stream;

    public void setUp() throws Exception {
        this._tiffValue = this.createTiffValueInstance();
        this._stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
    }

    public void tearDown() throws Exception {
    }

    public void testWrite() throws IOException {
        int[] expected = new int[]{3, 6, 128973, 8};
        this._tiffValue.setData(ProductData.createInstance((int[])expected));
        this._tiffValue.write(this._stream);
        TiffValueTest.assertEquals((long)16L, (long)this._stream.length());
        this._stream.seek(0L);
        for (int i = 0; i < expected.length; ++i) {
            TiffValueTest.assertEquals((String)("failure at index " + i), (int)expected[i], (int)this._stream.readInt());
        }
    }

    public void testWrite_ProductDataThrowsIOException() {
        this._tiffValue.setData((ProductData)new ProductDataDummy());
        try {
            this._tiffValue.write(this._stream);
            TiffValueTest.fail((String)"IOException expected");
        }
        catch (IOException expected) {
        }
        catch (Exception notExpected) {
            TiffValueTest.fail((String)"IOException expected");
        }
    }

    public void testWrite_ThrowsIllegalStateExceptionBecauseDataWasNotSetToValue() {
        this._tiffValue.setData(null);
        try {
            this._tiffValue.write(this._stream);
            TiffValueTest.fail((String)"IllegalStateException expected");
        }
        catch (IOException notExpected) {
            TiffValueTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException expected) {
        }
        catch (Exception notExpected) {
            TiffValueTest.fail((String)"IllegalStateException expected");
        }
    }

    private TiffValue createTiffValueInstance() {
        return new TiffValue(){};
    }

    private class ProductDataDummy
    extends ProductData.Byte {
        public ProductDataDummy() {
            super(5);
        }

        public void writeTo(ImageOutputStream output) throws IOException {
            throw new IOException("dummy exception");
        }
    }
}

