/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.geotiff.internal.TiffShort;

public class TiffShortTest
extends TestCase {
    private static final int _TIFFSHORT_MAX = 65535;
    private static final int _TIFFSHORT_MIN = 0;

    public void testCreation_WithMaxValue() {
        new TiffShort(65535);
    }

    public void testCreation_WithMinValue() {
        new TiffShort(0);
    }

    public void testCreation_ValueSmallerThanMinValue() {
        try {
            new TiffShort(-1);
            TiffShortTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception notExpected) {
            TiffShortTest.fail((String)"IllegalArgumentException expected");
        }
    }

    public void testCreation_ValueBiggerThanMaxValue() {
        try {
            new TiffShort(65536);
            TiffShortTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception notExpected) {
            TiffShortTest.fail((String)"IllegalArgumentException expected");
        }
    }

    public void testGetValue() {
        TiffShort tiffShort = new TiffShort(65535);
        TiffShortTest.assertEquals((int)65535, (int)tiffShort.getValue());
        tiffShort = new TiffShort(0);
        TiffShortTest.assertEquals((int)0, (int)tiffShort.getValue());
        int value = 23456;
        tiffShort = new TiffShort(23456);
        TiffShortTest.assertEquals((int)23456, (int)tiffShort.getValue());
    }

    public void testWriteToStream() throws IOException {
        TiffShort tiffShort = new TiffShort(65535);
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        tiffShort.write((ImageOutputStream)stream);
        TiffShortTest.assertEquals((long)2L, (long)stream.length());
        stream.seek(0L);
        TiffShortTest.assertEquals((short)-1, (short)stream.readShort());
    }

    public void testGetSizeInBytes() {
        TiffShort tiffShort = new TiffShort(234);
        TiffShortTest.assertEquals((int)2, (int)tiffShort.getSizeInBytes());
    }
}

