/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff.internal;

import java.io.ByteArrayOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.geotiff.internal.GeoTiffAscii;

public class GeoTiffAsciiTest
extends TestCase {
    public void testCreation() {
        new GeoTiffAscii(new String[]{"Alois und Sepp"});
    }

    public void testGetValue() throws Exception {
        GeoTiffAscii tiffAscii = new GeoTiffAscii(new String[]{"Alois und Sepp"});
        GeoTiffAsciiTest.assertEquals((String)"Alois und Sepp|\u0000", (String)tiffAscii.getValue());
    }

    public void testWrite() throws Exception {
        GeoTiffAscii tiffAscii = new GeoTiffAscii(new String[]{"Alois und Sepp"});
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(os);
        tiffAscii.write((ImageOutputStream)ios);
        ios.flush();
        GeoTiffAsciiTest.assertEquals((String)"Alois und Sepp|\u0000", (String)os.toString());
    }

    public void testGetSizeInBytes() {
        String value = "Hedi und Fredi";
        GeoTiffAscii geoTiffAscii = new GeoTiffAscii(new String[]{"Hedi und Fredi"});
        GeoTiffAsciiTest.assertEquals((int)("Hedi und Fredi".length() + 2), (int)geoTiffAscii.getSizeInBytes());
    }
}

