/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.esa.beam.dataio.geotiff.GeoTiffProductWriterPlugIn;
import org.esa.beam.util.io.BeamFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoTiffProductWriterPlugInTest {
    private GeoTiffProductWriterPlugIn plugIn;

    @Before
    public void setup() {
        this.plugIn = new GeoTiffProductWriterPlugIn();
    }

    @Test
    public void testFileExtensions() {
        String[] fileExtensions = this.plugIn.getDefaultFileExtensions();
        Assert.assertNotNull((Object)fileExtensions);
        List<String> extensionList = Arrays.asList(fileExtensions);
        Assert.assertEquals((long)2L, (long)extensionList.size());
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".tif"));
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".tiff"));
    }

    @Test
    public void testFormatNames() {
        String[] formatNames = this.plugIn.getFormatNames();
        Assert.assertNotNull((Object)formatNames);
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"GeoTIFF", (Object)formatNames[0]);
    }

    @Test
    public void testOutputTypes() {
        Class[] classes = this.plugIn.getOutputTypes();
        Assert.assertNotNull((Object)classes);
        Assert.assertEquals((long)2L, (long)classes.length);
        List<Class> list = Arrays.asList(classes);
        Assert.assertEquals((Object)true, (Object)list.contains(File.class));
        Assert.assertEquals((Object)true, (Object)list.contains(String.class));
    }

    @Test
    public void testProductFileFilter() {
        BeamFileFilter beamFileFilter = this.plugIn.getProductFileFilter();
        Assert.assertNotNull((Object)beamFileFilter);
        Assert.assertArrayEquals((Object[])this.plugIn.getDefaultFileExtensions(), (Object[])beamFileFilter.getExtensions());
        Assert.assertEquals((Object)this.plugIn.getFormatNames()[0], (Object)beamFileFilter.getFormatName());
        Assert.assertEquals((Object)true, (Object)beamFileFilter.getDescription().contains(this.plugIn.getDescription(Locale.getDefault())));
    }
}

