/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.beam.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.esa.beam.dataio.geotiff.GeoTiffProductWriter;
import org.esa.beam.dataio.geotiff.GeoTiffProductWriterPlugIn;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.maptransf.MapInfo;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.UTM;
import org.esa.beam.util.io.BeamFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoTiffProductReaderPlugInTest {
    private GeoTiffProductReaderPlugIn plugIn;

    @Before
    public void setup() {
        this.plugIn = new GeoTiffProductReaderPlugIn();
    }

    @Test
    public void testDecodeQualificationForTIFFWithoutGeoInformation() throws IOException {
        Product product = new Product("p", "t", 20, 10);
        Band band = product.addBand("band1", 10);
        band.ensureRasterData();
        ImageInputStream inputStream = GeoTiffProductReaderPlugInTest.writeToInputStream(product);
        DecodeQualification decodeQualification = GeoTiffProductReaderPlugIn.getDecodeQualificationImpl((ImageInputStream)inputStream);
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)decodeQualification);
    }

    @Test
    public void testDecodeQualificationForTIFFWithGeoInformation() throws IOException {
        Product product = new Product("p", "t", 20, 10);
        Band band = product.addBand("band1", 10);
        band.ensureRasterData();
        MapInfo mapInfo = new MapInfo((MapProjection)UTM.createProjection((int)26, (boolean)true), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, Datum.WGS_84);
        mapInfo.setSceneWidth(product.getSceneRasterWidth());
        mapInfo.setSceneHeight(product.getSceneRasterHeight());
        product.setGeoCoding((GeoCoding)new MapGeoCoding(mapInfo));
        ImageInputStream inputStream = GeoTiffProductReaderPlugInTest.writeToInputStream(product);
        DecodeQualification decodeQualification = GeoTiffProductReaderPlugIn.getDecodeQualificationImpl((ImageInputStream)inputStream);
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)decodeQualification);
    }

    @Test
    public void testFileExtensions() {
        String[] fileExtensions = this.plugIn.getDefaultFileExtensions();
        Assert.assertNotNull((Object)fileExtensions);
        List<String> extensionList = Arrays.asList(fileExtensions);
        Assert.assertEquals((long)2L, (long)extensionList.size());
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".tif"));
        Assert.assertEquals((Object)true, (Object)extensionList.contains(".tiff"));
    }

    @Test
    public void testFormatNames() {
        String[] formatNames = this.plugIn.getFormatNames();
        Assert.assertNotNull((Object)formatNames);
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"GeoTIFF", (Object)formatNames[0]);
    }

    @Test
    public void testInputTypes() {
        Class[] classes = this.plugIn.getInputTypes();
        Assert.assertNotNull((Object)classes);
        Assert.assertEquals((long)3L, (long)classes.length);
        List<Class> list = Arrays.asList(classes);
        Assert.assertEquals((Object)true, (Object)list.contains(File.class));
        Assert.assertEquals((Object)true, (Object)list.contains(String.class));
        Assert.assertEquals((Object)true, (Object)list.contains(InputStream.class));
    }

    @Test
    public void testProductFileFilter() {
        BeamFileFilter beamFileFilter = this.plugIn.getProductFileFilter();
        Assert.assertNotNull((Object)beamFileFilter);
        Assert.assertArrayEquals((Object[])this.plugIn.getDefaultFileExtensions(), (Object[])beamFileFilter.getExtensions());
        Assert.assertEquals((Object)this.plugIn.getFormatNames()[0], (Object)beamFileFilter.getFormatName());
        Assert.assertEquals((Object)true, (Object)beamFileFilter.getDescription().contains(this.plugIn.getDescription(Locale.getDefault())));
    }

    private static ImageInputStream writeToInputStream(Product product) throws IOException {
        Band[] bands;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream outputStream = new MemoryCacheImageOutputStream(byteStream);
        GeoTiffProductWriter writer = (GeoTiffProductWriter)new GeoTiffProductWriterPlugIn().createWriterInstance();
        product.setProductWriter((ProductWriter)writer);
        writer.writeGeoTIFFProduct((ImageOutputStream)outputStream, product);
        for (Band band : bands = product.getBands()) {
            band.writeRasterDataFully(ProgressMonitor.NULL);
        }
        outputStream.flush();
        return new MemoryCacheImageInputStream((InputStream)new ByteArraySeekableStream(byteStream.toByteArray()));
    }
}

