/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.beam.dataio.geotiff.GeoTiffBandWriter;
import org.esa.beam.dataio.geotiff.internal.TiffDirectoryEntry;
import org.esa.beam.dataio.geotiff.internal.TiffHeader;
import org.esa.beam.dataio.geotiff.internal.TiffIFD;
import org.esa.beam.dataio.geotiff.internal.TiffLong;
import org.esa.beam.dataio.geotiff.internal.TiffTag;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;

public class GeoTiffBandWriterTest
extends TestCase {
    private static final int _WIDTH = 20;
    private static final int _HEIGHT = 35;
    private MemoryCacheImageOutputStream _ios;
    private Product _product;

    protected void setUp() throws Exception {
        this._ios = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        this._product = new Product("name", "type", 20, 35);
    }

    public void testCreation() {
        this._product.addBand("b1", 22);
        TiffIFD ifd = new TiffIFD(this._product);
        new GeoTiffBandWriter(ifd, (ImageOutputStream)this._ios, this._product);
    }

    public void testWriteBandRasterData_3DifferentTypedBands() throws IOException {
        int j;
        int[] startValues = new int[]{0, 30, 100};
        this._product.addBand("b1", 22);
        this._product.addBand("b2", 21);
        this._product.addBand("b3", 22);
        ProductData data1 = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), startValues[0]);
        ProductData data2 = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b2"), startValues[1]);
        ProductData data3 = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b3"), startValues[2]);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data1, ProgressMonitor.NULL);
        bandWriter.writeBandRasterData(this._product.getBand("b2"), 0, 0, 20, 35, data2, ProgressMonitor.NULL);
        bandWriter.writeBandRasterData(this._product.getBand("b3"), 0, 0, 20, 35, data3, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (j = 0; j < 700; ++j) {
            GeoTiffBandWriterTest.assertEquals((String)("band at [0] - index at [" + j + "]"), (long)(startValues[0] + j), (long)this._ios.readUnsignedInt());
        }
        this._ios.seek(offsets[1].getValue());
        for (j = 0; j < 700; ++j) {
            GeoTiffBandWriterTest.assertEquals((String)("band at [1] - index at [" + j + "]"), (long)(startValues[1] + j), (long)this._ios.readUnsignedInt());
        }
        this._ios.seek(offsets[2].getValue());
        for (j = 0; j < 700; ++j) {
            GeoTiffBandWriterTest.assertEquals((String)("band at [2] - index at [" + j + "]"), (long)(startValues[2] + j), (long)this._ios.readUnsignedInt());
        }
    }

    public void testWriteBandRasterData_WithUINT8() throws IOException {
        this._product.addBand("b1", 20);
        boolean startValue = true;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] stripOffsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(stripOffsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            int expValue = 1 + j & 0xFF;
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (int)expValue, (int)this._ios.readUnsignedByte());
        }
    }

    public void testWriteBandRasterData_WithUINT16() throws IOException {
        this._product.addBand("b1", 21);
        boolean startValue = true;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            int expValue = 1 + j & 0xFFFF;
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (int)expValue, (int)this._ios.readUnsignedShort());
        }
    }

    public void testWriteBandRasterData_WithUINT32() throws IOException {
        this._product.addBand("b1", 22);
        boolean startValue = true;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            long expValue = 1 + j;
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (long)expValue, (long)this._ios.readUnsignedInt());
        }
    }

    public void testWriteBandRasterData_WithINT8() throws IOException {
        this._product.addBand("b1", 10);
        boolean startValue = true;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            byte expValue = (byte)(1 + j);
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (byte)expValue, (byte)this._ios.readByte());
        }
    }

    public void testWriteBandRasterData_WithINT16() throws IOException {
        this._product.addBand("b1", 11);
        boolean startValue = true;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            short expValue = (short)(1 + j);
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (short)expValue, (short)this._ios.readShort());
        }
    }

    public void testWriteBandRasterData_WithINT32() throws IOException {
        this._product.addBand("b1", 12);
        boolean startValue = true;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            int expValue = 1 + j;
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (int)expValue, (int)this._ios.readInt());
        }
    }

    public void testWriteBandRasterData_WithFLOAT32() throws IOException {
        this._product.addBand("b1", 30);
        float startValue = 1.5f;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1.5f);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            float expValue = 1.5f + (float)j;
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (double)expValue, (double)this._ios.readFloat(), (double)1.0E-6);
        }
    }

    public void testWriteBandRasterData_WithFLOAT64() throws IOException {
        this._product.addBand("b1", 31);
        double startValue = 1.5;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1.5);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            float expValue = (float)(1.5 + (double)j);
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (double)expValue, (double)this._ios.readFloat(), (double)1.0E-6);
        }
    }

    public void testWriteBandRasterData_INT16() throws IOException {
        this._product.addBand("b1", 11);
        float scalingFactor = 1.2f;
        this._product.getBand("b1").setScalingFactor((double)1.2f);
        boolean startValue = true;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (double)(1 + j), (double)this._ios.readChar(), (double)1.0E-6);
        }
    }

    public void testWriteBandRasterData_WithOutHeader() throws IOException {
        ProductData data = ProductData.createInstance((int)22, (int)700);
        Band band = new Band("b1", 22, 20, 35);
        this._product.addBand(band);
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(new TiffIFD(this._product), (ImageOutputStream)this._ios, this._product);
        bandWriter.writeBandRasterData(band, 0, 0, 20, 35, data, ProgressMonitor.NULL);
        long expSize = 2800L;
        GeoTiffBandWriterTest.assertEquals((long)2800L, (long)this._ios.length());
    }

    public void testWriteBandRasterData_WithBandNotInProduct() throws IOException {
        this._product.addBand("b1", 11);
        this._product.addBand("b2", 11);
        boolean startValue = true;
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 1);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        Band bandNotInProd = new Band("notInProduct", 11, 10, 15);
        ProductData dataNotInProd = GeoTiffBandWriterTest.createProductDataForBand(bandNotInProd, 1);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
        try {
            bandWriter.writeBandRasterData(bandNotInProd, 0, 0, 10, 15, dataNotInProd, ProgressMonitor.NULL);
            GeoTiffBandWriterTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            GeoTiffBandWriterTest.assertTrue((expected.getMessage().indexOf("band") != -1 ? 1 : 0) != 0);
        }
        catch (Exception notExpected) {
            GeoTiffBandWriterTest.fail((String)("IllegalArgumentException expected, but was " + notExpected.getClass().getName()));
        }
    }

    public void testWriteBandRasterData_InParts() throws IOException {
        int startValue = 12;
        this._product.addBand("b1", 22);
        GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 12);
        Rectangle region1 = new Rectangle(0, 15, 10, 10);
        Rectangle region2 = new Rectangle(0, 0, 10, 15);
        Rectangle region3 = new Rectangle(10, 15, 10, 10);
        Rectangle region4 = new Rectangle(10, 0, 10, 15);
        Rectangle region5 = new Rectangle(0, 25, 20, 10);
        ProductData data1 = GeoTiffBandWriterTest.createProductDataPartAsUINT32(this._product.getBand("b1"), region1);
        ProductData data2 = GeoTiffBandWriterTest.createProductDataPartAsUINT32(this._product.getBand("b1"), region2);
        ProductData data3 = GeoTiffBandWriterTest.createProductDataPartAsUINT32(this._product.getBand("b1"), region3);
        ProductData data4 = GeoTiffBandWriterTest.createProductDataPartAsUINT32(this._product.getBand("b1"), region4);
        ProductData data5 = GeoTiffBandWriterTest.createProductDataPartAsUINT32(this._product.getBand("b1"), region5);
        TiffHeader tiffHeader = new TiffHeader(new Product[]{this._product});
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), (ImageOutputStream)this._ios, this._product);
        tiffHeader.write((ImageOutputStream)this._ios);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 15, 10, 10, data1, ProgressMonitor.NULL);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 10, 15, data2, ProgressMonitor.NULL);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 10, 15, 10, 10, data3, ProgressMonitor.NULL);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 10, 0, 10, 15, data4, ProgressMonitor.NULL);
        bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 25, 20, 10, data5, ProgressMonitor.NULL);
        TiffIFD ifd = tiffHeader.getIfdAt(0);
        int firstIFDOffset = 10;
        long expSize = ifd.getRequiredEntireSize() + 10L;
        TiffIFD tiffIFD = tiffHeader.getIfdAt(0);
        TiffDirectoryEntry entry = tiffIFD.getEntry(TiffTag.STRIP_OFFSETS);
        TiffLong[] offsets = (TiffLong[])entry.getValues();
        GeoTiffBandWriterTest.assertEquals((long)expSize, (long)this._ios.length());
        this._ios.seek(offsets[0].getValue());
        for (int j = 0; j < 700; ++j) {
            GeoTiffBandWriterTest.assertEquals((String)("index at [" + j + "]"), (int)(12 + j), (int)this._ios.readInt());
        }
    }

    public void testWriteBandRasterData_ThrowsIOExceptionWhenWriting() {
        ProductData data = ProductData.createInstance((int)22, (int)700);
        Band band = new Band("b1", 22, 20, 35);
        this._product.addBand(band);
        WriteIOExceptionImageOutputStream exceptionStream = new WriteIOExceptionImageOutputStream(new ByteArrayOutputStream());
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(new TiffIFD(this._product), (ImageOutputStream)exceptionStream, this._product);
        try {
            bandWriter.writeBandRasterData(band, 0, 0, 20, 35, data, ProgressMonitor.NULL);
            GeoTiffBandWriterTest.fail((String)"IOException expected");
        }
        catch (IOException expected) {
            GeoTiffBandWriterTest.assertEquals((String)expected.getMessage(), (String)"IOException write");
        }
        catch (Exception notExpected) {
            GeoTiffBandWriterTest.fail((String)("IOException expected, but was" + notExpected.getClass().getName()));
        }
    }

    public void testWriteBandRasterData_ThrowsIOExceptionWhenSeeking() {
        ProductData data = ProductData.createInstance((int)22, (int)700);
        Band band = new Band("b1", 22, 20, 35);
        this._product.addBand(band);
        SeekIOExceptionImageOutputStream exceptionStream = new SeekIOExceptionImageOutputStream(new ByteArrayOutputStream());
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(new TiffIFD(this._product), (ImageOutputStream)exceptionStream, this._product);
        try {
            bandWriter.writeBandRasterData(band, 0, 0, 20, 35, data, ProgressMonitor.NULL);
            GeoTiffBandWriterTest.fail((String)"IOException expected");
        }
        catch (IOException expected) {
            GeoTiffBandWriterTest.assertEquals((String)expected.getMessage(), (String)"IOException seek");
        }
        catch (Exception notExpected) {
            GeoTiffBandWriterTest.fail((String)("IOException expected, but was" + notExpected.getClass().getName()));
        }
    }

    public void testDispose() throws Exception {
        this._product.addBand("b1", 21);
        ProductData data = GeoTiffBandWriterTest.createProductDataForBand(this._product.getBand("b1"), 0);
        GeoTiffBandWriter bandWriter = new GeoTiffBandWriter(new TiffIFD(this._product), (ImageOutputStream)this._ios, this._product);
        bandWriter.dispose();
        try {
            bandWriter.writeBandRasterData(this._product.getBand("b1"), 0, 0, 20, 35, data, ProgressMonitor.NULL);
            GeoTiffBandWriterTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException expected) {
        }
        catch (Exception notExpected) {
            GeoTiffBandWriterTest.fail((String)("NullPointerException expected, but was " + notExpected.getClass().getName()));
        }
    }

    private static ProductData createProductDataPartAsUINT32(Band band, Rectangle region) {
        int[] intData = null;
        intData = band.getPixels((int)region.getX(), (int)region.getY(), (int)region.getWidth(), (int)region.getHeight(), intData, ProgressMonitor.NULL);
        ProductData data = ProductData.createInstance((int)22, (int)intData.length);
        data.setElems((Object)intData);
        return data;
    }

    private static ProductData createProductDataForBand(Band band, int start) {
        ProductData data = band.createCompatibleRasterData();
        for (int i = 0; i < band.getSceneRasterWidth() * band.getSceneRasterHeight(); ++i) {
            data.setElemIntAt(i, start + i);
        }
        band.setData(data);
        return data;
    }

    private static ProductData createProductDataForBand(Band band, float start) {
        ProductData data = band.createCompatibleRasterData();
        for (int i = 0; i < band.getSceneRasterWidth() * band.getSceneRasterHeight(); ++i) {
            data.setElemFloatAt(i, start + (float)i);
        }
        band.setData(data);
        return data;
    }

    private static ProductData createProductDataForBand(Band band, double start) {
        ProductData data = band.createCompatibleRasterData();
        for (int i = 0; i < band.getSceneRasterWidth() * band.getSceneRasterHeight(); ++i) {
            data.setElemDoubleAt(i, start + (double)i);
        }
        band.setData(data);
        return data;
    }

    private static class SeekIOExceptionImageOutputStream
    extends MemoryCacheImageOutputStream {
        public SeekIOExceptionImageOutputStream(OutputStream outStream) {
            super(outStream);
        }

        @Override
        public void seek(long pos) throws IOException {
            throw new IOException("IOException seek");
        }
    }

    private static class WriteIOExceptionImageOutputStream
    extends MemoryCacheImageOutputStream {
        public WriteIOExceptionImageOutputStream(OutputStream outStream) {
            super(outStream);
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("IOException write");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            throw new IOException("IOException write");
        }
    }
}

