/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import java.io.File;
import java.net.URL;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.geotiff.GeoTiffProductReader;
import org.esa.beam.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.junit.Assert;
import org.junit.Test;

public class GeoCodingTest {
    @Test
    public void testSmallImageNearGreenwichMeridian() throws Exception {
        URL resource = this.getClass().getResource("nearGreenwichMeridian.tif");
        String filePath = resource.getFile();
        GeoTiffProductReader reader = new GeoTiffProductReader((ProductReaderPlugIn)new GeoTiffProductReaderPlugIn());
        Product product = reader.readGeoTIFFProduct((ImageInputStream)new FileCacheImageInputStream(resource.openStream(), null), new File(filePath));
        GeoCoding geoCoding = product.getGeoCoding();
        GeoPos ul = geoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
        Assert.assertEquals((double)1.92584, (double)ul.lon, (double)1.0E-5);
        Assert.assertEquals((double)48.28314, (double)ul.lat, (double)1.0E-5);
        GeoPos lr = geoCoding.getGeoPos(new PixelPos(49.0f, 49.0f), null);
        Assert.assertEquals((double)2.03596, (double)lr.lon, (double)1.0E-5);
        Assert.assertEquals((double)48.17303, (double)lr.lat, (double)1.0E-5);
    }
}

