/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.envisat.EnvisatConstants;
import org.esa.snap.dataio.envisat.EnvisatProductReader;
import org.esa.snap.dataio.envisat.ProductFile;

public class EnvisatProductReaderPlugIn
implements ProductReaderPlugIn {
    public String[] getFormatNames() {
        return new String[]{"ENVISAT"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".N1", ".E1", ".E2", ".zip", ".gz"};
    }

    public String getDescription(Locale name) {
        return "ENVISAT MERIS, AATSR, ASAR and ERS1/2 SAR products";
    }

    public DecodeQualification getDecodeQualification(Object input) {
        if (input instanceof String) {
            if (ProductFile.getProductType(new File((String)input)) != null) {
                return DecodeQualification.INTENDED;
            }
        } else if (input instanceof File) {
            InputStream inputStream;
            File inputFile = (File)input;
            String fileName = inputFile.getName().toUpperCase();
            for (String ext : EnvisatConstants.EXTENSIONS) {
                if (!fileName.endsWith(ext) && !fileName.endsWith(ext + ".ZIP") && !fileName.endsWith(ext + ".GZ")) continue;
                return DecodeQualification.INTENDED;
            }
            if (!fileName.endsWith(".ZIP") && !fileName.endsWith(".GZ")) {
                return DecodeQualification.UNABLE;
            }
            if (ProductFile.getProductType(inputFile) != null) {
                return DecodeQualification.INTENDED;
            }
            try {
                inputStream = EnvisatProductReaderPlugIn.getInflaterInputStream(inputFile);
            }
            catch (IOException e) {
                return DecodeQualification.UNABLE;
            }
            MemoryCacheImageInputStream dataInputStream = new MemoryCacheImageInputStream(inputStream);
            String productType = ProductFile.getProductType(dataInputStream);
            try {
                dataInputStream.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (productType != null) {
                return DecodeQualification.INTENDED;
            }
        } else if (input instanceof ImageInputStream && ProductFile.getProductType((ImageInputStream)input) != null) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class, ImageInputStream.class, ProductFile.class};
    }

    public ProductReader createReaderInstance() {
        return new EnvisatProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    static InputStream getInflaterInputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz") && !file.getName().endsWith(".tar.gz")) {
            try {
                return EnvisatProductReaderPlugIn.createGZIPInputStream(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return EnvisatProductReaderPlugIn.createZIPInputStream(file);
    }

    private static InputStream createZIPInputStream(File file) throws IOException {
        ZipFile productZip = new ZipFile(file, 1);
        if (productZip.size() != 1) {
            throw new IllegalFileFormatException("Illegal ZIP format, single file entry expected.");
        }
        Enumeration<? extends ZipEntry> entries = productZip.entries();
        ZipEntry zipEntry = entries.nextElement();
        if (zipEntry == null || zipEntry.isDirectory()) {
            throw new IllegalFileFormatException("Illegal ZIP format, single file entry expected.");
        }
        return productZip.getInputStream(zipEntry);
    }

    private static InputStream createGZIPInputStream(File file) throws IOException {
        return new GZIPInputStream(new FileInputStream(file));
    }

    private static void registerRGBProfiles() {
        RGBImageProfileManager manager = RGBImageProfileManager.getInstance();
        manager.addProfile(new RGBImageProfile("MERIS L1b - Tristimulus", new String[]{"log(1.0 + 0.35 * radiance_2 + 0.60 * radiance_5 + radiance_6 + 0.13 * radiance_7)", "log(1.0 + 0.21 * radiance_3 + 0.50 * radiance_4 + radiance_5 + 0.38 * radiance_6)", "log(1.0 + 0.21 * radiance_1 + 1.75 * radiance_2 + 0.47 * radiance_3 + 0.16 * radiance_4)"}, new String[]{"MER_*_1*", "MER_*_1*", ""}));
        manager.addProfile(new RGBImageProfile("MERIS L2 - Tristimulus", new String[]{"log(0.05 + 0.35 * reflec_2 + 0.60 * reflec_5 + reflec_6 + 0.13 * reflec_7)", "log(0.05 + 0.21 * reflec_3 + 0.50 * reflec_4 + reflec_5 + 0.38 * reflec_6)", "log(0.05 + 0.21 * reflec_1 + 1.75 * reflec_2 + 0.47 * reflec_3 + 0.16 * reflec_4)"}, new String[]{"MER_*_2*", "MER_*_2*", ""}));
        manager.addProfile(new RGBImageProfile("MERIS L1b - 13,5,1", new String[]{"radiance_13", "radiance_5", "radiance_1"}));
        manager.addProfile(new RGBImageProfile("MERIS L1b - 13,4,2", new String[]{"radiance_13", "radiance_4", "radiance_2"}));
        manager.addProfile(new RGBImageProfile("MERIS L2 - 13,5,1", new String[]{"reflec_13", "reflec_5", "reflec_1"}));
        manager.addProfile(new RGBImageProfile("AATSR L1b - False colour", new String[]{"reflec_nadir_1600", "reflec_nadir_0870", "reflec_nadir_0670"}));
        manager.addProfile(new RGBImageProfile("AATSR L1b - False colour (logarithmic scale)", new String[]{"log(reflec_nadir_1600)", "log(reflec_nadir_0870)", "log(reflec_nadir_0670)"}));
        manager.addProfile(new RGBImageProfile("AATSR L1b - Nadir, Day", new String[]{"reflec_nadir_0870", "reflec_nadir_0670", "reflec_nadir_0550"}));
        manager.addProfile(new RGBImageProfile("AATSR L1b - Forward, Day", new String[]{"reflec_fward_0870", "reflec_fward_0670", "reflec_fward_0550"}));
    }

    static {
        EnvisatProductReaderPlugIn.registerRGBProfiles();
    }
}

