/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import org.esa.snap.core.gpf.Tile;

public final class TileIndex {
    private final int tileOffset;
    private final int tileStride;
    private final int tileMinX;
    private final int tileMinY;
    private int offset = 0;

    public TileIndex(Tile tile) {
        this.tileOffset = tile.getScanlineOffset();
        this.tileStride = tile.getScanlineStride();
        this.tileMinX = tile.getMinX();
        this.tileMinY = tile.getMinY();
    }

    public int calculateStride(int ty) {
        this.offset = this.tileMinX - ((ty - this.tileMinY) * this.tileStride + this.tileOffset);
        return this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getIndex(int tx) {
        return tx - this.offset;
    }
}

