/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public final class ReaderUtils {
    public static Band createVirtualPhaseBand(Product product, Band bandI, Band bandQ, String countStr) {
        String expression = "atan2(" + bandQ.getName() + ',' + bandI.getName() + ')';
        VirtualBand virtBand = new VirtualBand("Phase" + countStr, 30, bandI.getRasterWidth(), bandI.getRasterHeight(), expression);
        virtBand.setUnit("phase");
        virtBand.setDescription("Phase from complex data");
        virtBand.setNoDataValueUsed(true);
        virtBand.setNoDataValue(bandI.getNoDataValue());
        virtBand.setOwner((ProductNode)product);
        product.addBand((Band)virtBand);
        return virtBand;
    }

    private static String createName(String origName, String newPrefix) {
        int sepPos = origName.indexOf("_");
        if (sepPos < 0) {
            sepPos = origName.length();
        }
        return newPrefix + origName.substring(sepPos, origName.length());
    }

    public static Band createVirtualIntensityBand(Product product, Band bandI, Band bandQ, String suffix) {
        return ReaderUtils.createVirtualIntensityBand(product, bandI, bandQ, ReaderUtils.createName(bandI.getName(), "Intensity"), suffix);
    }

    public static Band createVirtualIntensityBand(Product product, Band bandI, Band bandQ, String bandName, String suffix) {
        String expression = bandI.getName() + " * " + bandI.getName() + " + " + bandQ.getName() + " * " + bandQ.getName();
        String name = bandName;
        if (!name.endsWith(suffix)) {
            name = name + suffix;
        }
        VirtualBand virtBand = new VirtualBand(name, 30, bandI.getRasterWidth(), bandI.getRasterHeight(), expression);
        virtBand.setUnit("intensity");
        virtBand.setDescription("Intensity from complex data");
        virtBand.setNoDataValueUsed(true);
        virtBand.setNoDataValue(bandI.getNoDataValue());
        virtBand.setOwner((ProductNode)product);
        product.addBand((Band)virtBand);
        if (bandI.getGeoCoding() != product.getSceneGeoCoding()) {
            virtBand.setGeoCoding(bandI.getGeoCoding());
        }
        product.setQuicklookBandName(virtBand.getName());
        return virtBand;
    }

    public static File getFileFromInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        return null;
    }

    public static void addGeoCoding(Product product, float[] latCorners, float[] lonCorners) {
        if (latCorners == null || lonCorners == null) {
            return;
        }
        int gridWidth = 10;
        int gridHeight = 10;
        float[] fineLatTiePoints = new float[100];
        ReaderUtils.createFineTiePointGrid(2, 2, 10, 10, latCorners, fineLatTiePoints);
        double subSamplingX = product.getSceneRasterWidth() / 9;
        double subSamplingY = product.getSceneRasterHeight() / 9;
        if (subSamplingX == 0.0 || subSamplingY == 0.0) {
            return;
        }
        TiePointGrid latGrid = new TiePointGrid("latitude", 10, 10, 0.5, 0.5, subSamplingX, subSamplingY, fineLatTiePoints);
        latGrid.setUnit("deg");
        float[] fineLonTiePoints = new float[100];
        ReaderUtils.createFineTiePointGrid(2, 2, 10, 10, lonCorners, fineLonTiePoints);
        TiePointGrid lonGrid = new TiePointGrid("longitude", 10, 10, 0.5, 0.5, subSamplingX, subSamplingY, fineLonTiePoints, 180);
        lonGrid.setUnit("deg");
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
    }

    public static void addGeoCoding(Product product, double[] latCorners, double[] lonCorners) {
        if (latCorners == null || lonCorners == null) {
            return;
        }
        int gridWidth = 10;
        int gridHeight = 10;
        float[] fineLatTiePoints = new float[100];
        ReaderUtils.createFineTiePointGrid(2, 2, 10, 10, latCorners, fineLatTiePoints);
        double subSamplingX = product.getSceneRasterWidth() / 9;
        double subSamplingY = product.getSceneRasterHeight() / 9;
        if (subSamplingX == 0.0 || subSamplingY == 0.0) {
            return;
        }
        TiePointGrid latGrid = new TiePointGrid("latitude", 10, 10, 0.5, 0.5, subSamplingX, subSamplingY, fineLatTiePoints);
        latGrid.setUnit("deg");
        float[] fineLonTiePoints = new float[100];
        ReaderUtils.createFineTiePointGrid(2, 2, 10, 10, lonCorners, fineLonTiePoints);
        TiePointGrid lonGrid = new TiePointGrid("longitude", 10, 10, 0.5, 0.5, subSamplingX, subSamplingY, fineLonTiePoints, 180);
        lonGrid.setUnit("deg");
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
    }

    public static void createFineTiePointGrid(int coarseGridWidth, int coarseGridHeight, int fineGridWidth, int fineGridHeight, float[] coarseTiePoints, float[] fineTiePoints) {
        if (coarseTiePoints == null || coarseTiePoints.length != coarseGridWidth * coarseGridHeight) {
            throw new IllegalArgumentException("coarse tie point array size does not match 'coarseGridWidth' x 'coarseGridHeight'");
        }
        if (fineTiePoints == null || fineTiePoints.length != fineGridWidth * fineGridHeight) {
            throw new IllegalArgumentException("fine tie point array size does not match 'fineGridWidth' x 'fineGridHeight'");
        }
        int k = 0;
        for (int r = 0; r < fineGridHeight; ++r) {
            double lambdaR = (double)r / (double)(fineGridHeight - 1);
            double betaR = lambdaR * (double)(coarseGridHeight - 1);
            int j0 = (int)betaR;
            int j1 = Math.min(j0 + 1, coarseGridHeight - 1);
            double wj = betaR - (double)j0;
            for (int c = 0; c < fineGridWidth; ++c) {
                double lambdaC = (double)c / (double)(fineGridWidth - 1);
                double betaC = lambdaC * (double)(coarseGridWidth - 1);
                int i0 = (int)betaC;
                int i1 = Math.min(i0 + 1, coarseGridWidth - 1);
                double wi = betaC - (double)i0;
                fineTiePoints[k++] = (float)MathUtils.interpolate2D((double)wi, (double)wj, (double)coarseTiePoints[i0 + j0 * coarseGridWidth], (double)coarseTiePoints[i1 + j0 * coarseGridWidth], (double)coarseTiePoints[i0 + j1 * coarseGridWidth], (double)coarseTiePoints[i1 + j1 * coarseGridWidth]);
            }
        }
    }

    public static void createFineTiePointGrid(int coarseGridWidth, int coarseGridHeight, int fineGridWidth, int fineGridHeight, double[] coarseTiePoints, float[] fineTiePoints) {
        if (coarseTiePoints == null || coarseTiePoints.length != coarseGridWidth * coarseGridHeight) {
            throw new IllegalArgumentException("coarse tie point array size does not match 'coarseGridWidth' x 'coarseGridHeight'");
        }
        if (fineTiePoints == null || fineTiePoints.length != fineGridWidth * fineGridHeight) {
            throw new IllegalArgumentException("fine tie point array size does not match 'fineGridWidth' x 'fineGridHeight'");
        }
        int k = 0;
        for (int r = 0; r < fineGridHeight; ++r) {
            double lambdaR = (double)r / (double)(fineGridHeight - 1);
            double betaR = lambdaR * (double)(coarseGridHeight - 1);
            int j0 = (int)betaR;
            int j1 = Math.min(j0 + 1, coarseGridHeight - 1);
            double wj = betaR - (double)j0;
            for (int c = 0; c < fineGridWidth; ++c) {
                double lambdaC = (double)c / (double)(fineGridWidth - 1);
                double betaC = lambdaC * (double)(coarseGridWidth - 1);
                int i0 = (int)betaC;
                int i1 = Math.min(i0 + 1, coarseGridWidth - 1);
                double wi = betaC - (double)i0;
                fineTiePoints[k++] = (float)MathUtils.interpolate2D((double)wi, (double)wj, (double)coarseTiePoints[i0 + j0 * coarseGridWidth], (double)coarseTiePoints[i1 + j0 * coarseGridWidth], (double)coarseTiePoints[i0 + j1 * coarseGridWidth], (double)coarseTiePoints[i1 + j1 * coarseGridWidth]);
            }
        }
    }

    public static double getLineTimeInterval(ProductData.UTC startUTC, ProductData.UTC endUTC, int sceneHeight) {
        if (startUTC == null || endUTC == null) {
            return 0.0;
        }
        double startTime = startUTC.getMJD() * 24.0 * 3600.0;
        double stopTime = endUTC.getMJD() * 24.0 * 3600.0;
        return (stopTime - startTime) / (double)(sceneHeight - 1);
    }

    public static void addMetadataProductSize(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        if (absRoot != null) {
            AbstractMetadata.setAttribute(absRoot, "total_size", ReaderUtils.getTotalSize(product));
        }
    }

    public static int getTotalSize(Product product) {
        return (int)((float)product.getRawStorageSize() / 1048576.0f);
    }

    public static void addMetadataIncidenceAngles(Product product) {
        TiePointGrid tpg = product.getTiePointGrid("incident_angle");
        if (tpg == null) {
            return;
        }
        int midAz = product.getSceneRasterHeight() / 2;
        double inc1 = tpg.getPixelDouble(0, midAz);
        double inc2 = tpg.getPixelDouble(product.getSceneRasterWidth(), midAz);
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        AbstractMetadata.setAttribute(absRoot, "incidence_near", Math.min(inc1, inc2));
        AbstractMetadata.setAttribute(absRoot, "incidence_far", Math.max(inc1, inc2));
    }

    public static ProductData.UTC getTime(MetadataElement elem, String tag, DateFormat timeFormat) {
        if (elem == null) {
            return AbstractMetadata.NO_METADATA_UTC;
        }
        String timeStr = ReaderUtils.createValidUTCString(elem.getAttributeString(tag, " ").toUpperCase(), new char[]{':', '.', '-'}, ' ').trim();
        return AbstractMetadata.parseUTC(timeStr, timeFormat);
    }

    private static String createValidUTCString(String name, char[] validChars, char replaceChar) {
        Guardian.assertNotNull((String)"name", (Object)name);
        char[] sortedValidChars = null;
        sortedValidChars = validChars == null ? new char[5] : (char[])validChars.clone();
        Arrays.sort(sortedValidChars);
        StringBuilder validName = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isDigit(ch)) {
                validName.append(ch);
                continue;
            }
            if (Arrays.binarySearch(sortedValidChars, ch) >= 0) {
                validName.append(ch);
                continue;
            }
            validName.append(replaceChar);
        }
        return validName.toString();
    }

    public static String findExtensionForFormat(String formatName) {
        ProductWriter writer = ProductIO.getProductWriter((String)formatName);
        return writer.getWriterPlugIn().getDefaultFileExtensions()[0];
    }
}

