/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.db;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.engine_utilities.db.DBQuery;
import org.esa.snap.engine_utilities.db.ProductDB;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

public class DBSearch {
    private static final double DEFAULT_MIN_TIME_DIFF = 1.0;
    private static final double DEFAULT_MAX_TIME_DIFF = 2.147483647E9;
    private static final int DEFAULT_MAX_SLAVES = 1;

    public static ProductEntry[] search(File srcFile) throws Exception {
        return DBSearch.search(CommonReaders.readProduct(srcFile));
    }

    public static ProductEntry[] search(Product srcProduct) throws Exception {
        return DBSearch.search(srcProduct, 1, 1.0, 2.147483647E9);
    }

    public static ProductEntry[] search(Product srcProduct, int maxSlaves, double minMJD, double maxMJD) throws Exception {
        GeoPos centerGeoPos = srcProduct.getSceneGeoCoding().getGeoPos(new PixelPos((double)(srcProduct.getSceneRasterWidth() / 2), (double)(srcProduct.getSceneRasterHeight() / 2)), null);
        return DBSearch.findCCDPairs(ProductDB.instance(), srcProduct, centerGeoPos, maxSlaves, minMJD, maxMJD, false);
    }

    private static ProductEntry[] findCCDPairs(ProductDB db, Product srcProduct, GeoPos centerGeoPos, int maxSlaves, double minMJD, double maxMJD, boolean anyDate) throws SQLException {
        ProductEntry masterEntry = new ProductEntry(srcProduct);
        DBQuery dbQuery = new DBQuery();
        dbQuery.setFreeQuery("PRODUCT <> '" + masterEntry.getName() + '\'');
        dbQuery.setSelectionRect(new GeoPos[]{centerGeoPos, centerGeoPos, centerGeoPos, centerGeoPos});
        dbQuery.setReturnAllIfNoIntersection(false);
        dbQuery.setSelectedPass(masterEntry.getPass());
        dbQuery.setSelectedPolarization(OperatorUtils.getPolarizationType(AbstractMetadata.getAbstractedMetadata(srcProduct)));
        dbQuery.setStartEndDate(null, masterEntry.getFirstLineTime().getAsCalendar());
        dbQuery.setSelectedProductTypes(new String[]{masterEntry.getProductType()});
        ProductEntry[] entries = dbQuery.queryDatabase(db);
        if (entries.length == 0) {
            return entries;
        }
        return DBSearch.getClosestDatePairs(entries, masterEntry, dbQuery, minMJD, maxMJD, maxSlaves, anyDate);
    }

    private static ProductEntry[] getClosestDatePairs(ProductEntry[] entries, ProductEntry master, DBQuery dbQuery, double minMJD, double maxMJD, int maxSlaves, boolean anyDate) {
        double endTime;
        double masterTime;
        double cutoffTime = masterTime = master.getFirstLineTime().getMJD();
        if (dbQuery != null && dbQuery.getEndDate() != null && (endTime = ProductData.UTC.create((Date)dbQuery.getEndDate().getTime(), (long)0L).getMJD()) > masterTime) {
            cutoffTime = endTime;
        }
        ArrayList resultList = new ArrayList(maxSlaves);
        HashMap<Double, ProductEntry> timesMap = new HashMap<Double, ProductEntry>();
        ArrayList<Double> diffList = new ArrayList<Double>();
        for (ProductEntry entry : entries) {
            double diff;
            double entryTime = entry.getFirstLineTime().getMJD();
            if (!anyDate && !(entryTime < cutoffTime) || !((diff = masterTime - entryTime) > 0.0) || minMJD != 0.0 && !(diff >= minMJD) || maxMJD != 0.0 && !(diff <= maxMJD)) continue;
            timesMap.put(diff, entry);
            diffList.add(diff);
        }
        Collections.sort(diffList);
        for (Double diff : diffList) {
            resultList.add(timesMap.get(diff));
            if (resultList.size() < maxSlaves) continue;
            break;
        }
        return resultList.toArray(new ProductEntry[resultList.size()]);
    }
}

