/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;

public final class AbstractMetadata {
    private static final String METADATA_VERSION = "6.0";
    public static final int NO_METADATA = 99999;
    public static final short NO_METADATA_BYTE = 0;
    public static final String NO_METADATA_STRING = "-";
    public static final ProductData.UTC NO_METADATA_UTC = new ProductData.UTC(0.0);
    public static final String abstracted_metadata_version = "metadata_version";
    public static final String ABSTRACT_METADATA_ROOT = "Abstracted_Metadata";
    private static final String ORIGINAL_PRODUCT_METADATA = "Original_Product_Metadata";
    public static final String BAND_PREFIX = "Band_";
    public static final String SLAVE_METADATA_ROOT = "Slave_Metadata";
    public static final String MASTER_BANDS = "Master_bands";
    public static final String SLAVE_BANDS = "Slave_bands";
    public static final String PRODUCT = "PRODUCT";
    public static final String PRODUCT_TYPE = "PRODUCT_TYPE";
    public static final String SPH_DESCRIPTOR = "SPH_DESCRIPTOR";
    public static final String PATH = "PATH";
    public static final String MISSION = "MISSION";
    public static final String ACQUISITION_MODE = "ACQUISITION_MODE";
    public static final String antenna_pointing = "antenna_pointing";
    public static final String BEAMS = "BEAMS";
    public static final String annotation = "annotation";
    public static final String band_names = "band_names";
    public static final String SWATH = "SWATH";
    public static final String swath = "swath";
    public static final String PROC_TIME = "PROC_TIME";
    public static final String ProcessingSystemIdentifier = "Processing_system_identifier";
    public static final String CYCLE = "orbit_cycle";
    public static final String REL_ORBIT = "REL_ORBIT";
    public static final String ABS_ORBIT = "ABS_ORBIT";
    public static final String STATE_VECTOR_TIME = "STATE_VECTOR_TIME";
    public static final String VECTOR_SOURCE = "VECTOR_SOURCE";
    public static final String slice_num = "slice_num";
    public static final String data_take_id = "data_take_id";
    public static final String first_line_time = "first_line_time";
    public static final String last_line_time = "last_line_time";
    public static final String first_near_lat = "first_near_lat";
    public static final String first_near_long = "first_near_long";
    public static final String first_far_lat = "first_far_lat";
    public static final String first_far_long = "first_far_long";
    public static final String last_near_lat = "last_near_lat";
    public static final String last_near_long = "last_near_long";
    public static final String last_far_lat = "last_far_lat";
    public static final String last_far_long = "last_far_long";
    public static final String PASS = "PASS";
    public static final String SAMPLE_TYPE = "SAMPLE_TYPE";
    public static final String sample_type = "sample_type";
    public static final String incidence_near = "incidence_near";
    public static final String incidence_far = "incidence_far";
    public static final String mds1_tx_rx_polar = "mds1_tx_rx_polar";
    public static final String mds2_tx_rx_polar = "mds2_tx_rx_polar";
    public static final String mds3_tx_rx_polar = "mds3_tx_rx_polar";
    public static final String mds4_tx_rx_polar = "mds4_tx_rx_polar";
    public static final String polarization = "polarization";
    public static final String polsarData = "polsar_data";
    public static final String[] polarTags = new String[]{"mds1_tx_rx_polar", "mds2_tx_rx_polar", "mds3_tx_rx_polar", "mds4_tx_rx_polar"};
    public static final String algorithm = "algorithm";
    public static final String azimuth_looks = "azimuth_looks";
    public static final String range_looks = "range_looks";
    public static final String range_spacing = "range_spacing";
    public static final String azimuth_spacing = "azimuth_spacing";
    public static final String pulse_repetition_frequency = "pulse_repetition_frequency";
    public static final String radar_frequency = "radar_frequency";
    public static final String line_time_interval = "line_time_interval";
    public static final String TOT_SIZE = "total_size";
    public static final String num_output_lines = "num_output_lines";
    public static final String num_samples_per_line = "num_samples_per_line";
    public static final String subset_offset_x = "subset_offset_x";
    public static final String subset_offset_y = "subset_offset_y";
    public static final String srgr_flag = "srgr_flag";
    public static final String map_projection = "map_projection";
    public static final String ant_elev_corr_flag = "ant_elev_corr_flag";
    public static final String range_spread_comp_flag = "range_spread_comp_flag";
    public static final String inc_angle_comp_flag = "inc_angle_comp_flag";
    public static final String abs_calibration_flag = "abs_calibration_flag";
    public static final String calibration_factor = "calibration_factor";
    public static final String chirp_power = "chirp_power";
    public static final String replica_power_corr_flag = "replica_power_corr_flag";
    public static final String range_sampling_rate = "range_sampling_rate";
    public static final String avg_scene_height = "avg_scene_height";
    public static final String multilook_flag = "multilook_flag";
    public static final String ref_inc_angle = "ref_inc_angle";
    public static final String ref_slant_range = "ref_slant_range";
    public static final String ref_slant_range_exp = "ref_slant_range_exp";
    public static final String rescaling_factor = "rescaling_factor";
    public static final String coregistered_stack = "coregistered_stack";
    public static final String bistatic_stack = "bistatic_stack";
    public static final String external_calibration_file = "external_calibration_file";
    public static final String orbit_state_vector_file = "orbit_state_vector_file";
    public static final String target_report_file = "target_report_file";
    public static final String wind_field_report_file = "wind_field_report_file";
    public static final String orbit_state_vectors = "Orbit_State_Vectors";
    public static final String orbit_vector = "orbit_vector";
    public static final String orbit_vector_time = "time";
    public static final String orbit_vector_x_pos = "x_pos";
    public static final String orbit_vector_y_pos = "y_pos";
    public static final String orbit_vector_z_pos = "z_pos";
    public static final String orbit_vector_x_vel = "x_vel";
    public static final String orbit_vector_y_vel = "y_vel";
    public static final String orbit_vector_z_vel = "z_vel";
    public static final String srgr_coefficients = "SRGR_Coefficients";
    public static final String srgr_coef_list = "srgr_coef_list";
    public static final String srgr_coef_time = "zero_doppler_time";
    public static final String ground_range_origin = "ground_range_origin";
    public static final String coefficient = "coefficient";
    public static final String srgr_coef = "srgr_coef";
    public static final String dop_coefficients = "Doppler_Centroid_Coefficients";
    public static final String dop_coef_list = "dop_coef_list";
    public static final String dop_coef_time = "zero_doppler_time";
    public static final String slant_range_time = "slant_range_time";
    public static final String dop_coef = "dop_coef";
    public static final String is_terrain_corrected = "is_terrain_corrected";
    public static final String DEM = "DEM";
    public static final String geo_ref_system = "geo_ref_system";
    public static final String lat_pixel_res = "lat_pixel_res";
    public static final String lon_pixel_res = "lon_pixel_res";
    public static final String slant_range_to_first_pixel = "slant_range_to_first_pixel";
    public static final String range_bandwidth = "range_bandwidth";
    public static final String azimuth_bandwidth = "azimuth_bandwidth";
    public static final String compact_mode = "compact_mode";

    public static MetadataElement addAbstractedMetadataHeader(MetadataElement root) {
        MetadataElement absRoot;
        if (root == null) {
            absRoot = new MetadataElement(ABSTRACT_METADATA_ROOT);
        } else {
            absRoot = root.getElement(ABSTRACT_METADATA_ROOT);
            if (absRoot == null) {
                absRoot = new MetadataElement(ABSTRACT_METADATA_ROOT);
                root.addElementAt(absRoot, 0);
            }
        }
        AbstractMetadata.addAbstractedAttribute(absRoot, PRODUCT, 41, "", "Product name");
        AbstractMetadata.addAbstractedAttribute(absRoot, PRODUCT_TYPE, 41, "", "Product type");
        AbstractMetadata.addAbstractedAttribute(absRoot, SPH_DESCRIPTOR, 41, "", "Description");
        AbstractMetadata.addAbstractedAttribute(absRoot, MISSION, 41, "", "Satellite mission");
        AbstractMetadata.addAbstractedAttribute(absRoot, ACQUISITION_MODE, 41, "", "Acquisition mode");
        AbstractMetadata.addAbstractedAttribute(absRoot, antenna_pointing, 41, "", "Right or left facing");
        AbstractMetadata.addAbstractedAttribute(absRoot, BEAMS, 41, "", "Beams used");
        AbstractMetadata.addAbstractedAttribute(absRoot, SWATH, 41, "", "Swath name");
        AbstractMetadata.addAbstractedAttribute(absRoot, PROC_TIME, 51, "utc", "Processed time");
        AbstractMetadata.addAbstractedAttribute(absRoot, ProcessingSystemIdentifier, 41, "", "Processing system identifier");
        AbstractMetadata.addAbstractedAttribute(absRoot, CYCLE, 12, "", "Cycle");
        AbstractMetadata.addAbstractedAttribute(absRoot, REL_ORBIT, 12, "", "Track");
        AbstractMetadata.addAbstractedAttribute(absRoot, ABS_ORBIT, 12, "", "Orbit");
        AbstractMetadata.addAbstractedAttribute(absRoot, STATE_VECTOR_TIME, 51, "utc", "Time of orbit state vector");
        AbstractMetadata.addAbstractedAttribute(absRoot, VECTOR_SOURCE, 41, "", "State vector source");
        AbstractMetadata.addAbstractedAttribute(absRoot, incidence_near, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, incidence_far, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, slice_num, 12, "", "Slice number");
        AbstractMetadata.addAbstractedAttribute(absRoot, data_take_id, 12, "", "Data take identifier");
        AbstractMetadata.addAbstractedAttribute(absRoot, first_line_time, 51, "utc", "First zero doppler azimuth time");
        AbstractMetadata.addAbstractedAttribute(absRoot, last_line_time, 51, "utc", "Last zero doppler azimuth time");
        AbstractMetadata.addAbstractedAttribute(absRoot, first_near_lat, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, first_near_long, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, first_far_lat, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, first_far_long, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, last_near_lat, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, last_near_long, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, last_far_lat, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, last_far_long, 31, "deg", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, PASS, 41, "", "ASCENDING or DESCENDING");
        AbstractMetadata.addAbstractedAttribute(absRoot, SAMPLE_TYPE, 41, "", "DETECTED or COMPLEX");
        AbstractMetadata.addAbstractedAttribute(absRoot, mds1_tx_rx_polar, 41, "", "Polarization");
        AbstractMetadata.addAbstractedAttribute(absRoot, mds2_tx_rx_polar, 41, "", "Polarization");
        AbstractMetadata.addAbstractedAttribute(absRoot, mds3_tx_rx_polar, 41, "", "Polarization");
        AbstractMetadata.addAbstractedAttribute(absRoot, mds4_tx_rx_polar, 41, "", "Polarization");
        AbstractMetadata.addAbstractedAttribute(absRoot, polsarData, 20, "flag", "Polarimetric Matrix");
        AbstractMetadata.addAbstractedAttribute(absRoot, algorithm, 41, "", "Processing algorithm");
        AbstractMetadata.addAbstractedAttribute(absRoot, azimuth_looks, 31, "", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, range_looks, 31, "", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, range_spacing, 31, "m", "Range sample spacing");
        AbstractMetadata.addAbstractedAttribute(absRoot, azimuth_spacing, 31, "m", "Azimuth sample spacing");
        AbstractMetadata.addAbstractedAttribute(absRoot, pulse_repetition_frequency, 31, "Hz", "PRF");
        AbstractMetadata.addAbstractedAttribute(absRoot, radar_frequency, 31, "MHz", "Radar frequency");
        AbstractMetadata.addAbstractedAttribute(absRoot, line_time_interval, 31, "s", "");
        AbstractMetadata.addAbstractedAttribute(absRoot, TOT_SIZE, 22, "MB", "Total product size");
        AbstractMetadata.addAbstractedAttribute(absRoot, num_output_lines, 22, "lines", "Raster height");
        AbstractMetadata.addAbstractedAttribute(absRoot, num_samples_per_line, 22, "samples", "Raster width");
        AbstractMetadata.addAbstractedAttribute(absRoot, subset_offset_x, 22, "samples", "X coordinate of UL corner of subset in original image");
        AbstractMetadata.addAbstractedAttribute(absRoot, subset_offset_y, 22, "samples", "Y coordinate of UL corner of subset in original image");
        AbstractMetadata.setAttribute(absRoot, subset_offset_x, 0);
        AbstractMetadata.setAttribute(absRoot, subset_offset_y, 0);
        AbstractMetadata.addAbstractedAttribute(absRoot, srgr_flag, 20, "flag", "SRGR applied");
        MetadataAttribute att = AbstractMetadata.addAbstractedAttribute(absRoot, avg_scene_height, 31, "m", "Average scene height ellipsoid");
        att.getData().setElemInt(0);
        AbstractMetadata.addAbstractedAttribute(absRoot, map_projection, 41, "", "Map projection applied");
        AbstractMetadata.addAbstractedAttribute(absRoot, is_terrain_corrected, 20, "flag", "orthorectification applied");
        AbstractMetadata.addAbstractedAttribute(absRoot, DEM, 41, "", "Digital Elevation Model used");
        AbstractMetadata.addAbstractedAttribute(absRoot, geo_ref_system, 41, "", "geographic reference system");
        AbstractMetadata.addAbstractedAttribute(absRoot, lat_pixel_res, 31, "deg", "pixel resolution in geocoded image");
        AbstractMetadata.addAbstractedAttribute(absRoot, lon_pixel_res, 31, "deg", "pixel resolution in geocoded image");
        AbstractMetadata.addAbstractedAttribute(absRoot, slant_range_to_first_pixel, 31, "m", "Slant range to 1st data sample");
        AbstractMetadata.addAbstractedAttribute(absRoot, ant_elev_corr_flag, 20, "flag", "Antenna elevation applied");
        AbstractMetadata.addAbstractedAttribute(absRoot, range_spread_comp_flag, 20, "flag", "range spread compensation applied");
        AbstractMetadata.addAbstractedAttribute(absRoot, replica_power_corr_flag, 20, "flag", "Replica pulse power correction applied");
        AbstractMetadata.addAbstractedAttribute(absRoot, abs_calibration_flag, 20, "flag", "Product calibrated");
        AbstractMetadata.addAbstractedAttribute(absRoot, calibration_factor, 31, "dB", "Calibration constant");
        AbstractMetadata.addAbstractedAttribute(absRoot, chirp_power, 31, "", "Chirp power");
        AbstractMetadata.addAbstractedAttribute(absRoot, inc_angle_comp_flag, 20, "flag", "incidence angle compensation applied");
        AbstractMetadata.addAbstractedAttribute(absRoot, ref_inc_angle, 31, "", "Reference incidence angle");
        AbstractMetadata.addAbstractedAttribute(absRoot, ref_slant_range, 31, "", "Reference slant range");
        AbstractMetadata.addAbstractedAttribute(absRoot, ref_slant_range_exp, 31, "", "Reference slant range exponent");
        AbstractMetadata.addAbstractedAttribute(absRoot, rescaling_factor, 31, "", "Rescaling factor");
        AbstractMetadata.addAbstractedAttribute(absRoot, range_sampling_rate, 31, "MHz", "Range Sampling Rate");
        AbstractMetadata.addAbstractedAttribute(absRoot, range_bandwidth, 31, "MHz", "Bandwidth total in range");
        AbstractMetadata.addAbstractedAttribute(absRoot, azimuth_bandwidth, 31, "Hz", "Bandwidth total in azimuth");
        AbstractMetadata.addAbstractedAttribute(absRoot, multilook_flag, 20, "flag", "Multilook applied");
        AbstractMetadata.addAbstractedAttribute(absRoot, coregistered_stack, 20, "flag", "Coregistration applied");
        AbstractMetadata.addAbstractedAttribute(absRoot, external_calibration_file, 41, "", "External calibration file used");
        AbstractMetadata.addAbstractedAttribute(absRoot, orbit_state_vector_file, 41, "", "Orbit file used");
        absRoot.addElement(new MetadataElement(orbit_state_vectors));
        absRoot.addElement(new MetadataElement(srgr_coefficients));
        absRoot.addElement(new MetadataElement(dop_coefficients));
        att = AbstractMetadata.addAbstractedAttribute(absRoot, abstracted_metadata_version, 41, "", "AbsMetadata version");
        att.getData().setElems((Object)METADATA_VERSION);
        return absRoot;
    }

    public static MetadataElement addBandAbstractedMetadata(MetadataElement absRoot, String name) {
        MetadataElement bandRoot = absRoot.getElement(name);
        if (bandRoot == null) {
            bandRoot = new MetadataElement(name);
            absRoot.addElement(bandRoot);
        }
        AbstractMetadata.addAbstractedAttribute(bandRoot, swath, 41, "", "Swath name");
        AbstractMetadata.addAbstractedAttribute(bandRoot, polarization, 41, "", "Polarization");
        AbstractMetadata.addAbstractedAttribute(bandRoot, annotation, 41, "", "metadata file");
        AbstractMetadata.addAbstractedAttribute(bandRoot, band_names, 41, "", "corresponding bands");
        AbstractMetadata.addAbstractedAttribute(bandRoot, first_line_time, 51, "utc", "First zero doppler azimuth time");
        AbstractMetadata.addAbstractedAttribute(bandRoot, last_line_time, 51, "utc", "Last zero doppler azimuth time");
        AbstractMetadata.addAbstractedAttribute(bandRoot, line_time_interval, 31, "s", "Time per line");
        AbstractMetadata.addAbstractedAttribute(bandRoot, num_output_lines, 22, "lines", "Raster height");
        AbstractMetadata.addAbstractedAttribute(bandRoot, num_samples_per_line, 22, "samples", "Raster width");
        AbstractMetadata.addAbstractedAttribute(bandRoot, sample_type, 41, "", "DETECTED or COMPLEX");
        AbstractMetadata.addAbstractedAttribute(bandRoot, calibration_factor, 31, "", "Calibration constant");
        return bandRoot;
    }

    public static void addBandToBandMap(MetadataElement bandAbsRoot, String name) {
        String bandNames = bandAbsRoot.getAttributeString(band_names);
        if (bandNames.equals(NO_METADATA_STRING)) {
            bandNames = "";
        }
        if (!bandNames.isEmpty()) {
            bandNames = bandNames + ' ';
        }
        bandNames = bandNames + name;
        bandAbsRoot.setAttributeString(band_names, bandNames);
    }

    public static MetadataElement getBandAbsMetadata(MetadataElement absRoot, Band band) {
        MetadataElement[] children;
        for (MetadataElement child : children = absRoot.getElements()) {
            String[] bandNameArray;
            if (!child.getName().startsWith(BAND_PREFIX)) continue;
            for (String bandName : bandNameArray = StringUtils.stringToArray((String)child.getAttributeString(band_names), (String)" ")) {
                if (!bandName.equals(band.getName())) continue;
                return child;
            }
        }
        return null;
    }

    public static MetadataElement[] getBandAbsMetadataList(MetadataElement absRoot) {
        MetadataElement[] children;
        ArrayList<MetadataElement> bandMetadataList = new ArrayList<MetadataElement>();
        for (MetadataElement child : children = absRoot.getElements()) {
            if (!child.getName().startsWith(BAND_PREFIX)) continue;
            bandMetadataList.add(child);
        }
        return bandMetadataList.toArray(new MetadataElement[bandMetadataList.size()]);
    }

    public static MetadataElement getOriginalProductMetadata(Product product) {
        MetadataElement root = product.getMetadataRoot();
        MetadataElement origMetadata = root.getElement(ORIGINAL_PRODUCT_METADATA);
        if (origMetadata == null) {
            return root;
        }
        return origMetadata;
    }

    public static MetadataElement addOriginalProductMetadata(MetadataElement root) {
        MetadataElement origMetadata = root.getElement(ORIGINAL_PRODUCT_METADATA);
        if (origMetadata == null) {
            origMetadata = new MetadataElement(ORIGINAL_PRODUCT_METADATA);
            root.addElement(origMetadata);
        }
        return origMetadata;
    }

    public static boolean isNoData(MetadataElement elem, String tag) {
        String val = elem.getAttributeString(tag, NO_METADATA_STRING).trim();
        return val.equals(NO_METADATA_STRING) || val.isEmpty();
    }

    public static MetadataAttribute addAbstractedAttribute(MetadataElement dest, String tag, int dataType, String unit, String desc) {
        MetadataAttribute attribute = new MetadataAttribute(tag, dataType, 1);
        if (dataType == 41) {
            attribute.getData().setElems((Object)NO_METADATA_STRING);
        } else if (dataType == 10 || dataType == 20) {
            attribute.getData().setElems((Object)new String[]{String.valueOf(0)});
        } else if (dataType != 51) {
            attribute.getData().setElems((Object)new String[]{String.valueOf(99999)});
        }
        attribute.setUnit(unit);
        attribute.setDescription(desc);
        attribute.setReadOnly(false);
        dest.addAttribute(attribute);
        return attribute;
    }

    public static void setAttribute(MetadataElement dest, String tag, String value) {
        if (dest == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib == null) {
            attrib = new MetadataAttribute(tag, 41);
            dest.addAttribute(attrib);
        }
        if (value == null || value.isEmpty()) {
            attrib.getData().setElems((Object)NO_METADATA_STRING);
        } else {
            attrib.getData().setElems((Object)value);
        }
    }

    public static void setAttribute(MetadataElement dest, String tag, ProductData.UTC value) {
        if (dest == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib != null && value != null) {
            attrib.getData().setElems((Object)value.getArray());
        } else {
            if (attrib == null) {
                System.out.println(tag + " not found in metadata");
            }
            if (value == null) {
                System.out.println(tag + " metadata value is null");
            }
        }
    }

    public static void setAttribute(MetadataElement dest, String tag, int value) {
        if (dest == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib == null) {
            System.out.println(tag + " not found in metadata");
        } else {
            attrib.getData().setElemInt(value);
        }
    }

    public static void setAttribute(MetadataElement dest, String tag, double value) {
        if (dest == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib != null) {
            attrib.getData().setElemDouble(value);
        } else {
            MetadataAttribute newAttrib = new MetadataAttribute(tag, 31);
            dest.addAttribute(newAttrib);
            newAttrib.getData().setElemDouble(value);
        }
    }

    public static void setAttribute(MetadataElement dest, String tag, Double value) {
        if (dest == null || value == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib != null) {
            attrib.getData().setElemDouble(value.doubleValue());
        } else {
            MetadataAttribute newAttrib = new MetadataAttribute(tag, 31);
            dest.addAttribute(newAttrib);
            newAttrib.getData().setElemDouble(value.doubleValue());
        }
    }

    public static ProductData.UTC parseUTC(String timeStr) {
        try {
            if (timeStr == null) {
                return NO_METADATA_UTC;
            }
            return ProductData.UTC.parse((String)timeStr);
        }
        catch (ParseException e) {
            try {
                int dotPos = timeStr.lastIndexOf(".");
                if (dotPos > 0) {
                    String fractionString = timeStr.substring(dotPos + 1, timeStr.length());
                    fractionString = fractionString.replaceAll(NO_METADATA_STRING, "");
                    String newTimeStr = timeStr.substring(0, dotPos) + fractionString;
                    return ProductData.UTC.parse((String)newTimeStr);
                }
            }
            catch (ParseException e2) {
                return NO_METADATA_UTC;
            }
            return NO_METADATA_UTC;
        }
    }

    public static ProductData.UTC parseUTC(String timeStr, DateFormat format) {
        try {
            int dotPos = timeStr.lastIndexOf(46);
            if (dotPos > 0) {
                String newTimeStr = timeStr.substring(0, Math.min(dotPos + 7, timeStr.length()));
                try {
                    return ProductData.UTC.parse((String)newTimeStr, (DateFormat)format);
                }
                catch (Throwable e) {
                    ProductData.UTC time = ProductData.UTC.parse((String)newTimeStr, (DateFormat)format);
                    return time;
                }
            }
            return ProductData.UTC.parse((String)timeStr, (DateFormat)format);
        }
        catch (Throwable e) {
            System.out.println("UTC parse error:" + timeStr + ":" + e.toString());
            return NO_METADATA_UTC;
        }
    }

    public static boolean getAttributeBoolean(MetadataElement elem, String tag) throws Exception {
        int val = elem.getAttributeInt(tag);
        if (val == 99999) {
            throw new Exception("Metadata " + tag + " has not been set");
        }
        return val != 0;
    }

    public static double getAttributeDouble(MetadataElement elem, String tag) throws Exception {
        double val = elem.getAttributeDouble(tag);
        if (val == 99999.0) {
            throw new Exception("Metadata " + tag + " has not been set");
        }
        return val;
    }

    public static int getAttributeInt(MetadataElement elem, String tag) throws Exception {
        int val = elem.getAttributeInt(tag);
        if (val == 99999) {
            throw new Exception("Metadata " + tag + " has not been set");
        }
        return val;
    }

    public static boolean hasAbstractedMetadata(Product sourceProduct) {
        MetadataElement root = sourceProduct.getMetadataRoot();
        if (root == null) {
            return false;
        }
        MetadataElement abstractedMetadata = root.getElement(ABSTRACT_METADATA_ROOT);
        return abstractedMetadata != null;
    }

    public static MetadataElement getAbstractedMetadata(Product sourceProduct) {
        MetadataElement root = sourceProduct.getMetadataRoot();
        if (root == null) {
            return null;
        }
        MetadataElement abstractedMetadata = root.getElement(ABSTRACT_METADATA_ROOT);
        if (abstractedMetadata == null && (abstractedMetadata = root.getElement("Abstracted Metadata")) == null) {
            abstractedMetadata = AbstractMetadata.addAbstractedMetadataHeader(root);
            AbstractMetadata.defaultToProduct(abstractedMetadata, sourceProduct);
        }
        AbstractMetadata.migrateToCurrentVersion(abstractedMetadata);
        AbstractMetadata.patchMissingMetadata(abstractedMetadata);
        return abstractedMetadata;
    }

    private static void defaultToProduct(MetadataElement abstractedMetadata, Product product) {
        AbstractMetadata.setAttribute(abstractedMetadata, PRODUCT, product.getName());
        AbstractMetadata.setAttribute(abstractedMetadata, PRODUCT_TYPE, product.getProductType());
        AbstractMetadata.setAttribute(abstractedMetadata, SPH_DESCRIPTOR, product.getDescription());
        AbstractMetadata.setAttribute(abstractedMetadata, num_output_lines, product.getSceneRasterHeight());
        AbstractMetadata.setAttribute(abstractedMetadata, num_samples_per_line, product.getSceneRasterWidth());
        AbstractMetadata.setAttribute(abstractedMetadata, first_line_time, product.getStartTime());
        AbstractMetadata.setAttribute(abstractedMetadata, last_line_time, product.getEndTime());
        if (product.getProductReader() != null && product.getProductReader().getReaderPlugIn() != null) {
            AbstractMetadata.setAttribute(abstractedMetadata, MISSION, product.getProductReader().getReaderPlugIn().getFormatNames()[0]);
        }
    }

    private static void migrateToCurrentVersion(MetadataElement abstractedMetadata) {
        String version = abstractedMetadata.getAttributeString(abstracted_metadata_version, "");
        if (version.equals(METADATA_VERSION)) {
            return;
        }
    }

    private static void patchMissingMetadata(MetadataElement abstractedMetadata) {
        MetadataAttribute[] attribs;
        String version = abstractedMetadata.getAttributeString(abstracted_metadata_version, "");
        if (version.equals(METADATA_VERSION)) {
            return;
        }
        MetadataElement tmpElem = new MetadataElement("tmp");
        MetadataElement completeMetadata = AbstractMetadata.addAbstractedMetadataHeader(tmpElem);
        for (MetadataAttribute at : attribs = completeMetadata.getAttributes()) {
            if (abstractedMetadata.containsAttribute(at.getName())) continue;
            abstractedMetadata.addAttribute(at);
            abstractedMetadata.getProduct().setModified(false);
        }
    }

    public static MetadataElement getSlaveMetadata(MetadataElement targetRoot) {
        MetadataElement targetSlaveMetadataRoot = targetRoot.getElement(SLAVE_METADATA_ROOT);
        if (targetSlaveMetadataRoot == null) {
            targetSlaveMetadataRoot = new MetadataElement(SLAVE_METADATA_ROOT);
            targetRoot.addElement(targetSlaveMetadataRoot);
        }
        return targetSlaveMetadataRoot;
    }

    @Deprecated
    public static MetadataElement getBandAbsMetadata(MetadataElement root, String bandName, boolean create) {
        String bandElemName = BAND_PREFIX + bandName;
        MetadataElement bandElem = root.getElement(bandElemName);
        if (bandElem == null) {
            if (bandName.startsWith("Intensity")) {
                String realBandName = bandName.replace("Intensity_", "i_");
                bandElem = root.getElement(BAND_PREFIX + realBandName);
            } else if (bandName.startsWith("Phase")) {
                String realBandName = bandName.replace("Phase_", "i_");
                bandElem = root.getElement(BAND_PREFIX + realBandName);
            }
            if (bandElem == null && create) {
                bandElem = new MetadataElement(bandElemName);
                root.addElement(bandElem);
            }
        }
        return bandElem;
    }

    public static OrbitStateVector[] getOrbitStateVectors(MetadataElement absRoot) {
        MetadataElement elemRoot = absRoot.getElement(orbit_state_vectors);
        if (elemRoot == null) {
            return new OrbitStateVector[0];
        }
        int numElems = elemRoot.getNumElements();
        OrbitStateVector[] orbitStateVectors = new OrbitStateVector[numElems];
        for (int i = 0; i < numElems; ++i) {
            OrbitStateVector vector;
            MetadataElement subElemRoot = elemRoot.getElement(orbit_vector + (i + 1));
            orbitStateVectors[i] = vector = new OrbitStateVector(subElemRoot.getAttributeUTC(orbit_vector_time), subElemRoot.getAttributeDouble(orbit_vector_x_pos), subElemRoot.getAttributeDouble(orbit_vector_y_pos), subElemRoot.getAttributeDouble(orbit_vector_z_pos), subElemRoot.getAttributeDouble(orbit_vector_x_vel), subElemRoot.getAttributeDouble(orbit_vector_y_vel), subElemRoot.getAttributeDouble(orbit_vector_z_vel));
        }
        return orbitStateVectors;
    }

    public static void setOrbitStateVectors(MetadataElement absRoot, OrbitStateVector[] orbitStateVectors) throws Exception {
        MetadataElement[] oldList;
        MetadataElement elemRoot = absRoot.getElement(orbit_state_vectors);
        for (MetadataElement old : oldList = elemRoot.getElements()) {
            elemRoot.removeElement(old);
        }
        int i = 1;
        for (OrbitStateVector vector : orbitStateVectors) {
            MetadataElement subElemRoot = new MetadataElement(orbit_vector + i);
            elemRoot.addElement(subElemRoot);
            ++i;
            subElemRoot.setAttributeUTC(orbit_vector_time, vector.time);
            subElemRoot.setAttributeDouble(orbit_vector_x_pos, vector.x_pos);
            subElemRoot.setAttributeDouble(orbit_vector_y_pos, vector.y_pos);
            subElemRoot.setAttributeDouble(orbit_vector_z_pos, vector.z_pos);
            subElemRoot.setAttributeDouble(orbit_vector_x_vel, vector.x_vel);
            subElemRoot.setAttributeDouble(orbit_vector_y_vel, vector.y_vel);
            subElemRoot.setAttributeDouble(orbit_vector_z_vel, vector.z_vel);
        }
    }

    public static SRGRCoefficientList[] getSRGRCoefficients(MetadataElement absRoot) {
        MetadataElement elemRoot = absRoot.getElement(srgr_coefficients);
        MetadataElement[] srgr_coef_listElem = elemRoot.getElements();
        SRGRCoefficientList[] srgrCoefficientList = new SRGRCoefficientList[srgr_coef_listElem.length];
        int k = 0;
        for (MetadataElement listElem : srgr_coef_listElem) {
            SRGRCoefficientList srgrList = new SRGRCoefficientList();
            srgrList.time = listElem.getAttributeUTC("zero_doppler_time");
            srgrList.timeMJD = srgrList.time.getMJD();
            srgrList.ground_range_origin = listElem.getAttributeDouble(ground_range_origin);
            int numSubElems = listElem.getNumElements();
            srgrList.coefficients = new double[numSubElems];
            for (int i = 0; i < numSubElems; ++i) {
                MetadataElement coefElem = listElem.getElementAt(i);
                srgrList.coefficients[i] = coefElem.getAttributeDouble(srgr_coef, 0.0);
            }
            srgrCoefficientList[k++] = srgrList;
        }
        return srgrCoefficientList;
    }

    public static void setSRGRCoefficients(MetadataElement absRoot, SRGRCoefficientList[] srgrCoefList) {
        MetadataElement[] oldList;
        MetadataElement elemRoot = absRoot.getElement(srgr_coefficients);
        for (MetadataElement old : oldList = elemRoot.getElements()) {
            elemRoot.removeElement(old);
        }
        int listCnt = 1;
        for (SRGRCoefficientList srgrCoef : srgrCoefList) {
            MetadataElement srgrListElem = new MetadataElement("srgr_coef_list." + listCnt);
            elemRoot.addElement(srgrListElem);
            ++listCnt;
            srgrListElem.setAttributeUTC("zero_doppler_time", srgrCoef.time);
            AbstractMetadata.setAttribute(srgrListElem, ground_range_origin, srgrCoef.ground_range_origin);
            int cnt = 1;
            for (double val : srgrCoef.coefficients) {
                MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
                srgrListElem.addElement(coefElem);
                ++cnt;
                AbstractMetadata.addAbstractedAttribute(coefElem, srgr_coef, 31, "", "SRGR Coefficient");
                AbstractMetadata.setAttribute(coefElem, srgr_coef, val);
            }
        }
    }

    public static DopplerCentroidCoefficientList[] getDopplerCentroidCoefficients(MetadataElement absRoot) {
        MetadataElement elemRoot = absRoot.getElement(dop_coefficients);
        MetadataElement[] dop_coef_listElem = elemRoot.getElements();
        DopplerCentroidCoefficientList[] dopCoefficientList = new DopplerCentroidCoefficientList[dop_coef_listElem.length];
        int k = 0;
        for (MetadataElement listElem : dop_coef_listElem) {
            DopplerCentroidCoefficientList dopList = new DopplerCentroidCoefficientList();
            dopList.time = listElem.getAttributeUTC("zero_doppler_time");
            dopList.timeMJD = dopList.time.getMJD();
            dopList.slant_range_time = listElem.getAttributeDouble(slant_range_time, 0.0);
            int numSubElems = listElem.getNumElements();
            dopList.coefficients = new double[numSubElems];
            for (int i = 0; i < numSubElems; ++i) {
                MetadataElement coefElem = listElem.getElementAt(i);
                dopList.coefficients[i] = coefElem.getAttributeDouble(dop_coef, 0.0);
            }
            dopCoefficientList[k++] = dopList;
        }
        return dopCoefficientList;
    }

    public static void setDopplerCentroidCoefficients(MetadataElement absRoot, DopplerCentroidCoefficientList[] dopList) {
        MetadataElement[] oldList;
        MetadataElement elemRoot = absRoot.getElement(dop_coefficients);
        for (MetadataElement old : oldList = elemRoot.getElements()) {
            elemRoot.removeElement(old);
        }
        int listCnt = 1;
        for (DopplerCentroidCoefficientList dop : dopList) {
            MetadataElement dopplerListElem = new MetadataElement("dop_coef_list." + listCnt);
            elemRoot.addElement(dopplerListElem);
            ++listCnt;
            dopplerListElem.setAttributeUTC("zero_doppler_time", dop.time);
            AbstractMetadata.addAbstractedAttribute(dopplerListElem, slant_range_time, 31, "ns", "Slant Range Time");
            AbstractMetadata.setAttribute(dopplerListElem, slant_range_time, dop.slant_range_time);
            double[] coef = dop.coefficients;
            int cnt = 1;
            for (double coefValue : coef) {
                MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
                dopplerListElem.addElement(coefElem);
                ++cnt;
                AbstractMetadata.addAbstractedAttribute(coefElem, dop_coef, 31, "", "Doppler Centroid Coefficient");
                AbstractMetadata.setAttribute(coefElem, dop_coef, coefValue);
            }
        }
    }

    public static class DopplerCentroidCoefficientList {
        public ProductData.UTC time = null;
        public double timeMJD = 0.0;
        public double slant_range_time = 0.0;
        public double[] coefficients = null;
    }

    public static class SRGRCoefficientList {
        public ProductData.UTC time = null;
        public double timeMJD = 0.0;
        public double ground_range_origin = 0.0;
        public double[] coefficients = null;
    }
}

