/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;

public class ZipUtils {
    private static final String[] extList = new String[]{".zip", ".gz", ".z", ".7z"};

    public static boolean isZipped(File file) {
        String name = file.getName().toLowerCase();
        for (String ext : extList) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isZip(File inputFile) {
        return inputFile.getName().toLowerCase().endsWith(".zip");
    }

    public static boolean findInZip(File file, String prefix, String suffix) {
        try {
            ZipFile productZip = new ZipFile(file, 1);
            Optional<ZipEntry> result = productZip.stream().filter(ze -> !ze.isDirectory()).filter(ze -> ze.getName().toLowerCase().endsWith(suffix)).filter(ze -> ze.getName().toLowerCase().startsWith(prefix)).findFirst();
            return result.isPresent();
        }
        catch (Exception e) {
            SystemUtils.LOG.warning("unable to read zip file " + file + ": " + e.getMessage());
            return false;
        }
    }

    public static String getRootFolder(File file, String headerFileName) throws IOException {
        ZipFile productZip = new ZipFile(file, 1);
        Optional<ZipEntry> result = productZip.stream().filter(ze -> !ze.isDirectory()).filter(ze -> ze.getName().toLowerCase().endsWith(headerFileName)).findFirst();
        ZipEntry ze2 = result.get();
        String path = ze2.toString();
        int sepIndex = path.lastIndexOf(47);
        if (sepIndex > 0) {
            return path.substring(0, sepIndex) + '/';
        }
        return "";
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static boolean isValid(File file) {
        try {
            Throwable throwable = null;
            try (ZipFile zipfile = new ZipFile(file);){
                boolean bl;
                Throwable throwable2;
                ZipInputStream zis;
                block64: {
                    block65: {
                        ZipEntry ze;
                        block61: {
                            boolean bl2;
                            block62: {
                                block63: {
                                    zis = new ZipInputStream(new FileInputStream(file));
                                    throwable2 = null;
                                    ze = zis.getNextEntry();
                                    if (ze != null) break block61;
                                    bl2 = false;
                                    if (zis == null) break block62;
                                    if (throwable2 == null) break block63;
                                    try {
                                        zis.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    break block62;
                                }
                                zis.close();
                            }
                            return bl2;
                        }
                        while (true) {
                            if (ze == null) break;
                            try {
                                InputStream in = zipfile.getInputStream(ze);
                                Throwable throwable4 = null;
                                try {
                                    ze.getCrc();
                                    ze.getCompressedSize();
                                    ze = zis.getNextEntry();
                                }
                                catch (Throwable throwable5) {
                                    throwable4 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    if (in == null) continue;
                                    if (throwable4 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable4.addSuppressed(throwable6);
                                        }
                                        continue;
                                    }
                                    in.close();
                                }
                            }
                            catch (IOException e) {
                                boolean bl3 = false;
                                if (zis != null) {
                                    if (throwable2 != null) {
                                        try {
                                            zis.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                    } else {
                                        zis.close();
                                    }
                                }
                                if (zipfile != null) {
                                    if (throwable != null) {
                                        try {
                                            zipfile.close();
                                        }
                                        catch (Throwable throwable8) {
                                            throwable.addSuppressed(throwable8);
                                        }
                                    } else {
                                        zipfile.close();
                                    }
                                }
                                return bl3;
                            }
                        }
                        bl = true;
                        if (zis == null) break block64;
                        if (throwable2 == null) break block65;
                        try {
                            zis.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        break block64;
                    }
                    zis.close();
                }
                return bl;
                catch (Throwable throwable10) {
                    try {
                        try {
                            try {
                                throwable2 = throwable10;
                                throw throwable10;
                            }
                            catch (Throwable throwable11) {
                                if (zis != null) {
                                    if (throwable2 != null) {
                                        try {
                                            zis.close();
                                        }
                                        catch (Throwable throwable12) {
                                            throwable2.addSuppressed(throwable12);
                                        }
                                    } else {
                                        zis.close();
                                    }
                                }
                                throw throwable11;
                            }
                        }
                        catch (IOException e) {
                            boolean bl4 = false;
                            return bl4;
                        }
                    }
                    catch (Throwable throwable13) {
                        throwable = throwable13;
                        throw throwable13;
                    }
                    catch (Throwable throwable14) {
                        throw throwable14;
                    }
                }
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static File[] unzipToFolder(File inFile, File outFolder) throws Exception {
        try (ISevenZipInArchive inArchive = null;){
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(inFile, "r");){
                inArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
                int[] in = new int[inArchive.getNumberOfItems()];
                for (int i = 0; i < in.length; ++i) {
                    in[i] = i;
                }
                ExtractCallback extractCB = new ExtractCallback(inArchive, inFile, outFolder);
                inArchive.extract(in, false, (IArchiveExtractCallback)extractCB);
                File[] fileArray = extractCB.getTargetFiles();
                return fileArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static InputStream unZipToStream(File file) throws Exception {
        return new ZipArchiveInputStream((InputStream)new FileInputStream(file));
    }

    public static void zipFolder(Path directory, File outputZipFile) throws IOException {
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(outputZipFile));){
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);
            dirStream.forEach(path -> ZipUtils.addToZipFile(path.toFile(), zipStream));
        }
    }

    public static void zipFile(File file, File outputZipFile) throws IOException {
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(outputZipFile));){
            ZipUtils.addToZipFile(file, zipStream);
        }
    }

    private static void addToZipFile(File file, ZipOutputStream zipStream) {
        try (FileInputStream inputStream = new FileInputStream(file.getPath());){
            int amountRead;
            ZipEntry entry = new ZipEntry(file.getName());
            entry.setCreationTime(FileTime.fromMillis(file.lastModified()));
            zipStream.putNextEntry(entry);
            byte[] readBuffer = new byte[2048];
            int written = 0;
            while ((amountRead = inputStream.read(readBuffer)) > 0) {
                zipStream.write(readBuffer, 0, amountRead);
                written += amountRead;
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("Unable to zip " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static InputStream unzipToStream(File file) throws Exception {
        try (ISevenZipInArchive inArchive = null;){
            InputStream inputStream;
            Throwable throwable;
            RandomAccessFile randomAccessFile;
            block18: {
                block19: {
                    randomAccessFile = new RandomAccessFile(file, "r");
                    throwable = null;
                    inArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
                    int numItems = inArchive.getNumberOfItems();
                    ISimpleInArchiveItem item = inArchive.getSimpleInterface().getArchiveItem(0);
                    inputStream = new ArchiveInputStreamHandler(item).getInputStream();
                    if (randomAccessFile == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        randomAccessFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                randomAccessFile.close();
            }
            return inputStream;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (randomAccessFile != null) {
                            if (throwable != null) {
                                try {
                                    randomAccessFile.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                randomAccessFile.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static class ExtractCallback
    implements IArchiveExtractCallback {
        private int index;
        private int current = -1;
        private boolean skipExtraction;
        private final ISevenZipInArchive inArchive;
        private final File inFile;
        private final File outFolder;
        private OutputStream out;
        private final File[] targetFiles;

        public ExtractCallback(ISevenZipInArchive inArchive, File inFile, File outFolder) throws SevenZipException {
            this.inArchive = inArchive;
            this.inFile = inFile;
            this.outFolder = outFolder;
            this.targetFiles = new File[inArchive.getNumberOfItems()];
        }

        public File[] getTargetFiles() {
            return this.targetFiles;
        }

        public ISequentialOutStream getStream(final int index, ExtractAskMode extractAskMode) throws SevenZipException {
            this.index = index;
            this.skipExtraction = (Boolean)this.inArchive.getProperty(index, PropID.IS_FOLDER);
            if (this.skipExtraction || extractAskMode != ExtractAskMode.EXTRACT) {
                return null;
            }
            return new ISequentialOutStream(){

                public int write(byte[] data) throws SevenZipException {
                    try {
                        if (index != current) {
                            File target;
                            if (out != null) {
                                out.flush();
                                out.close();
                            }
                            current = index;
                            Object path = inArchive.getProperty(index, PropID.PATH);
                            if (path == null) {
                                path = FileUtils.getFilenameWithoutExtension((File)inFile);
                            }
                            ((ExtractCallback)this).targetFiles[index] = target = new File(outFolder, String.valueOf(path));
                            if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                                SystemUtils.LOG.severe("Unable to create folders in " + target.getParentFile());
                            }
                            out = new BufferedOutputStream(new FileOutputStream(target));
                        }
                        try {
                            out.write(data, 0, data.length);
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        return data.length;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        }

        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
        }

        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            if (this.skipExtraction) {
                return;
            }
            try {
                this.out.flush();
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (extractOperationResult != ExtractOperationResult.OK) {
                // empty if block
            }
        }

        public void setCompleted(long completeValue) throws SevenZipException {
        }

        public void setTotal(long total) throws SevenZipException {
        }
    }

    private static class ArchiveInputStreamHandler {
        private final ISimpleInArchiveItem item;
        private ByteArrayInputStream arrayInputStream;

        public ArchiveInputStreamHandler(ISimpleInArchiveItem item) {
            this.item = item;
        }

        public InputStream getInputStream() throws SevenZipException {
            this.item.extractSlow(new ISequentialOutStream(){

                public int write(byte[] data) throws SevenZipException {
                    arrayInputStream = new ByteArrayInputStream(data);
                    return data.length;
                }
            });
            return this.arrayInputStream;
        }
    }
}

