/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;

public final class ResourceUtils {
    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            for (String aChild : file.list()) {
                ResourceUtils.deleteFile(new File(file, aChild));
            }
        }
        if (!file.delete()) {
            System.out.println("Could not delete " + file.getName());
        }
    }

    public static Properties loadProperties(String filename) throws IOException {
        try (InputStream dbPropInputStream = ResourceUtils.getResourceAsStream(filename, ResourceUtils.class);){
            Properties properties = ResourceUtils.loadProperties(dbPropInputStream);
            return properties;
        }
    }

    public static Properties loadProperties(InputStream dbPropInputStream) throws IOException {
        Properties dbProperties = new Properties();
        try {
            dbProperties.load(dbPropInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return dbProperties;
    }

    public static InputStream getResourceAsStream(String filename, Class theClass) throws IOException {
        Path basePath = ResourceInstaller.findModuleCodeBasePath((Class)theClass);
        return Files.newInputStream(basePath.resolve(filename), new OpenOption[0]);
    }

    public static File getReportFolder() {
        File reportFolder = new File(SystemUtils.getApplicationDataDir((boolean)true) + File.separator + "var" + File.separator + "log");
        if (!reportFolder.exists() && !reportFolder.mkdirs()) {
            SystemUtils.LOG.severe("Unable to create folders in " + reportFolder);
        }
        return reportFolder;
    }

    public static Path getGraphFolder(String subFolder) {
        return SystemUtils.getApplicationDataDir().toPath().resolve("graphs").resolve(subFolder);
    }

    public static File getResFolder() {
        return new File(SystemUtils.getApplicationHomeDir(), "resource");
    }

    public static void sortFileList(File[] filelist) {
        DirAlphaComparator byDirThenAlpha = new DirAlphaComparator();
        Arrays.sort(filelist, byDirThenAlpha);
    }

    private static class DirAlphaComparator
    implements Comparator<File> {
        private DirAlphaComparator() {
        }

        @Override
        public int compare(File filea, File fileb) {
            if (filea.isDirectory() && !fileb.isDirectory()) {
                return -1;
            }
            if (!filea.isDirectory() && fileb.isDirectory()) {
                return 1;
            }
            return filea.getName().compareToIgnoreCase(fileb.getName());
        }
    }
}

