/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class FileIOUtils {
    public static void replaceText(File inFile, File outFile, String oldText, String newText) throws IOException {
        List lines;
        try (FileReader fileReader = new FileReader(inFile);){
            lines = IOUtils.readLines((Reader)fileReader);
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                if (!line.contains(oldText)) continue;
                lines.set(i, line.replaceAll(oldText, newText));
            }
        }
        if (!lines.isEmpty()) {
            var6_5 = null;
            try (FileWriter fileWriter = new FileWriter(outFile);){
                IOUtils.writeLines((Collection)lines, (String)"\n", (Writer)fileWriter);
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
        }
    }

    public static void copyFolder(Path source, Path target) throws IOException {
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        CopyDirVisitor tc = new CopyDirVisitor(source, target, false);
        Files.walkFileTree(source, opts, Integer.MAX_VALUE, tc);
    }

    public static void moveFolder(Path source, Path target) throws IOException {
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        CopyDirVisitor tc = new CopyDirVisitor(source, target, true);
        Files.walkFileTree(source, opts, Integer.MAX_VALUE, tc);
    }

    public static void deleteFolder(Path source) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        });
    }

    static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path target;
        private final boolean isMove;

        CopyDirVisitor(Path source, Path target, boolean move) {
            this.source = source;
            this.target = target;
            this.isMove = move;
        }

        private boolean copyFile(Path source, Path target) throws IOException {
            try {
                if (this.isMove) {
                    Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.target.resolve(this.source.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.copyFile(file, this.target.resolve(this.source.relativize(file)));
            return FileVisitResult.CONTINUE;
        }
    }
}

