/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.db;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.esa.snap.core.util.SystemUtils;

public abstract class DAO {
    private boolean isConnected;
    private final Properties dbProperties;
    private final String dbName;
    private Connection dbConnect = null;
    protected SQLException lastSQLException = null;

    public DAO(String name, Properties dbProperties) throws IOException {
        this.dbName = name;
        this.dbProperties = dbProperties;
        DAO.setDBSystemDir();
        DAO.loadDatabaseDriver(dbProperties.getProperty("derby.driver"));
        if (!this.dbExists() && !this.createDatabase()) {
            throw new IOException("Unable to create tables\n" + this.getLastSQLException().getMessage());
        }
    }

    private boolean dbExists() {
        String dbLocation = this.getDatabaseLocation();
        File dbFileDir = new File(dbLocation);
        return dbFileDir.exists();
    }

    private static void setDBSystemDir() {
        File fileSystemDir = DAO.getDBSystemDir();
        if (!fileSystemDir.exists()) {
            fileSystemDir.mkdir();
        }
        System.setProperty("derby.system.home", fileSystemDir.getAbsolutePath());
    }

    public static File getDBSystemDir() {
        return new File(SystemUtils.getApplicationDataDir((boolean)true), "productDB");
    }

    private static void loadDatabaseDriver(String driverName) {
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    protected abstract boolean createTables(Connection var1) throws SQLException;

    protected abstract void validateTables(Connection var1) throws SQLException;

    protected abstract void prepareStatements() throws SQLException;

    private boolean createDatabase() {
        boolean bCreated = false;
        this.dbProperties.put("create", "true");
        try {
            this.dbConnect = DriverManager.getConnection(this.getDatabaseUrl(), this.dbProperties);
            bCreated = this.createTables(this.dbConnect);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.lastSQLException = ex;
        }
        this.dbProperties.remove("create");
        return bCreated;
    }

    private void validateDatabase(Connection dbConnection) {
        this.dbProperties.put("create", "true");
        try {
            this.validateTables(dbConnection);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.lastSQLException = ex;
        }
        this.dbProperties.remove("create");
    }

    protected boolean connect() {
        if (this.isConnected) {
            return this.isConnected;
        }
        try {
            if (this.dbConnect == null) {
                this.dbConnect = DriverManager.getConnection(this.getDatabaseUrl(), this.dbProperties);
            }
            this.validateDatabase(this.dbConnect);
            this.prepareStatements();
            this.isConnected = this.dbConnect != null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.isConnected = false;
            this.lastSQLException = ex;
        }
        return this.isConnected;
    }

    protected void disconnect() {
        if (this.isConnected) {
            this.dbProperties.put("shutdown", "true");
            try {
                Connection connection = DriverManager.getConnection(this.getDatabaseUrl(), this.dbProperties);
                Throwable throwable = null;
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
            catch (SQLException ex) {
                this.lastSQLException = ex;
            }
            this.isConnected = false;
            this.dbProperties.remove("shutdown");
        }
    }

    public Connection getConnection() {
        return this.dbConnect;
    }

    public SQLException getLastSQLException() {
        return this.lastSQLException;
    }

    public String getDatabaseLocation() {
        return System.getProperty("derby.system.home") + File.separator + this.dbName;
    }

    public String getDatabaseUrl() {
        return this.dbProperties.getProperty("derby.url") + this.dbName;
    }
}

