/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel.metadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public final class AbstractMetadataIO {
    private static final String TPG = "tie-point-grids";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String ATTRIB = "attrib";

    public static boolean loadExternalMetadata(Product product, MetadataElement absRoot, File productFile) throws IOException {
        String inputStr = productFile.getAbsolutePath();
        String metadataStr = inputStr.substring(0, inputStr.lastIndexOf(46)) + ".xml";
        File metadataFile = new File(metadataStr);
        if (metadataFile.exists() && AbstractMetadataIO.Load(product, absRoot, metadataFile)) {
            return true;
        }
        metadataFile = new File(productFile.getParentFile(), "metadata.xml");
        return metadataFile.exists() && AbstractMetadataIO.Load(product, absRoot, metadataFile);
    }

    public static void saveExternalMetadata(Product product, MetadataElement absRoot, File productFile) {
        String inputStr = productFile.getAbsolutePath();
        int dotPos = inputStr.lastIndexOf(46);
        if (dotPos < 0) {
            dotPos = inputStr.length();
        }
        String metadataStr = inputStr.substring(0, dotPos) + ".xml";
        File metadataFile = new File(metadataStr);
        AbstractMetadataIO.Save(product, absRoot, metadataFile);
    }

    public static void Save(Product product, MetadataElement metadataElem, File metadataFile) {
        Element root = new Element("Metadata");
        Document doc = new Document(root);
        if (metadataElem != null) {
            Element AbstractedMetadataElem = new Element("Abstracted_Metadata");
            root.addContent((Content)AbstractedMetadataElem);
            XMLSupport.metadataElementToDOMElement((MetadataElement)metadataElem, (Element)AbstractedMetadataElem);
        }
        if (product.getTiePointGrids().length > 0) {
            Element tiePointGridsElem = new Element(TPG);
            root.addContent((Content)tiePointGridsElem);
            AbstractMetadataIO.writeTiePointGrids(product, tiePointGridsElem);
        }
        XMLSupport.SaveXML((Document)doc, (String)metadataFile.getAbsoluteFile().toString());
    }

    public static boolean Load(Product product, MetadataElement metadataElem, File metadataFile) throws IOException {
        Document doc;
        try {
            doc = XMLSupport.LoadXML((String)metadataFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        Element root = doc.getRootElement();
        List elements = root.getContent();
        for (Object o : elements) {
            if (!(o instanceof Element)) continue;
            Element elem = (Element)o;
            if (elem.getName().equals("Abstracted_Metadata")) {
                AbstractMetadataIO.findAbstractedMetadata(elem.getContent(), metadataElem);
                continue;
            }
            if (!elem.getName().equals(TPG)) continue;
            AbstractMetadataIO.parseTiePointGrids(product, elem);
        }
        return true;
    }

    private static void findAbstractedMetadata(List domChildren, MetadataElement metadataElem) {
        for (Object aChild : domChildren) {
            if (!(aChild instanceof Element)) continue;
            Element child = (Element)aChild;
            String childName = child.getName();
            if (child.getContentSize() > 0) {
                MetadataElement subElem = metadataElem.getElement(childName);
                if (subElem == null) {
                    subElem = new MetadataElement(childName);
                    metadataElem.addElement(subElem);
                }
                AbstractMetadataIO.findAbstractedMetadata(child.getContent(), subElem);
                continue;
            }
            if (!childName.equals(ATTRIB)) continue;
            AbstractMetadataIO.loadAttribute(child, metadataElem);
        }
    }

    private static void loadAttribute(Element domElem, MetadataElement rootElem) {
        int type;
        MetadataAttribute metaAttrib;
        Attribute nameAttrib = domElem.getAttribute(NAME);
        if (nameAttrib == null) {
            return;
        }
        String name = nameAttrib.getValue();
        if (name == null) {
            return;
        }
        Attribute valueAttrib = domElem.getAttribute(VALUE);
        if (valueAttrib == null) {
            return;
        }
        Attribute typeAttrib = domElem.getAttribute(TYPE);
        Integer typeFromFile = null;
        if (typeAttrib != null) {
            typeFromFile = Integer.parseInt(typeAttrib.getValue());
        }
        if ((metaAttrib = rootElem.getAttribute(name)) == null) {
            if (typeFromFile != null) {
                metaAttrib = new MetadataAttribute(name, typeFromFile.intValue());
                rootElem.addAttribute(metaAttrib);
            } else {
                return;
            }
        }
        if ((type = metaAttrib.getDataType()) == 41) {
            String valStr = valueAttrib.getValue();
            if (valStr == null || valStr.isEmpty()) {
                valStr = " ";
            }
            metaAttrib.getData().setElems((Object)valStr);
        } else if (type == 51 || typeFromFile == 51) {
            metaAttrib.getData().setElems((Object)AbstractMetadata.parseUTC(valueAttrib.getValue()).getArray());
        } else if (type == 31 || type == 30) {
            metaAttrib.getData().setElemDouble(Double.parseDouble(valueAttrib.getValue()));
        } else if (type == 10 && typeFromFile != null && typeFromFile == 41) {
            metaAttrib.getData().setElems((Object)valueAttrib.getValue());
        } else {
            metaAttrib.getData().setElemInt(Integer.parseInt(valueAttrib.getValue()));
        }
        Attribute unitAttrib = domElem.getAttribute("unit");
        Attribute descAttrib = domElem.getAttribute("desc");
        if (descAttrib != null) {
            metaAttrib.setDescription(descAttrib.getValue());
        }
        if (unitAttrib != null) {
            metaAttrib.setUnit(unitAttrib.getValue());
        }
    }

    private static void parseTiePointGrids(Product product, Element tpgElem) throws IOException {
        List tpgElements = tpgElem.getContent();
        for (Object o : tpgElements) {
            if (!(o instanceof Element)) continue;
            Element elem = (Element)o;
            String name = elem.getName();
            List content = elem.getContent();
            ArrayList<Float> valueList = new ArrayList<Float>();
            int columnCount = 0;
            int rowCount = 0;
            for (Object row : content) {
                if (!(row instanceof Element)) continue;
                Element rowElem = (Element)row;
                Attribute value = rowElem.getAttribute(VALUE);
                int columns = AbstractMetadataIO.parseTiePointGirdRow(value.getValue(), valueList);
                if (columnCount == 0) {
                    columnCount = columns;
                } else if (columnCount != columns) {
                    throw new IOException("Metadata for tie-point-grid " + name + " has incorrect number of columns");
                }
                ++rowCount;
            }
            AbstractMetadataIO.addTiePointGrid(product, name, valueList, columnCount, rowCount);
        }
        AbstractMetadataIO.setGeoCoding(product);
    }

    private static void setGeoCoding(Product product) {
        TiePointGrid[] grids = product.getTiePointGrids();
        TiePointGrid latGrid = null;
        TiePointGrid lonGrid = null;
        for (TiePointGrid g : grids) {
            if (g.getName().toLowerCase().contains("lat")) {
                latGrid = g;
                continue;
            }
            if (!g.getName().toLowerCase().contains("lon")) continue;
            lonGrid = g;
        }
        if (latGrid != null && lonGrid != null) {
            TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
            product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
        }
    }

    private static int parseTiePointGirdRow(String line, List<Float> valueList) {
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        int tokenCount = 0;
        while (tokenizer.hasMoreTokens()) {
            valueList.add(Float.valueOf(Float.parseFloat(tokenizer.nextToken())));
            ++tokenCount;
        }
        return tokenCount;
    }

    private static void addTiePointGrid(Product product, String name, List<Float> valueList, int inputWidth, int inputHeight) {
        if (product.getTiePointGrid(name) != null) {
            return;
        }
        int gridWidth = inputWidth;
        int gridHeight = inputHeight;
        if (gridWidth < 5) {
            gridWidth *= 5;
        }
        if (gridHeight < 5) {
            gridHeight *= 5;
        }
        double subSamplingX = (double)product.getSceneRasterWidth() / (double)(gridWidth - 1);
        double subSamplingY = (double)product.getSceneRasterHeight() / (double)(gridHeight - 1);
        float[] inPoints = new float[valueList.size()];
        float[] outPoints = new float[gridWidth * gridHeight];
        int i = 0;
        for (Float val : valueList) {
            inPoints[i++] = val.floatValue();
        }
        ReaderUtils.createFineTiePointGrid(inputWidth, inputHeight, gridWidth, gridHeight, inPoints, outPoints);
        TiePointGrid newTPG = new TiePointGrid(name, gridWidth, gridHeight, 0.0, 0.0, subSamplingX, subSamplingY, outPoints);
        product.addTiePointGrid(newTPG);
    }

    private static void writeTiePointGrids(Product product, Element root) {
        TiePointGrid[] grids;
        for (TiePointGrid g : grids = product.getTiePointGrids()) {
            Element gridElem = new Element(g.getName());
            root.addContent((Content)gridElem);
            String unit = g.getUnit();
            String desc = g.getDescription();
            gridElem.setAttribute("unit", unit == null ? "" : unit);
            gridElem.setAttribute("desc", desc == null ? "" : desc);
            int width = g.getGridWidth();
            int height = g.getGridHeight();
            float[] tiePoints = g.getTiePoints();
            int index = 0;
            for (int r = 0; r < height; ++r) {
                Element rowElem = new Element("row");
                gridElem.addContent((Content)rowElem);
                StringBuilder valueStrBld = new StringBuilder();
                for (int c = 0; c < width; ++c) {
                    valueStrBld.append(tiePoints[index++]);
                    if (c >= width - 1) continue;
                    valueStrBld.append(',');
                }
                rowElem.setAttribute(VALUE, valueStrBld.toString());
            }
        }
    }

    public static void AddXMLMetadata(Element xmlRoot, MetadataElement metadataRoot) {
        String rootName = xmlRoot.getName();
        boolean rootChildrenEmpty = xmlRoot.getChildren().isEmpty();
        if (rootChildrenEmpty && xmlRoot.getAttributes().isEmpty()) {
            if (!xmlRoot.getValue().isEmpty()) {
                AbstractMetadataIO.addAttribute(metadataRoot, rootName, xmlRoot.getValue());
            }
        } else if (rootChildrenEmpty) {
            MetadataElement metaElem = new MetadataElement(rootName);
            if (!xmlRoot.getValue().isEmpty()) {
                AbstractMetadataIO.addAttribute(metaElem, rootName, xmlRoot.getValue());
            }
            List xmlAttribs = xmlRoot.getAttributes();
            for (Attribute aChild : xmlAttribs) {
                AbstractMetadataIO.addAttribute(metaElem, aChild.getName(), aChild.getValue());
            }
            metadataRoot.addElement(metaElem);
        } else {
            MetadataElement metaElem = new MetadataElement(rootName);
            List children = xmlRoot.getContent();
            for (Object aChild : children) {
                if (aChild instanceof Element) {
                    AbstractMetadataIO.AddXMLMetadata((Element)aChild, metaElem);
                    continue;
                }
                if (!(aChild instanceof Attribute)) continue;
                Attribute childAtrrib = (Attribute)aChild;
                AbstractMetadataIO.addAttribute(metaElem, childAtrrib.getName(), childAtrrib.getValue());
            }
            List xmlAttribs = xmlRoot.getAttributes();
            for (Attribute aChild : xmlAttribs) {
                AbstractMetadataIO.addAttribute(metaElem, aChild.getName(), aChild.getValue());
            }
            metadataRoot.addElement(metaElem);
        }
    }

    private static void addAttribute(MetadataElement meta, String name, String value) {
        try {
            MetadataAttribute attribute = new MetadataAttribute(name, 41, 1);
            if (value.isEmpty()) {
                value = " ";
            }
            attribute.getData().setElems((Object)value);
            meta.addAttribute(attribute);
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + " " + name + " " + value);
        }
    }
}

