/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel;

import org.esa.snap.core.datamodel.Band;

public final class Unit {
    public static final String AMPLITUDE = "amplitude";
    public static final String INTENSITY = "intensity";
    public static final String PHASE = "phase";
    public static final String ABS_PHASE = "abs_phase";
    public static final String COHERENCE = "coherence";
    public static final String REAL = "real";
    public static final String IMAGINARY = "imaginary";
    public static final String DB = "db";
    public static final String AMPLITUDE_DB = "amplitude_db";
    public static final String INTENSITY_DB = "intensity_db";
    public static final String METERS = "meters";
    public static final String METERS_PER_DAY = "m/day";
    public static final String CLASS = "class";
    public static final String DEGREES = "deg";
    public static final String NANOSECONDS = "ns";
    public static final String BIT = "bit";

    public static UnitType getUnitType(Band sourceBand) {
        if (sourceBand.getUnit() == null) {
            return UnitType.UNKNOWN;
        }
        String unit = sourceBand.getUnit().toLowerCase();
        if (unit.contains(AMPLITUDE)) {
            if (unit.contains(DB)) {
                return UnitType.AMPLITUDE_DB;
            }
            return UnitType.AMPLITUDE;
        }
        if (unit.contains(INTENSITY)) {
            if (unit.contains(DB)) {
                return UnitType.INTENSITY_DB;
            }
            return UnitType.INTENSITY;
        }
        if (unit.contains(PHASE)) {
            return UnitType.PHASE;
        }
        if (unit.contains(ABS_PHASE)) {
            return UnitType.ABS_PHASE;
        }
        if (unit.contains(REAL)) {
            return UnitType.REAL;
        }
        if (unit.contains(IMAGINARY)) {
            return UnitType.IMAGINARY;
        }
        if (unit.contains(METERS)) {
            return UnitType.METERS;
        }
        if (unit.contains(METERS_PER_DAY)) {
            return UnitType.METERS_PER_DAY;
        }
        if (unit.contains(COHERENCE)) {
            return UnitType.COHERENCE;
        }
        if (unit.contains(CLASS)) {
            return UnitType.CLASS;
        }
        if (unit.contains(DEGREES)) {
            return UnitType.DEGREES;
        }
        if (unit.contains(NANOSECONDS)) {
            return UnitType.NANOSECONDS;
        }
        return UnitType.UNKNOWN;
    }

    public static enum UnitType {
        AMPLITUDE,
        INTENSITY,
        REAL,
        IMAGINARY,
        PHASE,
        ABS_PHASE,
        COHERENCE,
        AMPLITUDE_DB,
        INTENSITY_DB,
        METERS,
        METERS_PER_DAY,
        CLASS,
        DEGREES,
        NANOSECONDS,
        UNKNOWN;

    }
}

