/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import java.io.File;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.util.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestInputProductValidator {
    public static final String sep = File.separator;
    public static final String rootPathTestProducts = SystemUtils.getApplicationHomeDir() + sep + ".." + sep + ".." + sep + ".." + sep + ".." + sep + "testdata";
    public static final String inputSAR = rootPathTestProducts + sep + "input" + sep + "SAR" + sep;
    public static final File inputASAR_WSM = new File(inputSAR + "ASAR" + sep + "subset_1_of_ENVISAT-ASA_WSM_1PNPDE20080119_093446_000000852065_00165_30780_2977.dim");

    @Test
    public void TestNotSentinel1Product() throws Exception {
        File inputFile = inputASAR_WSM;
        if (!inputFile.exists()) {
            TestUtils.skipTest((Object)this, (String)(inputFile + " not found"));
            return;
        }
        Product sourceProduct = TestUtils.readSourceProduct((File)inputFile);
        InputProductValidator validator = new InputProductValidator(sourceProduct);
        try {
            validator.checkIfSentinel1Product();
        }
        catch (OperatorException e) {
            TestCase.assertEquals((String)e.getMessage(), (String)"Input should be a Sentinel-1 product.");
        }
        try {
            validator.checkProductType(new String[]{"GRD"});
        }
        catch (OperatorException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not a valid product type"));
        }
        try {
            validator.checkIfMapProjected(false);
        }
        catch (OperatorException e) {
            TestCase.assertEquals((String)e.getMessage(), (String)"Source product should not be map projected");
        }
        try {
            validator.checkIfTOPSARBurstProduct(true);
        }
        catch (OperatorException e) {
            TestCase.assertEquals((String)e.getMessage(), (String)"Source product should be an SLC burst product");
        }
        try {
            validator.checkAcquisitionMode(new String[]{"IW", "EW"});
        }
        catch (OperatorException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not a valid acquisition mode"));
        }
    }
}

