/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel.metadata;

import java.io.IOException;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataSAR;
import org.esa.snap.engine_utilities.util.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractMetadata {
    @Test
    public void TestAbstractMetadataSAR() throws IOException {
        Product product = TestAbstractMetadata.createTestProduct(10, 10);
        TestAbstractMetadata.createMetadata(product);
        AbstractMetadataSAR sarMeta = AbstractMetadataSAR.getSARAbstractedMetadata((Product)product);
        String dem = sarMeta.getAttributeString("DEM");
        Assert.assertEquals((Object)dem, (Object)"dem");
        AbstractMetadata absMeta = AbstractMetadata.getAbstractedMetadata((Product)product);
        String productName = absMeta.getAttributeString("PRODUCT");
        Assert.assertEquals((Object)productName, (Object)"name");
    }

    private static Product createProduct(String type, int w, int h) {
        Product product = new Product("name", type, w, h);
        product.setStartTime(AbstractMetadata.parseUTC((String)"10-MAY-2008 20:30:46.890683"));
        product.setEndTime(AbstractMetadata.parseUTC((String)"10-MAY-2008 20:35:46.890683"));
        product.setDescription("description");
        return product;
    }

    private static Product createTestProduct(int w, int h) {
        Product testProduct = TestAbstractMetadata.createProduct("ASA_APG_1P", w, h);
        TestUtils.createBand((Product)testProduct, (String)"band1", (int)w, (int)h);
        return testProduct;
    }

    private static void createMetadata(Product product) throws IOException {
        AbstractMetadataSAR sarMeta = AbstractMetadataSAR.getSARAbstractedMetadata((Product)product);
        sarMeta.setAttribute("DEM", "dem");
        AbstractMetadata absMeta = AbstractMetadata.getAbstractedMetadata((Product)product);
        absMeta.setAttribute("PRODUCT", "name");
    }
}

