/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.db;

import java.io.File;
import java.net.URL;
import org.esa.snap.db.DBQuery;
import org.esa.snap.db.ProductDB;
import org.esa.snap.db.ProductEntry;
import org.junit.Before;
import org.junit.Test;

public class TestDBQuery {
    private static String dbPropertiesPath = "org/esa/snap/config/productDB.properties";
    private ProductDB db;

    @Before
    public void setUp() throws Exception {
        URL fileUrl = this.getClass().getClassLoader().getResource(dbPropertiesPath);
        this.db = ProductDB.testInstance((File)new File(fileUrl.getFile()));
    }

    @Test
    public void testQuery() throws Exception {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setSelectedMissions(new String[]{"ENVISAT"});
        ProductEntry[] productEntryList = dbQuery.queryDatabase(this.db);
        TestDBQuery.showProductEntries(productEntryList);
    }

    public void testFreeQuery() throws Exception {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setFreeQuery("PRODUCT LIKE 'RS2_SGF%'");
        ProductEntry[] productEntryList = dbQuery.queryDatabase(this.db);
        TestDBQuery.showProductEntries(productEntryList);
    }

    private static void showProductEntries(ProductEntry[] productEntryList) {
        for (ProductEntry entry : productEntryList) {
        }
    }
}

