/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.reader;

import java.io.File;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.csv.dataio.reader.CsvProductReaderPlugIn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsvProductReaderPlugInTest {
    private CsvProductReaderPlugIn csvProductReaderPlugIn;

    @Before
    public void setUp() throws Exception {
        this.csvProductReaderPlugIn = new CsvProductReaderPlugIn();
    }

    @Test
    public void testGetDecodeQualification() throws Exception {
        File validFile = new File(this.getClass().getResource("simple_format_example.txt").getFile());
        File validFileWithoutProperties = new File(this.getClass().getResource("simple_format_no_properties.txt").getFile());
        File invalidProperties = new File(this.getClass().getResource("simple_format_invalid_properties.txt").getFile());
        File invalidHeader = new File(this.getClass().getResource("simple_format_no_header.txt").getFile());
        File invalidType = new File(this.getClass().getResource("simple_format_invalid_type.txt").getFile());
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)this.csvProductReaderPlugIn.getDecodeQualification((Object)validFile));
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)this.csvProductReaderPlugIn.getDecodeQualification((Object)validFileWithoutProperties));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.csvProductReaderPlugIn.getDecodeQualification((Object)invalidProperties));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.csvProductReaderPlugIn.getDecodeQualification((Object)invalidHeader));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.csvProductReaderPlugIn.getDecodeQualification((Object)invalidType));
    }

    @Test
    public void testGetFormatNames() throws Exception {
        Assert.assertEquals((Object)"CSV", (Object)this.csvProductReaderPlugIn.getFormatNames()[0]);
    }

    @Test
    public void testGetDescription() throws Exception {
        Assert.assertEquals((Object)"CSV products", (Object)this.csvProductReaderPlugIn.getDescription(null));
    }
}

