/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.writer;

import org.esa.snap.csv.dataio.writer.CsvWriter;
import org.esa.snap.csv.dataio.writer.CsvWriterBuilder;
import org.esa.snap.csv.dataio.writer.FeatureCsvWriter;
import org.esa.snap.csv.dataio.writer.OutputFormat;
import org.esa.snap.csv.dataio.writer.PixelCsvWriter;
import org.esa.snap.csv.dataio.writer.SourceType;
import org.esa.snap.csv.dataio.writer.TargetType;
import org.junit.Assert;
import org.junit.Test;

public class CsvWriterBuilderTest {
    @Test
    public void testTypes() throws Exception {
        CsvWriter productWriter = new CsvWriterBuilder().sourceType(SourceType.PRODUCT).targetType(TargetType.FILE).targetFormat(OutputFormat.BEAM).targetFile("target.csv").build();
        Assert.assertEquals(CsvWriterBuilder.ProductCsvWriter.class, productWriter.getClass());
        CsvWriter pixelWriter = new CsvWriterBuilder().sourceType(SourceType.PIXEL).targetType(TargetType.FILE).targetFormat(OutputFormat.ODESA).targetFile("target.csv").build();
        Assert.assertEquals(PixelCsvWriter.class, pixelWriter.getClass());
        CsvWriter featureWriter = new CsvWriterBuilder().sourceType(SourceType.FEATURE).targetType(TargetType.FILE).targetFormat(OutputFormat.ODESA).targetFile("target.csv").build();
        Assert.assertEquals(FeatureCsvWriter.class, featureWriter.getClass());
    }

    @Test
    public void testValidation() throws Exception {
        try {
            new CsvWriterBuilder().build();
            Assert.fail();
        }
        catch (IllegalStateException expected) {
            this.validateException(expected.getMessage(), "missing source type");
        }
        try {
            new CsvWriterBuilder().sourceType(SourceType.FEATURE).targetType(TargetType.CLIPBOARD).targetFile("").build();
            Assert.fail();
        }
        catch (IllegalStateException expected) {
            this.validateException(expected.getMessage(), "both clipboard and target file");
        }
        try {
            new CsvWriterBuilder().sourceType(SourceType.FEATURE).targetType(TargetType.FILE).build();
            Assert.fail();
        }
        catch (IllegalStateException expected) {
            this.validateException(expected.getMessage(), "No target file specified");
        }
    }

    private void validateException(String message, String error) {
        Assert.assertTrue((boolean)message.contains(error));
    }
}

